/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.jfr.RecordingState;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.PlatformRecording;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.settings.CutoffSetting;
import jdk.jfr.internal.test.WhiteBox;

public final class OldObjectSample {
    private static final String EVENT_NAME = "jdk.OldObjectSample";
    private static final String OLD_OBJECT_CUTOFF = "jdk.OldObjectSample#cutoff";
    private static final String OLD_OBJECT_ENABLED = "jdk.OldObjectSample#enabled";

    public static void emit(PlatformRecording platformRecording) {
        if (OldObjectSample.isEnabled(platformRecording)) {
            long l = CutoffSetting.parseValueSafe(platformRecording.getSettings().get(OLD_OBJECT_CUTOFF));
            long l2 = Utils.nanosToTicks(l);
            JVM.getJVM().emitOldObjectSamples(l2, WhiteBox.getWriteAllObjectSamples());
        }
    }

    public static void emit(List<PlatformRecording> list, Boolean bl) {
        boolean bl2 = false;
        long l = Boolean.TRUE.equals(bl) ? Long.MAX_VALUE : 0L;
        for (PlatformRecording platformRecording : list) {
            if (platformRecording.getState() != RecordingState.RUNNING || !OldObjectSample.isEnabled(platformRecording)) continue;
            bl2 = true;
            long l2 = CutoffSetting.parseValueSafe(platformRecording.getSettings().get(OLD_OBJECT_CUTOFF));
            l = Math.max(l2, l);
        }
        if (bl2) {
            long l3 = Utils.nanosToTicks(l);
            JVM.getJVM().emitOldObjectSamples(l3, WhiteBox.getWriteAllObjectSamples());
        }
    }

    public static void updateSettingPathToGcRoots(Map<String, String> map, Boolean bl) {
        if (bl != null) {
            map.put(OLD_OBJECT_CUTOFF, bl != false ? "infinity" : "0 ns");
        }
    }

    public static Map<String, String> createSettingsForSnapshot(PlatformRecording platformRecording, Boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>(platformRecording.getSettings());
        OldObjectSample.updateSettingPathToGcRoots(hashMap, bl);
        return hashMap;
    }

    private static boolean isEnabled(PlatformRecording platformRecording) {
        Map<String, String> map = platformRecording.getSettings();
        String string = map.get(OLD_OBJECT_ENABLED);
        return "true".equals(string);
    }
}

