/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.graph;

import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.NbBundle;

public class HasSelfLoopBuilder
implements FilterBuilder {
    public Category getCategory() {
        return FilterLibrary.TOPOLOGY;
    }

    public String getName() {
        return NbBundle.getMessage(HasSelfLoopBuilder.class, (String)"HasSelfLoopBuilder.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(HasSelfLoopBuilder.class, (String)"HasSelfLoopBuilder.description");
    }

    public Filter getFilter(Workspace workspace) {
        return new HasSelfLoopFilter();
    }

    public JPanel getPanel(Filter filter) {
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class HasSelfLoopFilter
    implements NodeFilter {
        public boolean init(Graph graph) {
            return true;
        }

        public boolean evaluate(Graph graph, Node node) {
            EdgeIterable edgeIterable = graph.getEdges(node);
            for (Edge e : edgeIterable) {
                if (!e.isSelfLoop()) continue;
                edgeIterable.doBreak();
                return true;
            }
            return false;
        }

        public void finish() {
        }

        public String getName() {
            return NbBundle.getMessage(HasSelfLoopBuilder.class, (String)"HasSelfLoopBuilder.name");
        }

        public FilterProperty[] getProperties() {
            return new FilterProperty[0];
        }
    }
}

