/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.importer.plugin.spreadsheet.wizard;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.io.importer.plugin.file.spreadsheet.AbstractImporterSpreadsheet;
import org.gephi.io.importer.plugin.file.spreadsheet.process.SpreadsheetGeneralConfiguration;
import org.gephi.ui.importer.plugin.spreadsheet.wizard.WizardPanel2;
import org.gephi.ui.utils.SupportedColumnTypeWrapper;
import org.gephi.ui.utils.TimeRepresentationWrapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class WizardVisualPanel2
extends JPanel {
    private static final String ASSIGN_NEW_NODES_IDS_SAVED_PREFERENCES = "WizardVisualPanel2_assign_new_nodes_ids";
    private static final String CREATE_NEW_NODES_SAVED_PREFERENCES = "WizardVisualPanel2_create_new_nodes";
    private final WizardPanel2 wizard2;
    private final ArrayList<JCheckBox> columnsCheckBoxes = new ArrayList();
    private final ArrayList<JComboBox> columnsComboBoxes = new ArrayList();
    private final AbstractImporterSpreadsheet importer;
    private JComboBox timeRepresentationComboBox = new JComboBox();
    private JScrollPane scroll;

    public WizardVisualPanel2(final AbstractImporterSpreadsheet importer, WizardPanel2 wizard2) {
        this.initComponents();
        this.importer = importer;
        this.wizard2 = wizard2;
        this.timeRepresentationComboBox = new JComboBox();
        for (TimeRepresentation value : TimeRepresentation.values()) {
            this.timeRepresentationComboBox.addItem(new TimeRepresentationWrapper(value));
        }
        this.timeRepresentationComboBox.setSelectedItem(new TimeRepresentationWrapper(importer.getTimeRepresentation()));
        this.timeRepresentationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                importer.setTimeRepresentation(WizardVisualPanel2.this.getSelectedTimeRepresentation());
                WizardVisualPanel2.this.reloadSettings();
            }
        });
    }

    public void reloadSettings() {
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout((LayoutManager)new MigLayout("fillx"));
        this.createTimeRepresentationComboBox(settingsPanel);
        settingsPanel.add((Component)new JSeparator(), "growx, wrap");
        this.loadColumns(settingsPanel);
        this.scroll.setViewportView(settingsPanel);
        this.wizard2.fireChangeEvent();
    }

    private void createTimeRepresentationComboBox(JPanel settingsPanel) {
        JLabel timeRepresentationLabel = new JLabel(this.getMessage("WizardVisualPanel2.timeRepresentationLabel.text"));
        settingsPanel.add((Component)timeRepresentationLabel, "wrap");
        settingsPanel.add((Component)this.timeRepresentationComboBox, "wrap 15px");
    }

    private void loadColumns(JPanel settingsPanel) {
        try {
            this.columnsCheckBoxes.clear();
            this.columnsComboBoxes.clear();
            JLabel columnsLabel = new JLabel(this.getMessage("WizardVisualPanel2.columnsLabel.text"));
            settingsPanel.add((Component)columnsLabel, "wrap");
            String[] headers = this.importer.getHeadersMap().keySet().toArray(new String[0]);
            SpreadsheetGeneralConfiguration.Mode mode = this.importer.getMode();
            for (String header : headers) {
                if (header.isEmpty()) continue;
                JCheckBox columnCheckBox = new JCheckBox(header, true);
                if (this.importer.getMode() == SpreadsheetGeneralConfiguration.Mode.EDGES_TABLE && (header.equalsIgnoreCase("source") || header.equalsIgnoreCase("target"))) {
                    columnCheckBox.setEnabled(false);
                }
                this.columnsCheckBoxes.add(columnCheckBox);
                JComboBox columnComboBox = new JComboBox();
                if (mode.isSpecialColumn(header)) {
                    settingsPanel.add((Component)columnCheckBox, "wrap 15px");
                    this.columnsComboBoxes.add(null);
                    continue;
                }
                settingsPanel.add((Component)columnCheckBox, "wrap");
                this.columnsComboBoxes.add(columnComboBox);
                this.fillComboBoxWithColumnTypes(header, columnComboBox);
                settingsPanel.add(columnComboBox, "wrap 15px");
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void fillComboBoxWithColumnTypes(String column, JComboBox comboBox) {
        SupportedColumnTypeWrapper selection;
        comboBox.removeAllItems();
        List supportedTypesWrappers = SupportedColumnTypeWrapper.buildOrderedSupportedTypesList((TimeRepresentation)this.importer.getTimeRepresentation());
        for (SupportedColumnTypeWrapper supportedColumnTypeWrapper : supportedTypesWrappers) {
            comboBox.addItem(supportedColumnTypeWrapper);
        }
        Class<String> defaultClass = this.importer.getColumnClass(column);
        if (defaultClass == null) {
            defaultClass = String.class;
        }
        if (!supportedTypesWrappers.contains(selection = new SupportedColumnTypeWrapper(defaultClass))) {
            selection = new SupportedColumnTypeWrapper(String.class);
        }
        comboBox.setSelectedItem(selection);
    }

    public TimeRepresentation getSelectedTimeRepresentation() {
        return ((TimeRepresentationWrapper)this.timeRepresentationComboBox.getSelectedItem()).getTimeRepresentation();
    }

    public String[] getColumnsToImport() {
        ArrayList<String> columns = new ArrayList<String>();
        for (JCheckBox columnCheckBox : this.columnsCheckBoxes) {
            if (!columnCheckBox.isSelected()) continue;
            columns.add(columnCheckBox.getText());
        }
        return columns.toArray(new String[0]);
    }

    public Class[] getColumnsToImportTypes() {
        ArrayList<Class> types = new ArrayList<Class>();
        for (int i = 0; i < this.columnsCheckBoxes.size(); ++i) {
            if (!this.columnsCheckBoxes.get(i).isSelected()) continue;
            JComboBox columnComboBox = this.columnsComboBoxes.get(i);
            Class type = columnComboBox != null ? ((SupportedColumnTypeWrapper)columnComboBox.getSelectedItem()).getType() : String.class;
            types.add(type);
        }
        return types.toArray(new Class[0]);
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(WizardVisualPanel2.class, (String)"WizardVisualPanel2.name");
    }

    private String getMessage(String resName) {
        return NbBundle.getMessage(WizardVisualPanel2.class, (String)resName);
    }

    private void initComponents() {
        this.scroll = new JScrollPane();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll, -1, 290, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll, -1, 320, Short.MAX_VALUE));
    }
}

