/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Group;
import io.cucumber.cucumberexpressions.ParameterType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class Argument<T> {
    private final ParameterType<T> parameterType;
    private final Group group;

    static List<Argument<?>> build(Group group, List<ParameterType<?>> parameterTypes) {
        List<Group> argGroups = group.getChildren();
        if (argGroups.size() != parameterTypes.size()) {
            throw new IllegalArgumentException(String.format("Group has %s capture groups, but there were %s parameter types", argGroups.size(), parameterTypes.size()));
        }
        ArrayList args = new ArrayList(argGroups.size());
        for (int i = 0; i < parameterTypes.size(); ++i) {
            Group argGroup = argGroups.get(i);
            ParameterType<?> parameterType = parameterTypes.get(i);
            args.add(new Argument(argGroup, parameterType));
        }
        return args;
    }

    private Argument(Group group, ParameterType<T> parameterType) {
        this.group = group;
        this.parameterType = parameterType;
    }

    public Group getGroup() {
        return this.group;
    }

    public T getValue() {
        return this.parameterType.transform(this.group.getValues());
    }

    public Type getType() {
        return this.parameterType.getType();
    }

    public ParameterType<T> getParameterType() {
        return this.parameterType;
    }
}

