﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/TableOptimizer.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {

/**
 * <p>Contains details for one of the table optimizers returned by the
 * <code>BatchGetTableOptimizer</code> operation.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchTableOptimizer">AWS
 * API Reference</a></p>
 */
class BatchTableOptimizer {
 public:
  AWS_GLUE_API BatchTableOptimizer() = default;
  AWS_GLUE_API BatchTableOptimizer(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API BatchTableOptimizer& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Catalog ID of the table.</p>
   */
  inline const Aws::String& GetCatalogId() const { return m_catalogId; }
  inline bool CatalogIdHasBeenSet() const { return m_catalogIdHasBeenSet; }
  template <typename CatalogIdT = Aws::String>
  void SetCatalogId(CatalogIdT&& value) {
    m_catalogIdHasBeenSet = true;
    m_catalogId = std::forward<CatalogIdT>(value);
  }
  template <typename CatalogIdT = Aws::String>
  BatchTableOptimizer& WithCatalogId(CatalogIdT&& value) {
    SetCatalogId(std::forward<CatalogIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the database in the catalog in which the table resides.</p>
   */
  inline const Aws::String& GetDatabaseName() const { return m_databaseName; }
  inline bool DatabaseNameHasBeenSet() const { return m_databaseNameHasBeenSet; }
  template <typename DatabaseNameT = Aws::String>
  void SetDatabaseName(DatabaseNameT&& value) {
    m_databaseNameHasBeenSet = true;
    m_databaseName = std::forward<DatabaseNameT>(value);
  }
  template <typename DatabaseNameT = Aws::String>
  BatchTableOptimizer& WithDatabaseName(DatabaseNameT&& value) {
    SetDatabaseName(std::forward<DatabaseNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the table.</p>
   */
  inline const Aws::String& GetTableName() const { return m_tableName; }
  inline bool TableNameHasBeenSet() const { return m_tableNameHasBeenSet; }
  template <typename TableNameT = Aws::String>
  void SetTableName(TableNameT&& value) {
    m_tableNameHasBeenSet = true;
    m_tableName = std::forward<TableNameT>(value);
  }
  template <typename TableNameT = Aws::String>
  BatchTableOptimizer& WithTableName(TableNameT&& value) {
    SetTableName(std::forward<TableNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A <code>TableOptimizer</code> object that contains details on the
   * configuration and last run of a table optimizer.</p>
   */
  inline const TableOptimizer& GetTableOptimizer() const { return m_tableOptimizer; }
  inline bool TableOptimizerHasBeenSet() const { return m_tableOptimizerHasBeenSet; }
  template <typename TableOptimizerT = TableOptimizer>
  void SetTableOptimizer(TableOptimizerT&& value) {
    m_tableOptimizerHasBeenSet = true;
    m_tableOptimizer = std::forward<TableOptimizerT>(value);
  }
  template <typename TableOptimizerT = TableOptimizer>
  BatchTableOptimizer& WithTableOptimizer(TableOptimizerT&& value) {
    SetTableOptimizer(std::forward<TableOptimizerT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_catalogId;

  Aws::String m_databaseName;

  Aws::String m_tableName;

  TableOptimizer m_tableOptimizer;
  bool m_catalogIdHasBeenSet = false;
  bool m_databaseNameHasBeenSet = false;
  bool m_tableNameHasBeenSet = false;
  bool m_tableOptimizerHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
