/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.google.zxing.qrcode;

import java.util.Hashtable;
import zext.plantuml.com.google.zxing.BarcodeFormat;
import zext.plantuml.com.google.zxing.EncodeHintType;
import zext.plantuml.com.google.zxing.Writer;
import zext.plantuml.com.google.zxing.WriterException;
import zext.plantuml.com.google.zxing.common.BitMatrix;
import zext.plantuml.com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import zext.plantuml.com.google.zxing.qrcode.encoder.ByteMatrix;
import zext.plantuml.com.google.zxing.qrcode.encoder.Encoder;
import zext.plantuml.com.google.zxing.qrcode.encoder.QRCode;

public final class QRCodeWriter
implements Writer {
    private static final int QUIET_ZONE_SIZE = 4;

    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int multiple) throws WriterException {
        return this.encode(contents, format, multiple, null);
    }

    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int multiple, Hashtable hints) throws WriterException {
        ErrorCorrectionLevel requestedECLevel;
        if (contents == null || contents.length() == 0) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (format != BarcodeFormat.QR_CODE) {
            throw new IllegalArgumentException("Can only encode QR_CODE, but got " + format);
        }
        ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.L;
        if (hints != null && (requestedECLevel = (ErrorCorrectionLevel)hints.get(EncodeHintType.ERROR_CORRECTION)) != null) {
            errorCorrectionLevel = requestedECLevel;
        }
        QRCode code = new QRCode();
        Encoder.encode(contents, errorCorrectionLevel, hints, code);
        return QRCodeWriter.renderResult(code, multiple);
    }

    private static BitMatrix renderResult(QRCode code, int multiple) {
        ByteMatrix input = code.getMatrix();
        int inputWidth = input.getWidth();
        int inputHeight = input.getHeight();
        int qrWidth = inputWidth + 8;
        int qrHeight = inputHeight + 8;
        int leftPadding = 4 * multiple;
        int topPadding = 4 * multiple;
        BitMatrix output = new BitMatrix(qrWidth * multiple, qrHeight * multiple);
        int inputY = 0;
        int outputY = topPadding;
        while (inputY < inputHeight) {
            int inputX = 0;
            int outputX = leftPadding;
            while (inputX < inputWidth) {
                if (input.get(inputX, inputY) == 1) {
                    output.setRegion(outputX, outputY, multiple, multiple);
                }
                ++inputX;
                outputX += multiple;
            }
            ++inputY;
            outputY += multiple;
        }
        return output;
    }
}

