/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;

public abstract class AbstractStatePlayer
extends Player {
    private final Set<ChangeState> changes = new TreeSet<ChangeState>();
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    private final Map<String, String> statesLabel = new LinkedHashMap<String, String>();
    private String initialState;
    private Colors initialColors;
    private final double constraintOffset;

    public AbstractStatePlayer(String full, ISkinParam skinParam, TimingRuler ruler, boolean compact, Stereotype stereotype, HColor generalBackgroundColor, SName sname, double constraintOffset) {
        super(full, skinParam, ruler, compact, stereotype, generalBackgroundColor, sname, 0);
        this.constraintOffset = constraintOffset;
    }

    @Override
    public final void createConstraint(TimeTick tick1, TimeTick tick2, String message, ArrowConfiguration config) {
        this.constraints.add(new TimeConstraint(this.constraintOffset, tick1, tick2, message, this.getSkinParam(), config));
    }

    @Override
    public final void setState(TimeTick now, String comment, Colors color, String ... states) {
        for (int i = 0; i < states.length; ++i) {
            states[i] = this.decodeState(states[i]);
        }
        if (now == null) {
            this.initialState = states[0];
            this.initialColors = color;
        } else {
            this.changes.add(new ChangeState(now, comment, color, states));
        }
    }

    private String decodeState(String code) {
        String label = this.statesLabel.get(code);
        if (label == null) {
            return code;
        }
        return label;
    }

    @Override
    public final void defineState(String stateCode, String label) {
        this.statesLabel.put(stateCode, label);
    }

    protected final Set<ChangeState> getChanges() {
        return this.changes;
    }

    protected final List<TimeConstraint> getConstraints() {
        return this.constraints;
    }

    protected final Map<String, String> getStatesLabel() {
        return this.statesLabel;
    }

    protected final String getInitialState() {
        return this.initialState;
    }

    protected final Colors getInitialColors() {
        return this.initialColors;
    }
}

