/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.api.cheerpj.v1;

import com.plantuml.api.cheerpj.JsonResult;
import com.plantuml.api.cheerpj.Utils;
import com.plantuml.api.cheerpj.WasmLog;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.preproc.Defines;

public class Info {
    public static Object decode(String text) {
        String result;
        try {
            result = TranscoderUtil.getDefaultTranscoder().decode(text);
        }
        catch (NoPlantumlCompressionException e) {
            e.printStackTrace();
            result = "";
        }
        return result;
    }

    public static Object encode(String text) {
        String result;
        try {
            result = TranscoderUtil.getDefaultTranscoder().encode(text);
        }
        catch (IOException e) {
            e.printStackTrace();
            result = "";
        }
        return result;
    }

    public static Object syntaxCheck(String text) {
        long start;
        WasmLog.start = start = System.currentTimeMillis();
        WasmLog.log("Starting processing");
        try {
            text = Utils.cleanText(text);
            BlockUmlBuilder builder = new BlockUmlBuilder(Collections.emptyList(), StandardCharsets.UTF_8, Defines.createEmpty(), new StringReader(text), null, "string");
            List<BlockUml> blocks = builder.getBlockUmls();
            if (blocks.size() == 0) {
                return JsonResult.noDataFound(start);
            }
            Diagram system = blocks.get(0).getDiagram();
            if (system instanceof PSystemError) {
                ErrorUml error = ((PSystemError)system).getFirstError();
                WasmLog.log("[" + error.getPosition() + "] " + error.getError());
                return JsonResult.fromError(start, (PSystemError)system);
            }
            return JsonResult.ok(start, null, system);
        }
        catch (Throwable t) {
            WasmLog.log("Fatal error " + t);
            return JsonResult.fromCrash(start, t);
        }
    }
}

