/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.eps;

import java.io.UnsupportedEncodingException;
import net.sourceforge.plantuml.klimt.drawing.eps.EpsGraphicsMacro;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontContext;

public class EpsGraphicsMacroAndText
extends EpsGraphicsMacro {
    public void drawText(String text, FontConfiguration fontConfiguration, double x, double y) {
        this.append(EpsGraphicsMacroAndText.format(x) + " " + EpsGraphicsMacroAndText.format(y) + " moveto", true);
        this.appendColor(this.getColor());
        UFont font = fontConfiguration.getFont();
        int size = font.getSize();
        this.append("/" + this.getPSName(text, fontConfiguration) + " findfont " + size + " scalefont setfont", true);
        this.append("100 -100 scale", true);
        this.append("(" + this.getTextAsEps(text) + ") show", false);
        this.append(".01 -.01 scale", true);
    }

    private String getPSName(String text, FontConfiguration fontConfiguration) {
        UFont font = fontConfiguration.getFont();
        StringBuilder sb = new StringBuilder(font.getFamily(text, UFontContext.EPS));
        return sb.toString();
    }

    private String getTextAsEps(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '(') {
                sb.append("\\(");
                continue;
            }
            if (c == ')') {
                sb.append("\\)");
                continue;
            }
            if (c < ' ') {
                sb.append("?");
                continue;
            }
            if (c >= ' ' && c <= '\u007f') {
                sb.append(c);
                continue;
            }
            String s = "" + c;
            try {
                byte[] b = s.getBytes("ISO-8859-1");
                if (b.length == 1) {
                    int code = b[0] & 0xFF;
                    sb.append("\\" + Integer.toOctalString(code));
                    continue;
                }
                sb.append('?');
                continue;
            }
            catch (UnsupportedEncodingException e) {
                sb.append('?');
            }
        }
        return sb.toString();
    }
}

