"""

 @file enum.py

 SPM python wrapper to define enums and datatypes

 @copyright 2017-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
                      Univ. Bordeaux. All rights reserved.

 @version 1.2.4
 @author Pierre Ramet
 @author Mathieu Faverge
 @author Tony Delarue
 @date 2024-06-27

 This file has been automatically generated with gen_wrappers.py

 @ingroup wrap_python

"""
from ctypes import *
import numpy as np

# Start with __ to prevent broadcast to file importing enum
__spm_int__ = c_int
__spm_mpi_enabled__ = 1

class verbose:
    Not = 0
    No  = 1
    Yes = 2

class coeftype:
    Pattern   = 0
    Float     = 2
    Double    = 3
    Complex32 = 4
    Complex64 = 5

    @staticmethod
    def getptype ( dtype ):
        np_dict = {
            np.dtype('float32')    : coeftype.Float,
            np.dtype('float64')    : coeftype.Double,
            np.dtype('complex64')  : coeftype.Complex32,
            np.dtype('complex128') : coeftype.Complex64,
        }
        if dtype in np_dict:
            return np_dict[dtype]
        else:
            return -1

    @staticmethod
    def getctype ( flttype ):
        class c_float_complex(Structure):
            _fields_ = [("r",c_float),("i", c_float)]
        class c_double_complex(Structure):
            _fields_ = [("r",c_double),("i", c_double)]

        np_dict = {
            coeftype.Float     : c_float,
            coeftype.Double    : c_double,
            coeftype.Complex32 : c_float_complex,
            coeftype.Complex64 : c_double_complex
        }
        if flttype in np_dict:
            return np_dict[flttype]
        else:
            return -1

    @staticmethod
    def getnptype ( flttype ):
        np_dict = {
            coeftype.Float     : np.dtype('float32'),
            coeftype.Double    : np.dtype('float64'),
            coeftype.Complex32 : np.dtype('complex64'),
            coeftype.Complex64 : np.dtype('complex128')
        }
        if flttype in np_dict:
            return np_dict[flttype]
        else:
            return -1

class fmttype:
    CSC = 0
    CSR = 1
    IJV = 2

class error:
    SUCCESS        = 0
    UNKNOWN        = 1
    ALLOC          = 2
    NOTIMPLEMENTED = 3
    OUTOFMEMORY    = 4
    THREAD         = 5
    INTERNAL       = 6
    BADPARAMETER   = 7
    FILE           = 8
    INTEGER_TYPE   = 9
    IO             = 10
    MPI            = 11

class driver:
    RSA        = 0
    HB         = 1
    IJV        = 2
    MM         = 3
    Laplacian  = 4
    XLaplacian = 5
    Graph      = 6
    SPM        = 7

class rhstype:
    One  = 0
    I    = 1
    RndX = 2
    RndB = 3

class layout:
    RowMajor = 101
    ColMajor = 102

class trans:
    NoTrans   = 111
    Trans     = 112
    ConjTrans = 113

class mtxtype:
    General   = trans.NoTrans
    Symmetric = trans.Trans
    Hermitian = trans.ConjTrans
    SymPosDef = trans.ConjTrans + 1
    HerPosDef = trans.ConjTrans + 2

class uplo:
    Upper      = 121
    Lower      = 122
    UpperLower = 123

class diag:
    NonUnit = 131
    Unit    = 132

class side:
    Left  = 141
    Right = 142

class normtype:
    One       = 171
    Frobenius = 174
    Inf       = 175
    Max       = 177

class dir:
    Forward  = 391
    Backward = 392

