/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.connector;

import java.io.IOException;
import java.util.HashMap;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorInput;
import org.opensearch.ml.common.utils.FieldDescriptor;
import org.opensearch.ml.common.utils.StringUtils;

public class MLUpdateConnectorRequest
extends ActionRequest {
    String connectorId;
    MLCreateConnectorInput updateContent;

    public MLUpdateConnectorRequest(String connectorId, MLCreateConnectorInput updateContent) {
        this.connectorId = connectorId;
        this.updateContent = updateContent;
    }

    public MLUpdateConnectorRequest(StreamInput in) throws IOException {
        super(in);
        this.connectorId = in.readString();
        this.updateContent = new MLCreateConnectorInput(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.connectorId);
        this.updateContent.writeTo(out);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.connectorId == null) {
            exception = ValidateActions.addValidationError((String)"ML connector id can't be null", exception);
        }
        if (this.updateContent == null) {
            exception = ValidateActions.addValidationError((String)"Update connector content can't be null", (ActionRequestValidationException)exception);
        } else {
            HashMap<String, FieldDescriptor> fieldsToValidate = new HashMap<String, FieldDescriptor>();
            fieldsToValidate.put("Model connector name", new FieldDescriptor(this.updateContent.getName(), false));
            fieldsToValidate.put("Model connector description", new FieldDescriptor(this.updateContent.getDescription(), false));
            exception = StringUtils.validateFields(fieldsToValidate);
        }
        return exception;
    }

    public static MLUpdateConnectorRequest parse(XContentParser parser, String connectorId, String tenantId) throws IOException {
        MLCreateConnectorInput updateContent = MLCreateConnectorInput.parse(parser, true);
        updateContent.setTenantId(tenantId);
        return MLUpdateConnectorRequest.builder().connectorId(connectorId).updateContent(updateContent).build();
    }

    /*
     * Exception decompiling
     */
    public static MLUpdateConnectorRequest fromActionRequest(ActionRequest actionRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Generated
    public static MLUpdateConnectorRequestBuilder builder() {
        return new MLUpdateConnectorRequestBuilder();
    }

    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @Generated
    public MLCreateConnectorInput getUpdateContent() {
        return this.updateContent;
    }

    @Generated
    public static class MLUpdateConnectorRequestBuilder {
        @Generated
        private String connectorId;
        @Generated
        private MLCreateConnectorInput updateContent;

        @Generated
        MLUpdateConnectorRequestBuilder() {
        }

        @Generated
        public MLUpdateConnectorRequestBuilder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        @Generated
        public MLUpdateConnectorRequestBuilder updateContent(MLCreateConnectorInput updateContent) {
            this.updateContent = updateContent;
            return this;
        }

        @Generated
        public MLUpdateConnectorRequest build() {
            return new MLUpdateConnectorRequest(this.connectorId, this.updateContent);
        }

        @Generated
        public String toString() {
            return "MLUpdateConnectorRequest.MLUpdateConnectorRequestBuilder(connectorId=" + this.connectorId + ", updateContent=" + String.valueOf(this.updateContent) + ")";
        }
    }
}

