/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.sgd.fm;

import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Options;
import com.oracle.labs.mlrg.olcut.config.UsageException;
import java.io.IOException;
import java.util.logging.Logger;
import org.tribuo.Trainer;
import org.tribuo.classification.TrainTestHelper;
import org.tribuo.classification.ensemble.ClassificationEnsembleOptions;
import org.tribuo.classification.sgd.fm.FMClassificationOptions;
import org.tribuo.classification.sgd.fm.FMClassificationTrainer;
import org.tribuo.data.DataOptions;

public class TrainTest {
    private static final Logger logger = Logger.getLogger(TrainTest.class.getName());

    public static void main(String[] args) throws IOException {
        TrainTestOptions o = new TrainTestOptions();
        try (ConfigurationManager cm = new ConfigurationManager(args, (Options)o);){
            FMClassificationTrainer trainer = o.trainerOptions.getTrainer();
            trainer = o.ensembleOptions.wrapTrainer((Trainer)trainer);
            TrainTestHelper.run((ConfigurationManager)cm, (DataOptions)o.general, (Trainer)trainer);
        }
        catch (UsageException e) {
            logger.info(e.getMessage());
        }
    }

    public static class TrainTestOptions
    implements Options {
        public DataOptions general;
        public FMClassificationOptions trainerOptions;
        public ClassificationEnsembleOptions ensembleOptions;

        public String getOptionsDescription() {
            return "Trains and tests a linear SGD model on the specified datasets.";
        }
    }
}

