/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.model.MLModelGetAction;
import org.opensearch.ml.common.transport.model.MLModelGetRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLGetModelAction
extends BaseRestHandler {
    private static final String ML_GET_MODEL_ACTION = "ml_get_model_action";
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLGetModelAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_GET_MODEL_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/models/{%s}", "/_plugins/_ml", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLModelGetRequest mlModelGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLModelGetAction.INSTANCE, (ActionRequest)mlModelGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLModelGetRequest getRequest(RestRequest request) throws IOException {
        String modelId = RestActionUtils.getParameterId(request, "model_id");
        boolean returnContent = RestActionUtils.returnContent(request);
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        return new MLModelGetRequest(modelId, returnContent, true, tenantId);
    }
}

