/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.UTFDataFormatException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.sql.SQLException;
import oracle.i18n.text.OraCharset;
import oracle.i18n.text.OraCharsetDecoder;
import oracle.i18n.text.OraCharsetEncoder;
import oracle.i18n.text.converter.GDKMessage;

class OraCharsetAL32UTF8
extends OraCharset {
    OraCharsetAL32UTF8(String string, int n) {
        super(string, n);
    }

    @Override
    public boolean contains(Charset charset) {
        return true;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new OraCharsetDecoder(this, 1.0f, 1.0f);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new OraCharsetEncoder(this, 1.0f, 4.0f);
    }

    @Override
    String toStringWithReplacement(byte[] byArray, int n, int n2) {
        try {
            char[] cArray = new char[byArray.length];
            int n3 = OraCharsetAL32UTF8.AL32UTF8ToJavaChar(byArray, n, n2, cArray, OraCharset.CharacterConverterBehavior.REPLACEMENT);
            return new String(cArray, 0, n3);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return "";
        }
    }

    @Override
    String toString(byte[] byArray, int n, int n2) throws SQLException {
        try {
            char[] cArray = new char[byArray.length];
            int n3 = OraCharsetAL32UTF8.AL32UTF8ToJavaChar(byArray, n, n2, cArray, OraCharset.CharacterConverterBehavior.REPORT_ERROR);
            return new String(cArray, 0, n3);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new SQLException(GDKMessage.getORAMessage(17037));
        }
    }

    @Override
    byte[] convertWithReplacement(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length * 3];
        int n = OraCharsetAL32UTF8.javaCharsToAL32UTF8(cArray, 0, cArray.length, byArray, 0);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    @Override
    byte[] convert(String string) throws SQLException {
        return this.convertWithReplacement(string);
    }
}

