/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.owasp.html.Strings;
import org.owasp.html.TCB;
import org.owasp.shim.Java8Shim;

@TCB
public final class CssSchema {
    static final int BIT_QUANTITY = 1;
    static final int BIT_HASH_VALUE = 2;
    static final int BIT_NEGATIVE = 4;
    static final int BIT_STRING = 8;
    static final int BIT_URL = 16;
    static final int BIT_UNRESERVED_WORD = 64;
    static final int BIT_UNICODE_RANGE = 128;
    static final Property DISALLOWED = new Property(0, Collections.emptySet(), Collections.emptyMap());
    private final Map<String, Property> properties;
    static final Map<String, Property> DEFINITIONS;
    static final Set<String> DEFAULT_WHITELIST;
    public static final CssSchema DEFAULT;

    private CssSchema(Map<String, Property> properties) {
        if (properties == null) {
            throw new NullPointerException();
        }
        this.properties = properties;
    }

    public static CssSchema withProperties(Iterable<? extends String> propertyNames) {
        HashMap<String, Property> propertiesBuilder = new HashMap<String, Property>();
        for (String string : propertyNames) {
            Property prop = DEFINITIONS.get(string);
            if (prop == null) {
                throw new IllegalArgumentException(string);
            }
            propertiesBuilder.put(string, prop);
        }
        return new CssSchema(Collections.unmodifiableMap(propertiesBuilder));
    }

    public static CssSchema withProperties(Map<? extends String, ? extends Property> properties) {
        HashMap<String, Property> propertyMapBuilder = new HashMap<String, Property>();
        for (Map.Entry<? extends String, ? extends Property> e : properties.entrySet()) {
            Property property = e.getValue();
            for (String fnKey : property.fnKeys.values()) {
                if (properties.containsKey(fnKey)) continue;
                throw new IllegalArgumentException("Property map is not self contained.  " + String.valueOf(e.getValue()) + " depends on undefined function key " + fnKey);
            }
            propertyMapBuilder.put(e.getKey(), e.getValue());
        }
        return new CssSchema(Collections.unmodifiableMap(propertyMapBuilder));
    }

    public static CssSchema union(CssSchema ... cssSchemas) {
        if (cssSchemas.length == 1) {
            return cssSchemas[0];
        }
        LinkedHashMap<String, Property> propertyMapBuilder = new LinkedHashMap<String, Property>();
        for (CssSchema cssSchema : cssSchemas) {
            for (Map.Entry<String, Property> e : cssSchema.properties.entrySet()) {
                String name = e.getKey();
                Property newProp = e.getValue();
                if (Objects.isNull(name)) {
                    throw new NullPointerException("An entry was returned with null key from cssSchema.properties");
                }
                if (Objects.isNull(newProp)) {
                    throw new NullPointerException("An entry was returned with null value from cssSchema.properties");
                }
                Property oldProp = propertyMapBuilder.put(name, newProp);
                if (oldProp == null || oldProp.equals(newProp)) continue;
                throw new IllegalArgumentException("Duplicate irreconcilable definitions for " + name);
            }
        }
        return new CssSchema(Collections.unmodifiableMap(propertyMapBuilder));
    }

    public Set<String> allowedProperties() {
        return this.properties.keySet();
    }

    Property forKey(String propertyName) {
        String propertyNameCanon = Strings.toLowerCase(propertyName);
        Property property = this.properties.get(propertyNameCanon);
        if (property != null) {
            return property;
        }
        int n = propertyNameCanon.length();
        if (n != 0 && propertyNameCanon.charAt(0) == '-') {
            String barePropertyNameCanon = CssSchema.stripVendorPrefix(propertyNameCanon);
            if (barePropertyNameCanon == null) {
                return DISALLOWED;
            }
            property = this.properties.get(barePropertyNameCanon);
            if (property != null) {
                return property;
            }
        }
        return DISALLOWED;
    }

    @Nullable
    private static String stripVendorPrefix(String cssKeyword) {
        int prefixLen = 0;
        if (cssKeyword.length() >= 2) {
            switch (cssKeyword.charAt(1)) {
                case 'm': {
                    if (cssKeyword.startsWith("-ms-")) {
                        prefixLen = 4;
                        break;
                    }
                    if (!cssKeyword.startsWith("-moz-")) break;
                    prefixLen = 5;
                    break;
                }
                case 'o': {
                    if (!cssKeyword.startsWith("-o-")) break;
                    prefixLen = 3;
                    break;
                }
                case 'w': {
                    if (!cssKeyword.startsWith("-webkit-")) break;
                    prefixLen = 8;
                    break;
                }
            }
        }
        return prefixLen == 0 ? null : cssKeyword.substring(prefixLen);
    }

    private static <T> Set<T> union(Set<T> ... subsets) {
        HashSet<T> all = new HashSet<T>();
        for (Set<T> subset : subsets) {
            all.addAll(subset);
        }
        return Collections.unmodifiableSet(all);
    }

    public static void main(String ... argv) {
        TreeSet<String> keys = new TreeSet<String>();
        TreeSet<String> literals = new TreeSet<String>();
        for (Map.Entry<String, Property> e : DEFINITIONS.entrySet()) {
            keys.add(e.getKey());
            literals.addAll(e.getValue().literals);
        }
        System.out.println("# Below two blocks of tokens.\n#\n# First are all property names.\n# Those followed by an asterisk (*) are in the default white-list.\n#\n# Second are the literal tokens recognized in any defined property\n# value.\n");
        for (String key : keys) {
            System.out.print(key);
            if (DEFAULT_WHITELIST.contains(key)) {
                System.out.print("*");
            }
            System.out.println();
        }
        System.out.println();
        for (String literal : literals) {
            System.out.println(literal);
        }
    }

    static {
        Map<String, String> zeroFns = Collections.emptyMap();
        HashMap<String, Property> builder = new HashMap<String, Property>();
        Set mozBorderRadiusLiterals0 = Java8Shim.j8().setOf((Object)"/");
        Set mozOpacityLiterals0 = Java8Shim.j8().setOf((Object)"inherit");
        Set mozOutlineLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "black", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen"});
        Set mozOutlineLiterals1 = Java8Shim.j8().setOf((Object[])new String[]{"dashed", "dotted", "double", "groove", "outset", "ridge", "solid"});
        Set mozOutlineLiterals2 = Java8Shim.j8().setOf((Object)"thick", (Object)"thin");
        Set mozOutlineLiterals3 = Java8Shim.j8().setOf((Object[])new String[]{"hidden", "inherit", "inset", "invert", "medium", "none"});
        Map mozOutlineFunctions = Java8Shim.j8().mapOfEntries(new Map.Entry[]{Java8Shim.j8().mapEntry((Object)"rgb(", (Object)"rgb()"), Java8Shim.j8().mapEntry((Object)"rgba(", (Object)"rgba()"), Java8Shim.j8().mapEntry((Object)"hsl(", (Object)"hsl()"), Java8Shim.j8().mapEntry((Object)"hsla(", (Object)"hsla()")});
        Set mozOutlineColorLiterals0 = Java8Shim.j8().setOf((Object)"inherit", (Object)"invert");
        Set mozOutlineStyleLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"hidden", "inherit", "inset", "none"});
        Set mozOutlineWidthLiterals0 = Java8Shim.j8().setOf((Object)"inherit", (Object)"medium");
        Set oTextOverflowLiterals0 = Java8Shim.j8().setOf((Object)"clip", (Object)"ellipsis");
        Set azimuthLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"behind", "center-left", "center-right", "far-left", "far-right", "left-side", "leftwards", "right-side", "rightwards"});
        Set azimuthLiterals1 = Java8Shim.j8().setOf((Object)"left", (Object)"right");
        Set azimuthLiterals2 = Java8Shim.j8().setOf((Object)"center", (Object)"inherit");
        Set backgroundLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"border-box", "contain", "content-box", "cover", "padding-box"});
        Set backgroundLiterals1 = Java8Shim.j8().setOf((Object[])new String[]{"no-repeat", "repeat-x", "repeat-y", "round", "space"});
        Set backgroundLiterals2 = Java8Shim.j8().setOf((Object)"bottom", (Object)"top");
        Set backgroundLiterals3 = Java8Shim.j8().setOf((Object[])new String[]{",", "/", "auto", "center", "fixed", "inherit", "local", "none", "repeat", "scroll", "transparent"});
        Map backgroundFunctions = Java8Shim.j8().mapOfEntries(new Map.Entry[]{Java8Shim.j8().mapEntry((Object)"image(", (Object)"image()"), Java8Shim.j8().mapEntry((Object)"linear-gradient(", (Object)"linear-gradient()"), Java8Shim.j8().mapEntry((Object)"radial-gradient(", (Object)"radial-gradient()"), Java8Shim.j8().mapEntry((Object)"repeating-linear-gradient(", (Object)"repeating-linear-gradient()"), Java8Shim.j8().mapEntry((Object)"repeating-radial-gradient(", (Object)"repeating-radial-gradient()"), Java8Shim.j8().mapEntry((Object)"rgb(", (Object)"rgb()"), Java8Shim.j8().mapEntry((Object)"rgba(", (Object)"rgba()"), Java8Shim.j8().mapEntry((Object)"hsl(", (Object)"hsl()"), Java8Shim.j8().mapEntry((Object)"hsla(", (Object)"hsla()")});
        Set backgroundAttachmentLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{",", "fixed", "local", "scroll"});
        Set backgroundColorLiterals0 = Java8Shim.j8().setOf((Object)"inherit", (Object)"transparent");
        Set backgroundImageLiterals0 = Java8Shim.j8().setOf((Object)",", (Object)"none");
        Map backgroundImageFunctions = Java8Shim.j8().mapOfEntries(new Map.Entry[]{Java8Shim.j8().mapEntry((Object)"image(", (Object)"image()"), Java8Shim.j8().mapEntry((Object)"linear-gradient(", (Object)"linear-gradient()"), Java8Shim.j8().mapEntry((Object)"radial-gradient(", (Object)"radial-gradient()"), Java8Shim.j8().mapEntry((Object)"repeating-linear-gradient(", (Object)"repeating-linear-gradient()"), Java8Shim.j8().mapEntry((Object)"repeating-radial-gradient(", (Object)"repeating-radial-gradient()")});
        Set backgroundPositionLiterals0 = Java8Shim.j8().setOf((Object)",", (Object)"center");
        Set backgroundRepeatLiterals0 = Java8Shim.j8().setOf((Object)",", (Object)"repeat");
        Set borderLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"hidden", "inherit", "inset", "medium", "none", "transparent"});
        Set borderCollapseLiterals0 = Java8Shim.j8().setOf((Object)"collapse", (Object)"inherit", (Object)"separate");
        Set bottomLiterals0 = Java8Shim.j8().setOf((Object)"auto", (Object)"inherit");
        Set boxShadowLiterals0 = Java8Shim.j8().setOf((Object)",", (Object)"inset", (Object)"none");
        Set clearLiterals0 = Java8Shim.j8().setOf((Object)"both", (Object)"inherit", (Object)"none");
        Map clipFunctions = Java8Shim.j8().mapOfEntries(new Map.Entry[]{Java8Shim.j8().mapEntry((Object)"rect(", (Object)"rect()")});
        Set contentLiterals0 = Java8Shim.j8().setOf((Object)"none", (Object)"normal");
        Set cueLiterals0 = Java8Shim.j8().setOf((Object)"inherit", (Object)"none");
        Set cursorLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"all-scroll", "col-resize", "crosshair", "default", "e-resize", "hand", "help", "move", "n-resize", "ne-resize", "no-drop", "not-allowed", "nw-resize", "pointer", "progress", "row-resize", "s-resize", "se-resize", "sw-resize", "text", "vertical-text", "w-resize", "wait"});
        Set cursorLiterals1 = Java8Shim.j8().setOf((Object)",", (Object)"auto", (Object)"inherit");
        Set directionLiterals0 = Java8Shim.j8().setOf((Object)"ltr", (Object)"rtl");
        Set displayLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"-moz-inline-box", "-moz-inline-stack", "block", "inline", "inline-block", "inline-table", "list-item", "run-in", "table", "table-caption", "table-cell", "table-column", "table-column-group", "table-footer-group", "table-header-group", "table-row", "table-row-group"});
        Set elevationLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"above", "below", "higher", "level", "lower"});
        Set emptyCellsLiterals0 = Java8Shim.j8().setOf((Object)"hide", (Object)"show");
        Set fontLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"100", "200", "300", "400", "500", "600", "700", "800", "900", "bold", "bolder", "lighter"});
        Set fontLiterals1 = Java8Shim.j8().setOf((Object[])new String[]{"large", "larger", "small", "smaller", "x-large", "x-small", "xx-large", "xx-small", "xxx-large", "medium"});
        Set fontLiterals2 = Java8Shim.j8().setOf((Object[])new String[]{"caption", "icon", "menu", "message-box", "small-caption", "status-bar"});
        Set fontLiterals3 = Java8Shim.j8().setOf((Object[])new String[]{"cursive", "fantasy", "monospace", "sans-serif", "serif"});
        Set fontLiterals4 = Java8Shim.j8().setOf((Object)"italic", (Object)"oblique");
        Set fontLiterals5 = Java8Shim.j8().setOf((Object[])new String[]{",", "/", "inherit", "medium", "normal", "small-caps"});
        Set fontFamilyLiterals0 = Java8Shim.j8().setOf((Object)",", (Object)"inherit");
        Set fontStretchLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"condensed", "expanded", "extra-condensed", "extra-expanded", "narrower", "semi-condensed", "semi-expanded", "ultra-condensed", "ultra-expanded", "wider"});
        Set fontStretchLiterals1 = Java8Shim.j8().setOf((Object)"normal");
        Set fontStyleLiterals0 = Java8Shim.j8().setOf((Object)"inherit", (Object)"normal");
        Set fontVariantLiterals0 = Java8Shim.j8().setOf((Object)"inherit", (Object)"normal", (Object)"small-caps");
        Set listStyleLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"armenian", "cjk-decimal", "decimal", "decimal-leading-zero", "disc", "disclosure-closed", "disclosure-open", "ethiopic-numeric", "georgian", "hebrew", "hiragana", "hiragana-iroha", "japanese-formal", "japanese-informal", "katakana", "katakana-iroha", "korean-hangul-formal", "korean-hanja-formal", "korean-hanja-informal", "lower-alpha", "lower-greek", "lower-latin", "lower-roman", "simp-chinese-formal", "simp-chinese-informal", "square", "trad-chinese-formal", "trad-chinese-informal", "upper-alpha", "upper-latin", "upper-roman"});
        Set listStyleLiterals1 = Java8Shim.j8().setOf((Object)"inside", (Object)"outside");
        Set listStyleLiterals2 = Java8Shim.j8().setOf((Object)"circle", (Object)"inherit", (Object)"none");
        Set maxHeightLiterals0 = Java8Shim.j8().setOf((Object)"auto", (Object)"inherit", (Object)"none");
        Set overflowLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"auto", "hidden", "inherit", "scroll", "visible"});
        Set overflowWrapLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"normal", "break-word", "anywhere", "inherit"});
        Set overflowXLiterals0 = Java8Shim.j8().setOf((Object)"no-content", (Object)"no-display");
        Set overflowXLiterals1 = Java8Shim.j8().setOf((Object[])new String[]{"auto", "hidden", "scroll", "visible"});
        Set pageBreakAfterLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"always", "auto", "avoid", "inherit"});
        Set pageBreakInsideLiterals0 = Java8Shim.j8().setOf((Object)"auto", (Object)"avoid", (Object)"inherit");
        Set pitchLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"high", "low", "x-high", "x-low"});
        Set playDuringLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"auto", "inherit", "mix", "none", "repeat"});
        Set positionLiterals0 = Java8Shim.j8().setOf((Object)"absolute", (Object)"relative", (Object)"static");
        Set speakLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"inherit", "none", "normal", "spell-out"});
        Set speakHeaderLiterals0 = Java8Shim.j8().setOf((Object)"always", (Object)"inherit", (Object)"once");
        Set speakNumeralLiterals0 = Java8Shim.j8().setOf((Object)"continuous", (Object)"digits");
        Set speakPunctuationLiterals0 = Java8Shim.j8().setOf((Object)"code", (Object)"inherit", (Object)"none");
        Set speechRateLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"fast", "faster", "slow", "slower", "x-fast", "x-slow"});
        Set tableLayoutLiterals0 = Java8Shim.j8().setOf((Object)"auto", (Object)"fixed", (Object)"inherit");
        Set textAlignLiterals0 = Java8Shim.j8().setOf((Object)"center", (Object)"inherit", (Object)"justify");
        Set textDecorationLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"blink", "line-through", "overline", "underline"});
        Set textTransformLiterals0 = Java8Shim.j8().setOf((Object)"capitalize", (Object)"lowercase", (Object)"uppercase");
        Set textWrapLiterals0 = Java8Shim.j8().setOf((Object)"suppress", (Object)"unrestricted");
        Set unicodeBidiLiterals0 = Java8Shim.j8().setOf((Object)"bidi-override", (Object)"embed");
        Set verticalAlignLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"baseline", "middle", "sub", "super", "text-bottom", "text-top"});
        Set visibilityLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"collapse", "hidden", "inherit", "visible"});
        Set voiceFamilyLiterals0 = Java8Shim.j8().setOf((Object)"child", (Object)"female", (Object)"male");
        Set volumeLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"loud", "silent", "soft", "x-loud", "x-soft"});
        Set whiteSpaceLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"-moz-pre-wrap", "-o-pre-wrap", "-pre-wrap", "nowrap", "pre", "pre-line", "pre-wrap"});
        Set wordBreakLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"break-all", "break-word", "keep-all", "normal"});
        Set wordWrapLiterals0 = Java8Shim.j8().setOf((Object)"anywhere", (Object)"break-word", (Object)"normal");
        Set rgb$FunLiterals0 = Java8Shim.j8().setOf((Object)",");
        Set linearGradient$FunLiterals0 = Java8Shim.j8().setOf((Object)",", (Object)"to");
        Set radialGradient$FunLiterals0 = Java8Shim.j8().setOf((Object[])new String[]{"at", "closest-corner", "closest-side", "ellipse", "farthest-corner", "farthest-side"});
        Set radialGradient$FunLiterals1 = Java8Shim.j8().setOf((Object)",", (Object)"center", (Object)"circle");
        Set rect$FunLiterals0 = Java8Shim.j8().setOf((Object)",", (Object)"auto");
        Property mozBorderRadius = new Property(5, mozBorderRadiusLiterals0, zeroFns);
        builder.put("-moz-border-radius", mozBorderRadius);
        Property mozBorderRadiusBottomleft = new Property(5, Java8Shim.j8().setOf(), zeroFns);
        builder.put("-moz-border-radius-bottomleft", mozBorderRadiusBottomleft);
        Property mozOpacity = new Property(1, mozOpacityLiterals0, zeroFns);
        builder.put("-moz-opacity", mozOpacity);
        Property mozOutline = new Property(7, CssSchema.union(mozOutlineLiterals0, mozOutlineLiterals1, mozOutlineLiterals2, mozOutlineLiterals3), mozOutlineFunctions);
        builder.put("-moz-outline", mozOutline);
        Property mozOutlineColor = new Property(2, CssSchema.union(mozOutlineColorLiterals0, mozOutlineLiterals0), mozOutlineFunctions);
        builder.put("-moz-outline-color", mozOutlineColor);
        Property mozOutlineStyle = new Property(0, CssSchema.union(mozOutlineLiterals1, mozOutlineStyleLiterals0), zeroFns);
        builder.put("-moz-outline-style", mozOutlineStyle);
        Property mozOutlineWidth = new Property(5, CssSchema.union(mozOutlineLiterals2, mozOutlineWidthLiterals0), zeroFns);
        builder.put("-moz-outline-width", mozOutlineWidth);
        Property oTextOverflow = new Property(0, oTextOverflowLiterals0, zeroFns);
        builder.put("-o-text-overflow", oTextOverflow);
        Property azimuth = new Property(5, CssSchema.union(azimuthLiterals0, azimuthLiterals1, azimuthLiterals2), zeroFns);
        builder.put("azimuth", azimuth);
        Property background = new Property(23, CssSchema.union(azimuthLiterals1, backgroundLiterals0, backgroundLiterals1, backgroundLiterals2, backgroundLiterals3, mozOutlineLiterals0), backgroundFunctions);
        builder.put("background", background);
        builder.put("background-attachment", new Property(0, backgroundAttachmentLiterals0, zeroFns));
        Property backgroundColor = new Property(258, CssSchema.union(backgroundColorLiterals0, mozOutlineLiterals0), mozOutlineFunctions);
        builder.put("background-color", backgroundColor);
        builder.put("background-image", new Property(16, backgroundImageLiterals0, backgroundImageFunctions));
        Property backgroundPosition = new Property(5, CssSchema.union(azimuthLiterals1, backgroundLiterals2, backgroundPositionLiterals0), zeroFns);
        builder.put("background-position", backgroundPosition);
        Property backgroundRepeat = new Property(0, CssSchema.union(backgroundLiterals1, backgroundRepeatLiterals0), zeroFns);
        builder.put("background-repeat", backgroundRepeat);
        Property border = new Property(7, CssSchema.union(borderLiterals0, mozOutlineLiterals0, mozOutlineLiterals1, mozOutlineLiterals2), mozOutlineFunctions);
        builder.put("border", border);
        Property borderBottomColor = new Property(2, CssSchema.union(backgroundColorLiterals0, mozOutlineLiterals0), mozOutlineFunctions);
        builder.put("border-bottom-color", borderBottomColor);
        builder.put("border-collapse", new Property(0, borderCollapseLiterals0, zeroFns));
        Property borderSpacing = new Property(5, mozOpacityLiterals0, zeroFns);
        builder.put("border-spacing", borderSpacing);
        Property bottom = new Property(5, bottomLiterals0, zeroFns);
        builder.put("bottom", bottom);
        Property boxShadow = new Property(7, CssSchema.union(boxShadowLiterals0, mozOutlineLiterals0), mozOutlineFunctions);
        builder.put("box-shadow", boxShadow);
        Property captionSide = new Property(0, CssSchema.union(backgroundLiterals2, mozOpacityLiterals0), zeroFns);
        builder.put("caption-side", captionSide);
        Property clear = new Property(0, CssSchema.union(azimuthLiterals1, clearLiterals0), zeroFns);
        builder.put("clear", clear);
        builder.put("clip", new Property(0, bottomLiterals0, clipFunctions));
        Property color = new Property(258, CssSchema.union(mozOpacityLiterals0, mozOutlineLiterals0), mozOutlineFunctions);
        builder.put("color", color);
        builder.put("content", new Property(8, contentLiterals0, zeroFns));
        Property cue = new Property(16, cueLiterals0, zeroFns);
        builder.put("cue", cue);
        Property cursor = new Property(272, CssSchema.union(cursorLiterals0, cursorLiterals1), zeroFns);
        builder.put("cursor", cursor);
        Property direction = new Property(0, CssSchema.union(directionLiterals0, mozOpacityLiterals0), zeroFns);
        builder.put("direction", direction);
        Property display = new Property(0, CssSchema.union(cueLiterals0, displayLiterals0), zeroFns);
        builder.put("display", display);
        Property elevation = new Property(5, CssSchema.union(elevationLiterals0, mozOpacityLiterals0), zeroFns);
        builder.put("elevation", elevation);
        Property emptyCells = new Property(0, CssSchema.union(emptyCellsLiterals0, mozOpacityLiterals0), zeroFns);
        builder.put("empty-cells", emptyCells);
        Property cssFloat = new Property(0, CssSchema.union(azimuthLiterals1, cueLiterals0), zeroFns);
        builder.put("float", cssFloat);
        Property font = new Property(73, CssSchema.union(fontLiterals0, fontLiterals1, fontLiterals2, fontLiterals3, fontLiterals4, fontLiterals5), zeroFns);
        builder.put("font", font);
        Property fontFamily = new Property(72, CssSchema.union(fontFamilyLiterals0, fontLiterals3), zeroFns);
        builder.put("font-family", fontFamily);
        Property fontSize = new Property(1, CssSchema.union(fontLiterals1, mozOutlineWidthLiterals0), zeroFns);
        builder.put("font-size", fontSize);
        Property fontStretch = new Property(0, CssSchema.union(fontStretchLiterals0, fontStretchLiterals1), zeroFns);
        builder.put("font-stretch", fontStretch);
        Property fontStyle = new Property(0, CssSchema.union(fontLiterals4, fontStyleLiterals0), zeroFns);
        builder.put("font-style", fontStyle);
        builder.put("font-variant", new Property(0, fontVariantLiterals0, zeroFns));
        Property fontWeight = new Property(0, CssSchema.union(fontLiterals0, fontStyleLiterals0), zeroFns);
        builder.put("font-weight", fontWeight);
        Property height = new Property(5, bottomLiterals0, zeroFns);
        builder.put("height", height);
        Property letterSpacing = new Property(5, fontStyleLiterals0, zeroFns);
        builder.put("letter-spacing", letterSpacing);
        builder.put("line-height", new Property(1, fontStyleLiterals0, zeroFns));
        Property listStyle = new Property(16, CssSchema.union(listStyleLiterals0, listStyleLiterals1, listStyleLiterals2), backgroundImageFunctions);
        builder.put("list-style", listStyle);
        builder.put("list-style-image", new Property(16, cueLiterals0, backgroundImageFunctions));
        Property listStylePosition = new Property(0, CssSchema.union(listStyleLiterals1, mozOpacityLiterals0), zeroFns);
        builder.put("list-style-position", listStylePosition);
        Property listStyleType = new Property(0, CssSchema.union(listStyleLiterals0, listStyleLiterals2), zeroFns);
        builder.put("list-style-type", listStyleType);
        Property margin = new Property(1, bottomLiterals0, zeroFns);
        builder.put("margin", margin);
        Property maxHeight = new Property(1, maxHeightLiterals0, zeroFns);
        builder.put("max-height", maxHeight);
        Property opacity = new Property(1, mozOpacityLiterals0, zeroFns);
        builder.put("opacity", opacity);
        builder.put("overflow", new Property(0, overflowLiterals0, zeroFns));
        builder.put("overflow-wrap", new Property(0, overflowWrapLiterals0, zeroFns));
        Property overflowX = new Property(0, CssSchema.union(overflowXLiterals0, overflowXLiterals1), zeroFns);
        builder.put("overflow-x", overflowX);
        Property padding = new Property(1, mozOpacityLiterals0, zeroFns);
        builder.put("padding", padding);
        Property pageBreakAfter = new Property(0, CssSchema.union(azimuthLiterals1, pageBreakAfterLiterals0), zeroFns);
        builder.put("page-break-after", pageBreakAfter);
        builder.put("page-break-inside", new Property(0, pageBreakInsideLiterals0, zeroFns));
        Property pitch = new Property(5, CssSchema.union(mozOutlineWidthLiterals0, pitchLiterals0), zeroFns);
        builder.put("pitch", pitch);
        builder.put("play-during", new Property(16, playDuringLiterals0, zeroFns));
        Property position = new Property(0, CssSchema.union(mozOpacityLiterals0, positionLiterals0), zeroFns);
        builder.put("position", position);
        builder.put("quotes", new Property(8, cueLiterals0, zeroFns));
        builder.put("speak", new Property(0, speakLiterals0, zeroFns));
        builder.put("speak-header", new Property(0, speakHeaderLiterals0, zeroFns));
        Property speakNumeral = new Property(0, CssSchema.union(mozOpacityLiterals0, speakNumeralLiterals0), zeroFns);
        builder.put("speak-numeral", speakNumeral);
        builder.put("speak-punctuation", new Property(0, speakPunctuationLiterals0, zeroFns));
        Property speechRate = new Property(5, CssSchema.union(mozOutlineWidthLiterals0, speechRateLiterals0), zeroFns);
        builder.put("speech-rate", speechRate);
        builder.put("table-layout", new Property(0, tableLayoutLiterals0, zeroFns));
        Property textAlign = new Property(0, CssSchema.union(azimuthLiterals1, textAlignLiterals0), zeroFns);
        builder.put("text-align", textAlign);
        Property textDecoration = new Property(0, CssSchema.union(cueLiterals0, textDecorationLiterals0), zeroFns);
        builder.put("text-decoration", textDecoration);
        Property textTransform = new Property(0, CssSchema.union(cueLiterals0, textTransformLiterals0), zeroFns);
        builder.put("text-transform", textTransform);
        Property textWrap = new Property(0, CssSchema.union(contentLiterals0, textWrapLiterals0), zeroFns);
        builder.put("text-wrap", textWrap);
        Property unicodeBidi = new Property(0, CssSchema.union(fontStyleLiterals0, unicodeBidiLiterals0), zeroFns);
        builder.put("unicode-bidi", unicodeBidi);
        Property verticalAlign = new Property(5, CssSchema.union(backgroundLiterals2, mozOpacityLiterals0, verticalAlignLiterals0), zeroFns);
        builder.put("vertical-align", verticalAlign);
        builder.put("visibility", new Property(0, visibilityLiterals0, zeroFns));
        Property voiceFamily = new Property(8, CssSchema.union(fontFamilyLiterals0, voiceFamilyLiterals0), zeroFns);
        builder.put("voice-family", voiceFamily);
        Property volume = new Property(1, CssSchema.union(mozOutlineWidthLiterals0, volumeLiterals0), zeroFns);
        builder.put("volume", volume);
        Property whiteSpace = new Property(0, CssSchema.union(fontStyleLiterals0, whiteSpaceLiterals0), zeroFns);
        builder.put("white-space", whiteSpace);
        builder.put("word-break", new Property(0, wordBreakLiterals0, zeroFns));
        builder.put("word-wrap", new Property(0, wordWrapLiterals0, zeroFns));
        builder.put("zoom", new Property(1, fontStretchLiterals1, zeroFns));
        Property rgb$Fun = new Property(1, rgb$FunLiterals0, zeroFns);
        builder.put("rgb()", rgb$Fun);
        builder.put("rgba()", rgb$Fun);
        builder.put("hsl()", rgb$Fun);
        builder.put("hsla()", rgb$Fun);
        Property image$Fun = new Property(18, CssSchema.union(mozOutlineLiterals0, rgb$FunLiterals0), mozOutlineFunctions);
        builder.put("image()", image$Fun);
        Property linearGradient$Fun = new Property(7, CssSchema.union(azimuthLiterals1, backgroundLiterals2, linearGradient$FunLiterals0, mozOutlineLiterals0), mozOutlineFunctions);
        builder.put("linear-gradient()", linearGradient$Fun);
        Property radialGradient$Fun = new Property(7, CssSchema.union(azimuthLiterals1, backgroundLiterals2, mozOutlineLiterals0, radialGradient$FunLiterals0, radialGradient$FunLiterals1), mozOutlineFunctions);
        builder.put("radial-gradient()", radialGradient$Fun);
        builder.put("rect()", new Property(5, rect$FunLiterals0, zeroFns));
        builder.put("-moz-border-radius-bottomright", mozBorderRadiusBottomleft);
        builder.put("-moz-border-radius-topleft", mozBorderRadiusBottomleft);
        builder.put("-moz-border-radius-topright", mozBorderRadiusBottomleft);
        builder.put("-moz-box-shadow", boxShadow);
        builder.put("-webkit-border-bottom-left-radius", mozBorderRadiusBottomleft);
        builder.put("-webkit-border-bottom-right-radius", mozBorderRadiusBottomleft);
        builder.put("-webkit-border-radius", mozBorderRadius);
        builder.put("-webkit-border-radius-bottom-left", mozBorderRadiusBottomleft);
        builder.put("-webkit-border-radius-bottom-right", mozBorderRadiusBottomleft);
        builder.put("-webkit-border-radius-top-left", mozBorderRadiusBottomleft);
        builder.put("-webkit-border-radius-top-right", mozBorderRadiusBottomleft);
        builder.put("-webkit-border-top-left-radius", mozBorderRadiusBottomleft);
        builder.put("-webkit-border-top-right-radius", mozBorderRadiusBottomleft);
        builder.put("-webkit-box-shadow", boxShadow);
        builder.put("border-bottom", border);
        builder.put("border-bottom-left-radius", mozBorderRadiusBottomleft);
        builder.put("border-bottom-right-radius", mozBorderRadiusBottomleft);
        builder.put("border-bottom-style", mozOutlineStyle);
        builder.put("border-bottom-width", mozOutlineWidth);
        builder.put("border-color", borderBottomColor);
        builder.put("border-left", border);
        builder.put("border-left-color", borderBottomColor);
        builder.put("border-left-style", mozOutlineStyle);
        builder.put("border-left-width", mozOutlineWidth);
        builder.put("border-radius", mozBorderRadius);
        builder.put("border-right", border);
        builder.put("border-right-color", borderBottomColor);
        builder.put("border-right-style", mozOutlineStyle);
        builder.put("border-right-width", mozOutlineWidth);
        builder.put("border-style", mozOutlineStyle);
        builder.put("border-top", border);
        builder.put("border-top-color", borderBottomColor);
        builder.put("border-top-left-radius", mozBorderRadiusBottomleft);
        builder.put("border-top-right-radius", mozBorderRadiusBottomleft);
        builder.put("border-top-style", mozOutlineStyle);
        builder.put("border-top-width", mozOutlineWidth);
        builder.put("border-width", mozOutlineWidth);
        builder.put("cue-after", cue);
        builder.put("cue-before", cue);
        builder.put("left", height);
        builder.put("margin-bottom", margin);
        builder.put("margin-left", margin);
        builder.put("margin-right", margin);
        builder.put("margin-top", margin);
        builder.put("max-width", maxHeight);
        builder.put("min-height", margin);
        builder.put("min-width", margin);
        builder.put("outline", mozOutline);
        builder.put("outline-color", mozOutlineColor);
        builder.put("outline-style", mozOutlineStyle);
        builder.put("outline-width", mozOutlineWidth);
        builder.put("overflow-y", overflowX);
        builder.put("padding-bottom", padding);
        builder.put("padding-left", padding);
        builder.put("padding-right", padding);
        builder.put("padding-top", padding);
        builder.put("page-break-before", pageBreakAfter);
        builder.put("pause", borderSpacing);
        builder.put("pause-after", borderSpacing);
        builder.put("pause-before", borderSpacing);
        builder.put("pitch-range", borderSpacing);
        builder.put("richness", borderSpacing);
        builder.put("right", height);
        builder.put("stress", borderSpacing);
        builder.put("text-indent", borderSpacing);
        builder.put("text-overflow", oTextOverflow);
        builder.put("text-shadow", boxShadow);
        builder.put("top", height);
        builder.put("width", margin);
        builder.put("word-spacing", letterSpacing);
        builder.put("z-index", bottom);
        builder.put("repeating-linear-gradient()", linearGradient$Fun);
        builder.put("repeating-radial-gradient()", radialGradient$Fun);
        DEFINITIONS = Collections.unmodifiableMap(builder);
        DEFAULT_WHITELIST = Java8Shim.j8().setOf((Object[])new String[]{"-moz-border-radius", "-moz-border-radius-bottomleft", "-moz-border-radius-bottomright", "-moz-border-radius-topleft", "-moz-border-radius-topright", "-moz-box-shadow", "-moz-outline", "-moz-outline-color", "-moz-outline-style", "-moz-outline-width", "-o-text-overflow", "-webkit-border-bottom-left-radius", "-webkit-border-bottom-right-radius", "-webkit-border-radius", "-webkit-border-radius-bottom-left", "-webkit-border-radius-bottom-right", "-webkit-border-radius-top-left", "-webkit-border-radius-top-right", "-webkit-border-top-left-radius", "-webkit-border-top-right-radius", "-webkit-box-shadow", "azimuth", "background", "background-attachment", "background-color", "background-image", "background-position", "background-repeat", "border", "border-bottom", "border-bottom-color", "border-bottom-left-radius", "border-bottom-right-radius", "border-bottom-style", "border-bottom-width", "border-collapse", "border-color", "border-left", "border-left-color", "border-left-style", "border-left-width", "border-radius", "border-right", "border-right-color", "border-right-style", "border-right-width", "border-spacing", "border-style", "border-top", "border-top-color", "border-top-left-radius", "border-top-right-radius", "border-top-style", "border-top-width", "border-width", "box-shadow", "caption-side", "color", "cue", "cue-after", "cue-before", "direction", "elevation", "empty-cells", "font", "font-family", "font-size", "font-stretch", "font-style", "font-variant", "font-weight", "height", "image()", "letter-spacing", "line-height", "linear-gradient()", "list-style", "list-style-image", "list-style-position", "list-style-type", "margin", "margin-bottom", "margin-left", "margin-right", "margin-top", "max-height", "max-width", "min-height", "min-width", "outline", "outline-color", "outline-style", "outline-width", "padding", "padding-bottom", "padding-left", "padding-right", "padding-top", "pause", "pause-after", "pause-before", "pitch", "pitch-range", "quotes", "radial-gradient()", "rect()", "repeating-linear-gradient()", "repeating-radial-gradient()", "rgb()", "rgba()", "hsl()", "hsla()", "richness", "speak", "speak-header", "speak-numeral", "speak-punctuation", "speech-rate", "stress", "table-layout", "text-align", "text-decoration", "text-indent", "text-overflow", "text-shadow", "text-transform", "text-wrap", "unicode-bidi", "vertical-align", "voice-family", "volume", "white-space", "width", "word-spacing", "word-wrap"});
        DEFAULT = CssSchema.withProperties(DEFAULT_WHITELIST);
    }

    public static final class Property {
        final int bits;
        final Set<String> literals;
        final Map<String, String> fnKeys;

        public Property(int bits, Set<String> literals, Map<String, String> fnKeys) {
            this.bits = bits;
            this.literals = Java8Shim.j8().setCopyOf(literals);
            this.fnKeys = Java8Shim.j8().mapCopyOf(fnKeys);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.bits;
            result = 31 * result + (this.fnKeys == null ? 0 : this.fnKeys.hashCode());
            result = 31 * result + (this.literals == null ? 0 : this.literals.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            if (this.bits != other.bits) {
                return false;
            }
            if (this.fnKeys == null ? other.fnKeys != null : !this.fnKeys.equals(other.fnKeys)) {
                return false;
            }
            return !(this.literals == null ? other.literals != null : !this.literals.equals(other.literals));
        }
    }
}

