/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ColorfulFilter
implements BufferedImageOp {
    private static final double LUMINOSITY_RED = 0.21;
    private static final double LUMINOSITY_GREEN = 0.72;
    private static final double LUMINOSITY_BLUE = 0.07;
    private final double colorfulness;

    ColorfulFilter(double colorfulness) {
        this.colorfulness = colorfulness;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (src.getWidth() == 0 || src.getHeight() == 0) {
            return src;
        }
        int type = src.getType();
        switch (type) {
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                int redOffset;
                int greenOffset;
                int blueOffset;
                BufferedImage dest = Optional.ofNullable(dst).orElseGet(() -> this.createCompatibleDestImage(src, null));
                if (type == 13) {
                    try {
                        return this.filterIndexed(src, dest);
                    }
                    catch (IllegalArgumentException ex) {
                        Logging.warn(ex);
                        break;
                    }
                }
                DataBuffer srcBuffer = src.getRaster().getDataBuffer();
                DataBuffer destBuffer = dest.getRaster().getDataBuffer();
                if (!(srcBuffer instanceof DataBufferByte) || !(destBuffer instanceof DataBufferByte)) {
                    Logging.trace("Images do not use DataBufferByte. Filtering RGB values instead.");
                    break;
                }
                if (type != dest.getType()) {
                    Logging.trace("Src / Dest differ in type (" + type + "/" + dest.getType() + "). Filtering RGB values instead.");
                    break;
                }
                int alphaOffset = 0;
                switch (type) {
                    case 5: {
                        blueOffset = 0;
                        greenOffset = 1;
                        redOffset = 2;
                        break;
                    }
                    case 6: 
                    case 7: {
                        blueOffset = 1;
                        greenOffset = 2;
                        redOffset = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        redOffset = 0;
                        greenOffset = 1;
                        blueOffset = 2;
                        alphaOffset = 3;
                        break;
                    }
                    default: {
                        return this.doFilterRGB(src);
                    }
                }
                this.doFilter((DataBufferByte)srcBuffer, (DataBufferByte)destBuffer, redOffset, greenOffset, blueOffset, alphaOffset, src.getAlphaRaster() != null);
                return dest;
            }
        }
        return this.doFilterRGB(src);
    }

    private BufferedImage filterIndexed(BufferedImage src, BufferedImage dest) {
        Objects.requireNonNull(dest, "dst needs to be non null");
        if (src.getType() != 13) {
            throw new IllegalArgumentException("Source must be of type TYPE_BYTE_INDEXED");
        }
        if (dest.getType() != 13) {
            throw new IllegalArgumentException("Destination must be of type TYPE_BYTE_INDEXED");
        }
        if (!(src.getColorModel() instanceof IndexColorModel)) {
            throw new IllegalArgumentException("Expecting an IndexColorModel for a image of type TYPE_BYTE_INDEXED");
        }
        src.copyData(dest.getRaster());
        IndexColorModel model = (IndexColorModel)src.getColorModel();
        int size = model.getMapSize();
        byte[] red = ColorfulFilter.getIndexColorModelData(size, model::getReds);
        byte[] green = ColorfulFilter.getIndexColorModelData(size, model::getGreens);
        byte[] blue = ColorfulFilter.getIndexColorModelData(size, model::getBlues);
        byte[] alphas = ColorfulFilter.getIndexColorModelData(size, model::getAlphas);
        for (int i = 0; i < size; ++i) {
            int r = red[i] & 0xFF;
            int g = green[i] & 0xFF;
            int b = blue[i] & 0xFF;
            double luminosity = (double)r * 0.21 + (double)g * 0.72 + (double)b * 0.07;
            red[i] = this.mix(r, luminosity);
            green[i] = this.mix(g, luminosity);
            blue[i] = this.mix(b, luminosity);
        }
        IndexColorModel dstModel = new IndexColorModel(model.getPixelSize(), model.getMapSize(), red, green, blue, alphas);
        return new BufferedImage(dstModel, dest.getRaster(), dest.isAlphaPremultiplied(), null);
    }

    private static byte[] getIndexColorModelData(int size, Consumer<byte[]> consumer) {
        byte[] data = new byte[size];
        consumer.accept(data);
        return data;
    }

    private void doFilter(DataBufferByte src, DataBufferByte dest, int redOffset, int greenOffset, int blueOffset, int alphaOffset, boolean hasAlpha) {
        byte[] destPixels;
        byte[] srcPixels = src.getData();
        if (srcPixels.length != (destPixels = dest.getData()).length) {
            Logging.trace("Cannot apply color filter: Source/Dest lengths differ.");
            return;
        }
        int entries = hasAlpha ? 4 : 3;
        for (int i = 0; i < srcPixels.length; i += entries) {
            int r = srcPixels[i + redOffset] & 0xFF;
            int g = srcPixels[i + greenOffset] & 0xFF;
            int b = srcPixels[i + blueOffset] & 0xFF;
            double luminosity = (double)r * 0.21 + (double)g * 0.72 + (double)b * 0.07;
            destPixels[i + redOffset] = this.mix(r, luminosity);
            destPixels[i + greenOffset] = this.mix(g, luminosity);
            destPixels[i + blueOffset] = this.mix(b, luminosity);
            if (!hasAlpha) continue;
            destPixels[i + alphaOffset] = srcPixels[i + alphaOffset];
        }
    }

    private BufferedImage doFilterRGB(BufferedImage src) {
        int w = src.getWidth();
        int h = src.getHeight();
        int[] arr = src.getRGB(0, 0, w, h, null, 0, w);
        for (int i = 0; i < arr.length; ++i) {
            int argb = arr[i];
            int a = argb >> 24 & 0xFF;
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            double luminosity = (double)r * 0.21 + (double)g * 0.72 + (double)b * 0.07;
            r = this.mixInt(r, luminosity);
            g = this.mixInt(g, luminosity);
            b = this.mixInt(b, luminosity);
            argb = a;
            argb = (argb << 8) + r;
            argb = (argb << 8) + g;
            arr[i] = argb = (argb << 8) + b;
        }
        BufferedImage dest = new BufferedImage(w, h, 2);
        dest.setRGB(0, 0, w, h, arr, 0, w);
        return dest;
    }

    private int mixInt(int color, double luminosity) {
        int val = (int)(this.colorfulness * (double)color + (1.0 - this.colorfulness) * luminosity);
        return Utils.clamp(val, 0, 255);
    }

    private byte mix(int color, double luminosity) {
        return (byte)this.mixInt(color, luminosity);
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(src.getWidth(), src.getHeight());
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        return new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return (Point2D)srcPt.clone();
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }
}

