/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.itk.simple.SimpleITKJNI;

public class VectorInt8
extends AbstractList<Byte>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorInt8(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorInt8 vectorInt8) {
        return vectorInt8 == null ? 0L : vectorInt8.swigCPtr;
    }

    protected static long swigRelease(VectorInt8 vectorInt8) {
        long l = 0L;
        if (vectorInt8 != null) {
            if (!vectorInt8.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorInt8.swigCPtr;
            vectorInt8.swigCMemOwn = false;
            vectorInt8.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_VectorInt8(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorInt8(byte[] byArray) {
        this();
        this.reserve(byArray.length);
        for (byte by : byArray) {
            this.add(by);
        }
    }

    public VectorInt8(Iterable<Byte> iterable) {
        this();
        for (byte by : iterable) {
            this.add(by);
        }
    }

    @Override
    public Byte get(int n) {
        return this.doGet(n);
    }

    @Override
    public Byte set(int n, Byte by) {
        return this.doSet(n, by);
    }

    @Override
    public boolean add(Byte by) {
        ++this.modCount;
        this.doAdd(by);
        return true;
    }

    @Override
    public void add(int n, Byte by) {
        ++this.modCount;
        this.doAdd(n, by);
    }

    @Override
    public Byte remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public VectorInt8() {
        this(SimpleITKJNI.new_VectorInt8__SWIG_0(), true);
    }

    public VectorInt8(VectorInt8 vectorInt8) {
        this(SimpleITKJNI.new_VectorInt8__SWIG_1(VectorInt8.getCPtr(vectorInt8), vectorInt8), true);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.VectorInt8_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.VectorInt8_clear(this.swigCPtr, this);
    }

    public VectorInt8(int n, byte by) {
        this(SimpleITKJNI.new_VectorInt8__SWIG_2(n, by), true);
    }

    private int doCapacity() {
        return SimpleITKJNI.VectorInt8_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        SimpleITKJNI.VectorInt8_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return SimpleITKJNI.VectorInt8_doSize(this.swigCPtr, this);
    }

    private void doAdd(byte by) {
        SimpleITKJNI.VectorInt8_doAdd__SWIG_0(this.swigCPtr, this, by);
    }

    private void doAdd(int n, byte by) {
        SimpleITKJNI.VectorInt8_doAdd__SWIG_1(this.swigCPtr, this, n, by);
    }

    private byte doRemove(int n) {
        return SimpleITKJNI.VectorInt8_doRemove(this.swigCPtr, this, n);
    }

    private byte doGet(int n) {
        return SimpleITKJNI.VectorInt8_doGet(this.swigCPtr, this, n);
    }

    private byte doSet(int n, byte by) {
        return SimpleITKJNI.VectorInt8_doSet(this.swigCPtr, this, n, by);
    }

    private void doRemoveRange(int n, int n2) {
        SimpleITKJNI.VectorInt8_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

