/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import org.openide.util.Exceptions;

public final class UIUtils {
    public static final float ALTERNATE_ROW_DARKER_FACTOR = 0.96f;
    private static Color unfocusedSelBg;
    private static Color unfocusedSelFg;
    private static Color profilerResultsBackground;

    public static boolean isAquaLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Aqua");
    }

    public static boolean isFlatLafLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("FlatLaf");
    }

    public static boolean isFlatLafLightLookAndFeel() {
        return UIManager.getLookAndFeel().getID().contains("FlatLaf Light");
    }

    public static boolean isFlatLafDarkLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("FlatLaf Dark");
    }

    public static boolean isDarkLookAndFeel() {
        return UIUtils.isFlatLafDarkLookAndFeel();
    }

    public static Color getDarker(Color c) {
        if (c.equals(Color.WHITE)) {
            return new Color(244, 244, 244);
        }
        return UIUtils.getSafeColor((int)((float)c.getRed() * 0.96f), (int)((float)c.getGreen() * 0.96f), (int)((float)c.getBlue() * 0.96f));
    }

    public static Color getForegroundColorForBackground(Color background) {
        return background.getRed() < 100 || background.getGreen() < 100 || background.getRed() < 100 ? Color.white : Color.black;
    }

    public static Color getDarkerLine(Color c, float alternateRowDarkerFactor) {
        return UIUtils.getSafeColor((int)((float)c.getRed() * alternateRowDarkerFactor), (int)((float)c.getGreen() * alternateRowDarkerFactor), (int)((float)c.getBlue() * alternateRowDarkerFactor));
    }

    public static int getDefaultRowHeight() {
        return new JLabel((String)"X").getPreferredSize().height + 2;
    }

    public static boolean isGTKLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("GTK");
    }

    public static boolean isNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Nimbus");
    }

    public static boolean isNimbusGTKTheme() {
        return UIUtils.isGTKLookAndFeel() && "nimbus".equals(Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Net/ThemeName"));
    }

    public static boolean isNimbus() {
        return UIUtils.isNimbusLookAndFeel() || UIUtils.isNimbusGTKTheme();
    }

    public static boolean isMetalLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Metal");
    }

    public static int getNextSubTabIndex(JTabbedPane tabs, int tabIndex) {
        int nextTabIndex = tabIndex;
        for (int i = 0; i < tabs.getComponentCount(); ++i) {
            if (++nextTabIndex == tabs.getComponentCount()) {
                nextTabIndex = 0;
            }
            if (tabs.isEnabledAt(nextTabIndex)) break;
        }
        return nextTabIndex;
    }

    public static Window getParentWindow(Component comp) {
        while (comp != null && !(comp instanceof Window)) {
            comp = comp.getParent();
        }
        return (Window)comp;
    }

    public static int getPreviousSubTabIndex(JTabbedPane tabs, int tabIndex) {
        int previousTabIndex = tabIndex;
        for (int i = 0; i < tabs.getComponentCount(); ++i) {
            if (--previousTabIndex < 0) {
                previousTabIndex = tabs.getComponentCount() - 1;
            }
            if (tabs.isEnabledAt(previousTabIndex)) break;
        }
        return previousTabIndex;
    }

    public static Color getSafeColor(int red, int green, int blue) {
        red = Math.max(red, 0);
        red = Math.min(red, 255);
        green = Math.max(green, 0);
        green = Math.min(green, 255);
        blue = Math.max(blue, 0);
        blue = Math.min(blue, 255);
        return new Color(red, green, blue);
    }

    public static Color getUnfocusedSelectionBackground() {
        if (unfocusedSelBg == null && (unfocusedSelBg = UIManager.getColor("nb.explorer.unfocusedSelBg")) == null) {
            unfocusedSelBg = UIManager.getColor("controlShadow");
            if (unfocusedSelBg == null) {
                unfocusedSelBg = Color.lightGray;
            }
            if (!Color.WHITE.equals(unfocusedSelBg.brighter())) {
                unfocusedSelBg = unfocusedSelBg.brighter();
            }
        }
        return unfocusedSelBg;
    }

    public static Color getUnfocusedSelectionForeground() {
        if (unfocusedSelFg == null && (unfocusedSelFg = UIManager.getColor("nb.explorer.unfocusedSelFg")) == null && (unfocusedSelFg = UIManager.getColor("textText")) == null) {
            unfocusedSelFg = Color.BLACK;
        }
        return unfocusedSelFg;
    }

    private static Color getGTKProfilerResultsBackground() {
        int[] pixels = new int[]{-1};
        JTextArea textArea = new JTextArea();
        textArea.setSize(new Dimension(10, 10));
        textArea.doLayout();
        BufferedImage image = new BufferedImage(textArea.getSize().width, textArea.getSize().height, 1);
        textArea.printAll(((Image)image).getGraphics());
        PixelGrabber pixelGrabber = new PixelGrabber(image, 5, 5, 1, 1, pixels, 0, 1);
        try {
            pixelGrabber.grabPixels();
            if (pixels[0] == -1) {
                return Color.WHITE;
            }
        }
        catch (InterruptedException e) {
            return UIUtils.getNonGTKProfilerResultsBackground();
        }
        return pixels[0] != -1 ? new Color(pixels[0]) : UIUtils.getNonGTKProfilerResultsBackground();
    }

    private static Color getNonGTKProfilerResultsBackground() {
        return UIManager.getColor("Table.background");
    }

    public static Color getProfilerResultsBackground() {
        if (profilerResultsBackground == null && (profilerResultsBackground = UIUtils.isGTKLookAndFeel() || UIUtils.isNimbusLookAndFeel() ? UIUtils.getGTKProfilerResultsBackground() : UIUtils.getNonGTKProfilerResultsBackground()) == null) {
            profilerResultsBackground = Color.WHITE;
        }
        return profilerResultsBackground;
    }

    public static boolean isWindowsClassicLookAndFeel() {
        if (!UIUtils.isWindowsLookAndFeel()) {
            return false;
        }
        return !UIUtils.isWindowsXPLookAndFeel() && !UIUtils.isWindowsVistaLookAndFeel();
    }

    public static boolean isWindowsLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Windows");
    }

    public static boolean isWindowsXPLookAndFeel() {
        if (!UIUtils.isWindowsLookAndFeel()) {
            return false;
        }
        boolean xpThemeActiveOS = Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive"));
        boolean xpThemeDisabled = System.getProperty("swing.noxp") != null;
        boolean vistaOs = System.getProperty("os.version").startsWith("6.0");
        return xpThemeActiveOS && !xpThemeDisabled && !vistaOs;
    }

    public static boolean isWindowsVistaLookAndFeel() {
        if (!UIUtils.isWindowsLookAndFeel()) {
            return false;
        }
        boolean xpThemeActiveOS = Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive"));
        boolean xpThemeDisabled = System.getProperty("swing.noxp") != null;
        boolean vistaOs = System.getProperty("os.version").startsWith("6.0");
        return xpThemeActiveOS && !xpThemeDisabled && vistaOs;
    }

    public static void fixButtonUI(AbstractButton button) {
    }

    private static BufferedImage createTableScreenshot(Component component) {
        Dimension sourceSize;
        JComponent source;
        JTable table;
        if (component instanceof JTable) {
            table = (JTable)component;
            if (table.getTableHeader() == null || !table.getTableHeader().isVisible()) {
                return UIUtils.createGeneralComponentScreenshot(component);
            }
            source = table;
            sourceSize = table.getSize();
        } else if (component instanceof JViewport && ((JViewport)component).getView() instanceof JTable) {
            JViewport viewport = (JViewport)component;
            table = (JTable)viewport.getView();
            if (table.getTableHeader() == null || !table.getTableHeader().isVisible()) {
                return UIUtils.createGeneralComponentScreenshot(component);
            }
            if (table.getSize().height > viewport.getSize().height) {
                source = viewport;
                sourceSize = viewport.getSize();
            } else {
                source = table;
                sourceSize = table.getSize();
            }
        } else {
            throw new IllegalArgumentException("Component can only be JTable or JViewport holding JTable");
        }
        final JTableHeader tableHeader = table.getTableHeader();
        Dimension tableHeaderSize = tableHeader.getSize();
        BufferedImage tableScreenshot = new BufferedImage(sourceSize.width, tableHeaderSize.height + sourceSize.height, 1);
        final Graphics tableScreenshotGraphics = tableScreenshot.getGraphics();
        if (SwingUtilities.isEventDispatchThread()) {
            tableHeader.printAll(tableScreenshotGraphics);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        tableHeader.printAll(tableScreenshotGraphics);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        tableScreenshotGraphics.translate(0, tableHeaderSize.height);
        final JComponent printSrc = source;
        if (SwingUtilities.isEventDispatchThread()) {
            ((Component)printSrc).printAll(tableScreenshotGraphics);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        printSrc.printAll(tableScreenshotGraphics);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tableScreenshot;
    }

    private static BufferedImage createGeneralComponentScreenshot(Component component) {
        Dimension sourceSize;
        Component source;
        if (component instanceof JViewport) {
            JViewport viewport = (JViewport)component;
            Component contents = viewport.getView();
            if (contents.getSize().height > viewport.getSize().height) {
                source = component;
                sourceSize = component.getSize();
            } else {
                source = contents;
                sourceSize = contents.getSize();
            }
        } else {
            source = component;
            sourceSize = component.getSize();
        }
        BufferedImage componentScreenshot = new BufferedImage(sourceSize.width, sourceSize.height, 1);
        Graphics componentScreenshotGraphics = componentScreenshot.getGraphics();
        source.printAll(componentScreenshotGraphics);
        return componentScreenshot;
    }

    public static void runInEventDispatchThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void runInEventDispatchThreadAndWait(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException | InvocationTargetException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public static BufferedImage createComponentScreenshot(final Component component) {
        final BufferedImage[] result = new BufferedImage[1];
        Runnable screenshotPerformer = new Runnable(){

            @Override
            public void run() {
                result[0] = component instanceof JTable || component instanceof JViewport && ((JViewport)component).getView() instanceof JTable ? UIUtils.createTableScreenshot(component) : UIUtils.createGeneralComponentScreenshot(component);
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                screenshotPerformer.run();
            } else {
                SwingUtilities.invokeAndWait(screenshotPerformer);
            }
        }
        catch (Exception e) {
            return null;
        }
        return result[0];
    }

    static Image generateFilteredImage(Image image, ImageFilter filter) {
        FilteredImageSource prod = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    private static Image map(Image image, ImageFilter filter) {
        return UIUtils.generateFilteredImage(image, filter);
    }

    private static abstract class IconImageFilter
    extends RGBImageFilter {
        IconImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public final int filterRGB(int x, int y, int rgb) {
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            int gray = this.getGreyFor((int)((0.3 * (double)red + 0.59 * (double)green + 0.11 * (double)blue) / 3.0));
            return rgb & 0xFF000000 | IconImageFilter.grayTransform(red, gray) << 16 | IconImageFilter.grayTransform(green, gray) << 8 | IconImageFilter.grayTransform(blue, gray) << 0;
        }

        private static int grayTransform(int color, int gray) {
            int result = color - gray;
            if (result < 0) {
                result = 0;
            }
            if (result > 255) {
                result = 255;
            }
            return result;
        }

        abstract int getGreyFor(int var1);
    }
}

