/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.impl;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import java.net.URL;
import java.util.Locale;

public class CSSUtil {
    public static boolean isValidIdentifier(CharSequence s) {
        int idx;
        int len = s.length();
        char c = s.charAt(0);
        if (c != '-') {
            if (!CSSUtil.isNameStartChar(c) && c != '\\') {
                return false;
            }
            idx = 1;
        } else if (len > 1) {
            c = s.charAt(1);
            if (!CSSUtil.isNameStartChar(c) && c != '-' && c != '\\') {
                return false;
            }
            idx = 2;
        } else {
            return false;
        }
        while (idx < len) {
            c = s.charAt(idx);
            if (!CSSUtil.isNameChar(c)) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public static boolean isValidPseudoName(CharSequence s) {
        int idx;
        int len = s.length();
        char c = s.charAt(0);
        if (c != '-') {
            if (!CSSUtil.isNameStartChar(c)) {
                return false;
            }
            idx = 1;
        } else if (len > 1) {
            c = s.charAt(1);
            if (!CSSUtil.isNameStartChar(c)) {
                return false;
            }
            idx = 2;
        } else {
            return false;
        }
        while (idx < len) {
            c = s.charAt(idx);
            if (!CSSUtil.isNameChar(c)) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    private static boolean isNameChar(char cp) {
        return cp >= 'a' && cp <= 'z' || cp >= 'A' && cp <= 'Z' || cp >= '0' && cp <= '9' || cp == '-' || cp == '_' || cp > '\u0080' || cp == '\\';
    }

    private static boolean isNameStartChar(char cp) {
        return cp >= 'a' && cp <= 'z' || cp >= 'A' && cp <= 'Z' || cp == '_' || cp > '\u0080';
    }

    public static boolean isInvalidCSSContentType(URL url, String conType) {
        if (conType == null) {
            String proto = url.getProtocol();
            return "https".equals(proto) || "http".equals(proto);
        }
        int sepidx = conType.indexOf(59);
        if (sepidx != -1) {
            conType = conType.substring(0, sepidx);
        }
        if ("text/css".equals(conType = conType.toLowerCase(Locale.ROOT))) {
            return false;
        }
        String proto = url.getProtocol();
        return !"jar".equals(proto) && !"file".equals(proto) && ("https".equals(proto) || "http".equals(proto) || !"content/unknown".equals(conType) && !"unknown/unknown".equals(conType) && !"application/x-unknown-content-type".equals(conType));
    }

    public static boolean isUnimplementedImageFunction(String lcfName) {
        return lcfName.equals("paint") || lcfName.equals("image") || lcfName.equals("cross-fade");
    }

    public static CSSValueSyntax.Match matchEnv(CSSValueSyntax rootSyntax, CSSValueSyntax syntax, String name, LexicalUnit fallback) {
        CSSValueSyntax.Match match;
        CSSValueSyntax.Category cat = syntax.getCategory();
        if (cat == CSSValueSyntax.Category.universal) {
            return CSSValueSyntax.Match.TRUE;
        }
        if (CSSUtil.isEnvLengthName(name)) {
            if (cat == CSSValueSyntax.Category.length || cat == CSSValueSyntax.Category.lengthPercentage) {
                return CSSValueSyntax.Match.TRUE;
            }
            match = CSSValueSyntax.Match.FALSE;
        } else {
            match = CSSValueSyntax.Match.PENDING;
        }
        return fallback == null ? match : fallback.matches(rootSyntax);
    }

    public static boolean isEnvLengthName(String name) {
        return name.contains("width") || name.contains("height") || name.contains("-x") || name.contains("-y") || name.contains("top") || name.contains("right") || name.contains("bottom") || name.contains("left");
    }
}

