/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.dameng.model;

import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DamengSequence
extends GenericSequence
implements DBPSaveableObject,
DBPScriptObject,
DBPRefreshableObject {
    private long cacheSize;
    private boolean isCycle;
    private boolean isOrder;
    private String sql;

    public DamengSequence(@NotNull GenericStructContainer container, @NotNull String name, @Nullable String description, long lastValue, long minValue, long maxValue, long incrementBy, @NotNull JDBCResultSet dbResult) {
        super(container, name, description, (Number)lastValue, (Number)minValue, (Number)maxValue, (Number)incrementBy);
        this.cacheSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CACHE_SIZE");
        this.isCycle = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"IS_CYCLE");
        this.isOrder = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"IS_ORDER");
    }

    public DamengSequence(@NotNull GenericStructContainer container, @NotNull String name) {
        super(container, name);
    }

    @Property(viewable=true, order=3, editable=true)
    public Long getMinValue() {
        return super.getMinValue().longValue();
    }

    @Property(viewable=true, order=4, editable=true, updatable=true)
    public Long getMaxValue() {
        return super.getMaxValue().longValue();
    }

    @Property(viewable=true, order=5, editable=true, updatable=true)
    public Long getIncrementBy() {
        return super.getIncrementBy().longValue();
    }

    @Property(viewable=true, order=6)
    public long getCacheSize() {
        return this.cacheSize;
    }

    @Property(viewable=true, order=7)
    public boolean isCycle() {
        return this.isCycle;
    }

    @Property(viewable=true, order=8)
    public boolean isOrder() {
        return this.isOrder;
    }

    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) {
        if (CommonUtils.isEmpty((String)this.sql)) {
            this.sql = this.buildStatement(false);
        }
        return this.sql;
    }

    public String buildStatement(boolean forUpdate) {
        StringBuilder sb = new StringBuilder();
        if (forUpdate) {
            sb.append("ALTER");
        } else {
            sb.append("CREATE");
        }
        sb.append(" SEQUENCE ");
        sb.append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ");
        if (this.getIncrementBy() != null) {
            sb.append("INCREMENT BY ").append(this.getIncrementBy()).append(" ");
        }
        if (!this.isPersisted() && this.getMinValue() != null) {
            sb.append("START WITH ").append(this.getMinValue()).append(" ");
        }
        if (this.getMaxValue() != null) {
            sb.append("MAXVALUE ").append(this.getMaxValue()).append(" ");
        }
        if (this.getMinValue() != null) {
            sb.append("MINVALUE ").append(this.getMinValue()).append(" ");
        }
        return sb.toString();
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.sql = null;
        return this;
    }
}

