"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDocUri = exports.getLine = void 0;
const vscode_uri_1 = require("vscode-uri");
const range_1 = require("./range");
function getLine(doc, line) {
    return doc.getText((0, range_1.makeRange)(line, 0, line, Number.MAX_VALUE)).replace(/\r?\n$/, '');
}
exports.getLine = getLine;
function getDocUri(doc) {
    return doc.$uri ?? vscode_uri_1.URI.parse(doc.uri);
}
exports.getDocUri = getDocUri;
//# sourceMappingURL=textDocument.js.map