/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.pluginimporter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PluginImporter {
    private final Collection<UpdateUnit> plugins;
    private boolean inspected = false;
    private Collection<UpdateElement> installed = null;
    private Collection<UpdateElement> toInstall = null;
    private Collection<UpdateElement> toImport = null;
    private Collection<UpdateElement> broken = null;
    private static final String TRACKING_FILE_NAME = "update_tracking";
    private static final String ELEMENT_MODULE = "module";
    private static final String ELEMENT_VERSION = "module_version";
    private static final String ATTR_LAST = "last";
    private static final String ATTR_FILE_NAME = "name";
    private static final String MODULES = "Modules";
    private static final String LAST_MODIFIED = ".lastModified";
    private static final Logger LOG = Logger.getLogger(PluginImporter.class.getName());

    public PluginImporter(Collection<UpdateUnit> foundPlugins) {
        this.plugins = foundPlugins;
    }

    public void reinspect() {
        this.inspected = false;
        this.inspect();
    }

    private void inspect() {
        if (this.inspected) {
            return;
        }
        long start = System.currentTimeMillis();
        this.installed = new HashSet<UpdateElement>();
        this.toImport = new HashSet<UpdateElement>();
        this.toInstall = new HashSet<UpdateElement>();
        this.broken = new HashSet<UpdateElement>();
        HashSet<UpdateElement> candidate2import = new HashSet<UpdateElement>();
        List updateUnits = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        HashMap<String, UpdateUnit> cnb2uu = new HashMap<String, UpdateUnit>(updateUnits.size());
        for (UpdateUnit u : updateUnits) {
            cnb2uu.put(u.getCodeName(), u);
        }
        for (UpdateUnit unit : this.plugins) {
            SpecificationVersion spec;
            UpdateElement el;
            UpdateUnit remoteUnit = (UpdateUnit)cnb2uu.get(unit.getCodeName());
            UpdateElement remoteElement = null;
            SpecificationVersion remoteSpec = null;
            if (remoteUnit != null && !remoteUnit.getAvailableUpdates().isEmpty()) {
                remoteElement = (UpdateElement)remoteUnit.getAvailableUpdates().get(0);
                SpecificationVersion specificationVersion = remoteSpec = remoteElement.getSpecificationVersion() == null ? null : new SpecificationVersion(remoteElement.getSpecificationVersion());
            }
            if (unit.getInstalled() != null) {
                if (!unit.getAvailableUpdates().isEmpty()) {
                    el = (UpdateElement)unit.getAvailableUpdates().get(0);
                    if (remoteElement != null) {
                        SpecificationVersion specificationVersion = spec = el.getSpecificationVersion() == null ? null : new SpecificationVersion(el.getSpecificationVersion());
                        if (spec != null && spec.compareTo((Object)remoteSpec) > 0) {
                            candidate2import.add(el);
                        }
                    } else {
                        candidate2import.add(el);
                    }
                }
                this.installed.add(unit.getInstalled());
                continue;
            }
            if (unit.isPending()) {
                LOG.log(Level.INFO, "Plugin " + unit.getCodeName() + " is not installed but is in pending state - i.e. will be installed upon restart, skipping");
                continue;
            }
            assert (!unit.getAvailableUpdates().isEmpty()) : "If " + unit + " isn't installed thus has available updates.";
            el = (UpdateElement)unit.getAvailableUpdates().get(0);
            if (remoteElement != null) {
                SpecificationVersion specificationVersion = spec = el.getSpecificationVersion() == null ? null : new SpecificationVersion(el.getSpecificationVersion());
                if (spec != null && spec.compareTo((Object)remoteSpec) > 0) {
                    candidate2import.add(el);
                    continue;
                }
                this.toInstall.add(remoteElement);
                continue;
            }
            candidate2import.add(el);
        }
        for (UpdateElement el : candidate2import) {
            OperationContainer oc = el.getUpdateUnit().getInstalled() == null ? OperationContainer.createForInstall() : OperationContainer.createForUpdate();
            try {
                OperationContainer.OperationInfo info = oc.add(el);
                oc.add(candidate2import);
                if (PluginImporter.isBlacklisted(el)) {
                    LOG.info("Plugin " + el + " is on blacklist thus will not be imported.");
                    continue;
                }
                if (info.getBrokenDependencies().isEmpty()) {
                    this.toImport.add(el);
                    continue;
                }
                LOG.log(Level.INFO, "Plugin " + el + " cannot be install because not all dependencies can be match: " + info.getBrokenDependencies());
                this.broken.add(el);
            }
            catch (IllegalArgumentException iae) {
                LOG.log(Level.INFO, iae.getLocalizedMessage(), iae);
                this.broken.add(el);
            }
        }
        long end = System.currentTimeMillis();
        LOG.log(Level.INFO, "Inspecting plugins took " + (end - start) + " ms");
        this.inspected = true;
    }

    public Collection<UpdateElement> getPluginsToImport() {
        this.inspect();
        return this.toImport;
    }

    public Collection<UpdateElement> getInstalledPlugins() {
        this.inspect();
        return this.installed;
    }

    public Collection<UpdateElement> getPluginsAvailableToInstall() {
        this.inspect();
        return this.toInstall;
    }

    public Collection<UpdateElement> getBrokenPlugins() {
        this.inspect();
        return this.broken;
    }

    public void importPlugins(Collection<UpdateElement> plugins, File src, File dest, ProgressHandle handle) throws IOException {
        if (handle != null) {
            handle.setInitialDelay(0);
            handle.start(plugins.size());
        }
        ArrayList<String> configs = new ArrayList<String>(plugins.size());
        int completed = 0;
        for (UpdateElement el : plugins) {
            String cnb;
            Collection<String> toCopy;
            if (handle != null) {
                String name = el.getDisplayName();
                if (name == null) {
                    name = el.getCodeName();
                }
                String detail = NbBundle.getMessage(PluginImporter.class, (String)"PluginImporter.Importing.Plugin", (Object)name);
                handle.progress(detail, completed++);
            }
            if ((toCopy = PluginImporter.getPluginFiles(src, cnb = el.getCodeName(), PluginImporter.locateUpdateTracking(cnb, src))).isEmpty()) continue;
            for (String path : toCopy) {
                PluginImporter.copy(path, src, dest);
            }
            String path = "config/Modules/" + cnb.replace('.', '-') + ".xml";
            configs.add(path);
        }
        for (String path : configs) {
            PluginImporter.copy(path, src, dest);
        }
        if (this.getPluginsToImport().isEmpty()) {
            PluginImporter.refreshModuleList();
        } else {
            String restartMsg = NbBundle.getMessage(PluginImporter.class, (String)"PluginImporter.Importing.RestartNeeded");
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)restartMsg, 0);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (result.equals(NotifyDescriptor.OK_OPTION)) {
                LifecycleManager.getDefault().markForRestart();
                LifecycleManager.getDefault().exit();
            }
        }
        if (handle != null) {
            handle.finish();
        }
    }

    private static void copy(String path, File sourceFolder, File destFolder) throws IOException {
        LOG.finest("Copy " + path + " from " + sourceFolder + " to " + destFolder);
        File src = new File(sourceFolder, path);
        assert (src.exists()) : src + " exists.";
        src = FileUtil.normalizeFile((File)src);
        FileObject srcFO = FileUtil.toFileObject((File)src);
        File destFO = new File(destFolder, path);
        destFO.getParentFile().mkdirs();
        File dest = destFO.getParentFile();
        dest = FileUtil.normalizeFile((File)dest);
        FileObject destFolderFO = FileUtil.toFileObject((File)dest);
        File destFile = new File(dest, srcFO.getNameExt());
        if (destFile.exists() && !destFile.delete()) {
            return;
        }
        FileObject res = FileUtil.copyFile((FileObject)srcFO, (FileObject)destFolderFO, (String)srcFO.getName());
        LOG.finest(srcFO + " was copied to " + destFolderFO + ". Result is: " + res);
    }

    private static Collection<String> getPluginFiles(File cluster, String cnb, File updateTracking) {
        HashSet<String> res = new HashSet<String>();
        LOG.log(Level.FINE, "Read update_tracking " + updateTracking + " file.");
        Node updateTrackingConf = PluginImporter.getUpdateTrackingConf(updateTracking);
        if (updateTrackingConf == null) {
            return Collections.emptySet();
        }
        Set<String> moduleFiles = PluginImporter.readModuleFiles(updateTrackingConf);
        String configFile = "config/Modules/" + cnb.replace('.', '-') + ".xml";
        moduleFiles.remove(configFile);
        for (String fileName : moduleFiles) {
            File file = new File(cluster, fileName);
            if (!file.exists()) {
                LOG.log(Level.WARNING, "File " + file + " doesn't exist for module " + cnb);
                continue;
            }
            if (file.equals(updateTracking)) continue;
            res.add(fileName);
        }
        res.add("update_tracking/" + cnb.replace('.', '-') + ".xml");
        LOG.log(Level.FINEST, cnb + " has files: " + res);
        return res;
    }

    private static File locateUpdateTracking(String cnb, File cluster) {
        String fileNameToFind = "update_tracking/" + cnb.replace('.', '-') + ".xml";
        File ut = new File(cluster, fileNameToFind);
        if (ut.exists()) {
            return ut;
        }
        throw new IllegalArgumentException(ut + " doesn't exist.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node getUpdateTrackingConf(File moduleUpdateTracking) {
        Document document = null;
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(moduleUpdateTracking));
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse((InputSource)xmlInputSource, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
            ((InputStream)is).close();
        }
        catch (SAXException saxe) {
            LOG.log(Level.WARNING, "SAXException when reading " + moduleUpdateTracking + ", cause: " + saxe);
            FileReader reader = null;
            try {
                reader = new FileReader(moduleUpdateTracking);
                char[] text = new char[1024];
                String fileContent = "";
                while (reader.read(text) > 0) {
                    fileContent = fileContent + String.copyValueOf(text);
                }
                LOG.log(Level.WARNING, "SAXException in file:\n------FILE START------\n " + fileContent + "\n------FILE END-----\n");
            }
            catch (Exception exception) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, null, ioe);
        }
        assert (document.getDocumentElement() != null) : "File " + moduleUpdateTracking + " must contain <module> element.";
        return PluginImporter.getModuleElement(document.getDocumentElement());
    }

    private static Node getModuleElement(Element element) {
        Node lastElement = null;
        assert (ELEMENT_MODULE.equals(element.getTagName())) : "The root element is: module but was: " + element.getTagName();
        NodeList listModuleVersions = element.getElementsByTagName(ELEMENT_VERSION);
        for (int i = 0; i < listModuleVersions.getLength() && (lastElement = PluginImporter.getModuleLastVersion(listModuleVersions.item(i))) == null; ++i) {
        }
        return lastElement;
    }

    private static Node getModuleLastVersion(Node version) {
        Node attrLast = version.getAttributes().getNamedItem(ATTR_LAST);
        assert (attrLast != null) : "ELEMENT_VERSION must contain ATTR_LAST attribute.";
        if (Boolean.parseBoolean(attrLast.getNodeValue())) {
            return version;
        }
        return null;
    }

    private static Set<String> readModuleFiles(Node version) {
        HashSet<String> files = new HashSet<String>();
        NodeList fileNodes = version.getChildNodes();
        for (int i = 0; i < fileNodes.getLength(); ++i) {
            if (!fileNodes.item(i).hasAttributes()) continue;
            NamedNodeMap map = fileNodes.item(i).getAttributes();
            files.add(map.getNamedItem(ATTR_FILE_NAME).getNodeValue());
            LOG.log(Level.FINE, "File for import: " + map.getNamedItem(ATTR_FILE_NAME).getNodeValue());
        }
        return files;
    }

    private static void refreshModuleList() {
        final FileObject modulesRoot = FileUtil.getConfigFile((String)MODULES);
        LOG.log(Level.FINE, "It's a hack: Call refresh on " + modulesRoot + " file object.");
        if (modulesRoot != null) {
            try {
                FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        modulesRoot.getParent().refresh();
                        modulesRoot.refresh();
                    }
                });
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static void touchLastModified(File cluster) {
        try {
            File stamp = new File(cluster, LAST_MODIFIED);
            if (!stamp.createNewFile()) {
                stamp.setLastModified(System.currentTimeMillis());
                if (!stamp.setLastModified(System.currentTimeMillis())) {
                    stamp.delete();
                    stamp = new File(cluster, LAST_MODIFIED);
                    stamp.setLastModified(System.currentTimeMillis());
                }
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, ex.getMessage(), ex);
        }
    }

    private static boolean isBlacklisted(UpdateElement el) {
        String blacklist = System.getProperty("plugin.import.blacklist", "");
        if (!blacklist.isEmpty()) {
            blacklist = blacklist + ',';
        }
        blacklist = blacklist + NbBundle.getMessage(PluginImporter.class, (String)"plugin.import.blacklist");
        LOG.fine("Blacklist: " + blacklist);
        StringTokenizer tokens = new StringTokenizer(blacklist, ",");
        while (tokens.hasMoreTokens()) {
            if (!el.getCodeName().equals(tokens.nextToken())) continue;
            return true;
        }
        return false;
    }
}

