/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.ParameterToken;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class Param
extends AbstractTeXObject
implements ParameterToken {
    private int digit;

    public Param(int n) {
        this.setDigit(n);
    }

    @Override
    public Object clone() {
        return new Param(this.digit);
    }

    public int getDigit() {
        return this.digit;
    }

    public void setDigit(int n) {
        this.digit = n;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.digit <= 0) {
            TeXObject teXObject = teXObjectList.peek();
            throw new TeXSyntaxException(teXParser, "tex.error.bad_param", teXObject == null ? "" : teXObject.toString(teXParser));
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        if (this.digit <= 0) {
            TeXObject teXObject = teXParser.peekStack();
            throw new TeXSyntaxException(teXParser, "tex.error.bad_param", teXObject == null ? "" : teXObject.toString(teXParser));
        }
    }

    @Override
    public String toString(TeXParser teXParser) {
        String string = new String(Character.toChars(teXParser.getParamChar()));
        return this.digit <= 0 ? String.format("%s", string) : String.format("%s%d", string, this.digit);
    }

    @Override
    public String format() {
        return this.digit <= 0 ? "#" : "#" + this.digit;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.digit <= 0 ? "#" : "#" + this.digit);
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(teXParser.getParamChar()));
        if (this.digit != -1) {
            teXObjectList.add(teXParser.getListener().getOther(48 + this.digit));
        }
        return teXObjectList;
    }

    @Override
    public ParameterToken next() {
        return null;
    }

    @Override
    public Param tail() {
        return this;
    }
}

