/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.Table;

public class SbixTable
implements Table {
    private static final boolean DEBUG = false;
    private final int _version;
    private final int _flags;
    private final int _numStrikes;
    private final int[] _strikeOffset;
    private final Strike[] _strikes;

    private SbixTable(DataInput dataInput, int n, MaxpTable maxpTable) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        DataInputStream dataInputStream = new DataInputStream(this.getByteArrayInputStreamForOffset(byArray, 0));
        this._version = dataInputStream.readUnsignedShort();
        this._flags = dataInputStream.readUnsignedShort();
        this._numStrikes = dataInputStream.readInt();
        this._strikeOffset = new int[this._numStrikes];
        for (n2 = 0; n2 < this._numStrikes; ++n2) {
            this._strikeOffset[n2] = dataInputStream.readInt();
        }
        this._strikes = new Strike[this._numStrikes];
        for (n2 = 0; n2 < this._numStrikes; ++n2) {
            ByteArrayInputStream byteArrayInputStream = this.getByteArrayInputStreamForOffset(byArray, this._strikeOffset[n2]);
            this._strikes[n2] = new Strike(byteArrayInputStream, maxpTable.getNumGlyphs());
        }
    }

    private ByteArrayInputStream getByteArrayInputStreamForOffset(byte[] byArray, int n) {
        return new ByteArrayInputStream(byArray, n, byArray.length - n);
    }

    public Strike[] getStrikes() {
        return this._strikes;
    }

    public static class Strike {
        private final int _ppem;
        private final int _resolution;
        private final long[] _glyphDataOffset;
        private final GlyphDataRecord[] _glyphDataRecord;

        Strike(ByteArrayInputStream byteArrayInputStream, int n) throws IOException {
            int n2;
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this._ppem = dataInputStream.readUnsignedShort();
            this._resolution = dataInputStream.readUnsignedShort();
            this._glyphDataOffset = new long[n + 1];
            for (n2 = 0; n2 < n + 1; ++n2) {
                this._glyphDataOffset[n2] = dataInputStream.readInt();
            }
            this._glyphDataRecord = new GlyphDataRecord[n];
            for (n2 = 0; n2 < n; ++n2) {
                int n3 = (int)(this._glyphDataOffset[n2 + 1] - this._glyphDataOffset[n2]);
                if (n3 == 0) continue;
                byteArrayInputStream.reset();
                byteArrayInputStream.skip(this._glyphDataOffset[n2]);
                this._glyphDataRecord[n2] = new GlyphDataRecord(new DataInputStream(byteArrayInputStream), n3);
            }
        }

        public GlyphDataRecord[] getGlyphDataRecords() {
            return this._glyphDataRecord;
        }

        public String toString() {
            return String.format("ppem: %d, resolution: %d", this._ppem, this._resolution);
        }
    }

    public static class GlyphDataRecord {
        private final short _originOffsetX;
        private final short _originOffsetY;
        private final int _graphicType;
        private final byte[] _data;
        private static final int PNG = 1886283552;

        GlyphDataRecord(DataInput dataInput, int n) throws IOException {
            this._originOffsetX = dataInput.readShort();
            this._originOffsetY = dataInput.readShort();
            this._graphicType = dataInput.readInt();
            if (this._graphicType != 1886283552) {
                System.err.printf("SbixTable: Invalid graphicType: %d%n", this._graphicType);
                this._data = null;
                return;
            }
            this._data = new byte[n];
            try {
                dataInput.readFully(this._data);
            }
            catch (IOException iOException) {
                System.err.println("SbixTable: Reading too much data: " + iOException.getMessage());
            }
        }

        public int getGraphicType() {
            return this._graphicType;
        }

        public byte[] getData() {
            return this._data;
        }
    }
}

