/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.optimizer;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import org.opensearch.sql.planner.logical.LogicalPaginate;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.optimizer.Rule;
import org.opensearch.sql.storage.read.TableScanBuilder;

public class PushDownPageSize
implements Rule<LogicalPaginate> {
    @Override
    public Pattern<LogicalPaginate> pattern() {
        return Pattern.typeOf(LogicalPaginate.class).matching(lp -> this.findTableScanBuilder((LogicalPaginate)lp).isPresent());
    }

    @Override
    public LogicalPlan apply(LogicalPaginate plan, Captures captures) {
        TableScanBuilder builder = this.findTableScanBuilder(plan).orElseThrow();
        if (!builder.pushDownPageSize(plan)) {
            throw new IllegalStateException("Failed to push down LogicalPaginate");
        }
        return plan.getChild().get(0);
    }

    private Optional<TableScanBuilder> findTableScanBuilder(LogicalPaginate logicalPaginate) {
        ArrayDeque<LogicalPlan> plans = new ArrayDeque<LogicalPlan>();
        plans.add(logicalPaginate);
        do {
            LogicalPlan plan = (LogicalPlan)plans.removeFirst();
            List<LogicalPlan> children = plan.getChild();
            if (children.stream().anyMatch(TableScanBuilder.class::isInstance)) {
                if (children.size() > 1) {
                    throw new UnsupportedOperationException("Unsupported plan: relation operator cannot have siblings");
                }
                return Optional.of((TableScanBuilder)children.get(0));
            }
            plans.addAll(children);
        } while (!plans.isEmpty());
        return Optional.empty();
    }
}

