/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.executor.execution;

import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;
import org.opensearch.sql.ast.tree.Paginate;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.QueryId;
import org.opensearch.sql.executor.QueryService;
import org.opensearch.sql.executor.execution.AbstractPlan;

public class QueryPlan
extends AbstractPlan {
    protected final UnresolvedPlan plan;
    protected final QueryService queryService;
    protected final ResponseListener<ExecutionEngine.QueryResponse> listener;
    protected final Optional<Integer> pageSize;

    public QueryPlan(QueryId queryId, UnresolvedPlan plan, QueryService queryService, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        super(queryId);
        this.plan = plan;
        this.queryService = queryService;
        this.listener = listener;
        this.pageSize = Optional.empty();
    }

    public QueryPlan(QueryId queryId, UnresolvedPlan plan, int pageSize, QueryService queryService, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        super(queryId);
        this.plan = plan;
        this.queryService = queryService;
        this.listener = listener;
        this.pageSize = Optional.of(pageSize);
    }

    @Override
    public void execute() {
        if (this.pageSize.isPresent()) {
            this.queryService.execute(new Paginate(this.pageSize.get(), this.plan), this.listener);
        } else {
            this.queryService.execute(this.plan, this.listener);
        }
    }

    @Override
    public void explain(ResponseListener<ExecutionEngine.ExplainResponse> listener) {
        if (this.pageSize.isPresent()) {
            listener.onFailure((Exception)new NotImplementedException("`explain` feature for paginated requests is not implemented yet."));
        } else {
            this.queryService.explain(this.plan, listener);
        }
    }
}

