/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.request.system;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.DataSourceSchemaName;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.exceptions.PrometheusClientException;
import org.opensearch.sql.prometheus.request.system.PrometheusSystemRequest;
import org.opensearch.sql.prometheus.storage.PrometheusMetricDefaultSchema;

public class PrometheusDescribeMetricRequest
implements PrometheusSystemRequest {
    private final PrometheusClient prometheusClient;
    private final String metricName;
    private final DataSourceSchemaName dataSourceSchemaName;
    private static final Logger LOG = LogManager.getLogger();

    public PrometheusDescribeMetricRequest(PrometheusClient prometheusClient, DataSourceSchemaName dataSourceSchemaName, @NonNull String metricName) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        this.prometheusClient = prometheusClient;
        this.metricName = metricName;
        this.dataSourceSchemaName = dataSourceSchemaName;
    }

    public Map<String, ExprType> getFieldTypes() {
        HashMap<String, ExprType> fieldTypes = new HashMap<String, ExprType>();
        AccessController.doPrivileged(() -> {
            try {
                this.prometheusClient.getLabels(this.metricName).forEach(label -> fieldTypes.put((String)label, (ExprType)ExprCoreType.STRING));
            }
            catch (IOException e) {
                LOG.error("Error while fetching labels for {} from prometheus: {}", (Object)this.metricName, (Object)e.getMessage());
                throw new PrometheusClientException(String.format("Error while fetching labels for %s from prometheus: %s", this.metricName, e.getMessage()));
            }
            return null;
        });
        fieldTypes.putAll(PrometheusMetricDefaultSchema.DEFAULT_MAPPING.getMapping());
        return fieldTypes;
    }

    @Override
    public List<ExprValue> search() {
        ArrayList<ExprValue> results = new ArrayList<ExprValue>();
        for (Map.Entry<String, ExprType> entry : this.getFieldTypes().entrySet()) {
            results.add((ExprValue)this.row(entry.getKey(), entry.getValue().legacyTypeName().toLowerCase(), this.dataSourceSchemaName));
        }
        return results;
    }

    private ExprTupleValue row(String fieldName, String fieldType, DataSourceSchemaName dataSourceSchemaName) {
        LinkedHashMap<String, ExprValue> valueMap = new LinkedHashMap<String, ExprValue>();
        valueMap.put("TABLE_CATALOG", ExprValueUtils.stringValue((String)dataSourceSchemaName.getDataSourceName()));
        valueMap.put("TABLE_SCHEMA", ExprValueUtils.stringValue((String)dataSourceSchemaName.getSchemaName()));
        valueMap.put("TABLE_NAME", ExprValueUtils.stringValue((String)this.metricName));
        valueMap.put("COLUMN_NAME", ExprValueUtils.stringValue((String)fieldName));
        valueMap.put("DATA_TYPE", ExprValueUtils.stringValue((String)fieldType));
        return new ExprTupleValue(valueMap);
    }

    @Generated
    public String toString() {
        return "PrometheusDescribeMetricRequest(metricName=" + this.metricName + ")";
    }
}

