/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.flint;

import java.util.Locale;
import java.util.Map;
import lombok.Generated;

public class FlintIndexMetadata {
    public static final String PROPERTIES_KEY = "properties";
    public static final String ENV_KEY = "env";
    public static final String OPTIONS_KEY = "options";
    public static final String SERVERLESS_EMR_JOB_ID = "SERVERLESS_EMR_JOB_ID";
    public static final String AUTO_REFRESH = "auto_refresh";
    public static final String AUTO_REFRESH_DEFAULT = "false";
    private final String jobId;
    private final boolean autoRefresh;

    public static FlintIndexMetadata fromMetatdata(Map<String, Object> metaMap) {
        Map propertiesMap = (Map)metaMap.get(PROPERTIES_KEY);
        Map envMap = (Map)propertiesMap.get(ENV_KEY);
        Map options = (Map)metaMap.get(OPTIONS_KEY);
        String jobId = (String)envMap.get(SERVERLESS_EMR_JOB_ID);
        boolean autoRefresh = !options.getOrDefault(AUTO_REFRESH, AUTO_REFRESH_DEFAULT).toLowerCase(Locale.ROOT).equalsIgnoreCase(AUTO_REFRESH_DEFAULT);
        return new FlintIndexMetadata(jobId, autoRefresh);
    }

    @Generated
    public FlintIndexMetadata(String jobId, boolean autoRefresh) {
        this.jobId = jobId;
        this.autoRefresh = autoRefresh;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlintIndexMetadata)) {
            return false;
        }
        FlintIndexMetadata other = (FlintIndexMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoRefresh() != other.isAutoRefresh()) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        return !(this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlintIndexMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoRefresh() ? 79 : 97);
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FlintIndexMetadata(jobId=" + this.getJobId() + ", autoRefresh=" + this.isAutoRefresh() + ")";
    }
}

