/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.cryptacular.bean.HashBean;
import org.passay.AbstractDictionaryRule;
import org.passay.dictionary.Dictionary;

public class DigestDictionaryRule
extends AbstractDictionaryRule {
    public static final String ERROR_CODE = "ILLEGAL_DIGEST_WORD";
    public static final String ERROR_CODE_REVERSED = "ILLEGAL_DIGEST_WORD_REVERSED";
    private final HashBean<String> hashBean;
    private Charset charset = StandardCharsets.UTF_8;

    public DigestDictionaryRule(HashBean<String> bean, Dictionary dict) {
        this(bean);
        this.setDictionary(dict);
    }

    public DigestDictionaryRule(HashBean<String> bean) {
        this.hashBean = bean;
    }

    public void setCharset(Charset set) {
        if (set == null) {
            throw new NullPointerException("Character set cannot be null");
        }
        this.charset = set;
    }

    @Override
    protected String doWordSearch(String text) {
        return this.getDictionary().search((String)this.hashBean.hash(new Object[]{text.getBytes(this.charset)})) ? text : null;
    }

    @Override
    protected String getErrorCode(boolean backwards) {
        return backwards ? ERROR_CODE_REVERSED : ERROR_CODE;
    }
}

