/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.implementation.models.BlobPropertiesInternal;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.ArchiveStatus;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.azure.storage.blob.models.ObjectReplicationPolicy;
import com.azure.storage.blob.models.RehydratePriority;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class BlobPropertiesInternalConstructorProperties
implements BlobPropertiesInternal {
    private final OffsetDateTime creationTime;
    private final OffsetDateTime lastModified;
    private final String eTag;
    private final long blobSize;
    private final String contentType;
    private final byte[] contentMd5;
    private final String contentEncoding;
    private final String contentDisposition;
    private final String contentLanguage;
    private final String cacheControl;
    private final Long blobSequenceNumber;
    private final BlobType blobType;
    private final LeaseStatusType leaseStatus;
    private final LeaseStateType leaseState;
    private final LeaseDurationType leaseDuration;
    private final String copyId;
    private final CopyStatusType copyStatus;
    private final String copySource;
    private final String copyProgress;
    private final OffsetDateTime copyCompletionTime;
    private final String copyStatusDescription;
    private final Boolean isServerEncrypted;
    private final Boolean isIncrementalCopy;
    private final String copyDestinationSnapshot;
    private final AccessTier accessTier;
    private final Boolean isAccessTierInferred;
    private final ArchiveStatus archiveStatus;
    private final String encryptionKeySha256;
    private final String encryptionScope;
    private final OffsetDateTime accessTierChangeTime;
    private final Map<String, String> metadata;
    private final Integer committedBlockCount;
    private final Long tagCount;
    private final String versionId;
    private final Boolean isCurrentVersion;
    private final List<ObjectReplicationPolicy> objectReplicationSourcePolicies;
    private final String objectReplicationDestinationPolicyId;
    private final RehydratePriority rehydratePriority;
    private final Boolean isSealed;
    private final OffsetDateTime lastAccessedTime;
    private final OffsetDateTime expiresOn;
    private final BlobImmutabilityPolicy immutabilityPolicy;
    private final Boolean hasLegalHold;

    public BlobPropertiesInternalConstructorProperties(OffsetDateTime creationTime, OffsetDateTime lastModified, String eTag, long blobSize, String contentType, byte[] contentMd5, String contentEncoding, String contentDisposition, String contentLanguage, String cacheControl, Long blobSequenceNumber, BlobType blobType, LeaseStatusType leaseStatus, LeaseStateType leaseState, LeaseDurationType leaseDuration, String copyId, CopyStatusType copyStatus, String copySource, String copyProgress, OffsetDateTime copyCompletionTime, String copyStatusDescription, Boolean isServerEncrypted, Boolean isIncrementalCopy, String copyDestinationSnapshot, AccessTier accessTier, Boolean isAccessTierInferred, ArchiveStatus archiveStatus, String encryptionKeySha256, String encryptionScope, OffsetDateTime accessTierChangeTime, Map<String, String> metadata, Integer committedBlockCount, Long tagCount, String versionId, Boolean isCurrentVersion, List<ObjectReplicationPolicy> objectReplicationSourcePolicies, String objectReplicationDestinationPolicyId, RehydratePriority rehydratePriority, Boolean isSealed, OffsetDateTime lastAccessedTime, OffsetDateTime expiresOn, BlobImmutabilityPolicy immutabilityPolicy, Boolean hasLegalHold) {
        this.creationTime = creationTime;
        this.lastModified = lastModified;
        this.eTag = eTag;
        this.blobSize = blobSize;
        this.contentType = contentType;
        this.contentMd5 = CoreUtils.clone((byte[])contentMd5);
        this.contentEncoding = contentEncoding;
        this.contentDisposition = contentDisposition;
        this.contentLanguage = contentLanguage;
        this.cacheControl = cacheControl;
        this.blobSequenceNumber = blobSequenceNumber;
        this.blobType = blobType;
        this.leaseStatus = leaseStatus;
        this.leaseState = leaseState;
        this.leaseDuration = leaseDuration;
        this.copyId = copyId;
        this.copyStatus = copyStatus;
        this.copySource = copySource;
        this.copyProgress = copyProgress;
        this.copyCompletionTime = copyCompletionTime;
        this.copyStatusDescription = copyStatusDescription;
        this.isServerEncrypted = isServerEncrypted;
        this.isIncrementalCopy = isIncrementalCopy;
        this.copyDestinationSnapshot = copyDestinationSnapshot;
        this.accessTier = accessTier;
        this.isAccessTierInferred = isAccessTierInferred;
        this.archiveStatus = archiveStatus;
        this.encryptionKeySha256 = encryptionKeySha256;
        this.encryptionScope = encryptionScope;
        this.accessTierChangeTime = accessTierChangeTime;
        this.metadata = metadata;
        this.committedBlockCount = committedBlockCount;
        this.tagCount = tagCount;
        this.versionId = versionId;
        this.isCurrentVersion = isCurrentVersion;
        this.objectReplicationSourcePolicies = objectReplicationSourcePolicies;
        this.objectReplicationDestinationPolicyId = objectReplicationDestinationPolicyId;
        this.rehydratePriority = rehydratePriority;
        this.isSealed = isSealed;
        this.lastAccessedTime = lastAccessedTime;
        this.expiresOn = expiresOn;
        this.immutabilityPolicy = immutabilityPolicy;
        this.hasLegalHold = hasLegalHold;
    }

    @Override
    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    @Override
    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    @Override
    public long getBlobSize() {
        return this.blobSize;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public byte[] getContentMd5() {
        return CoreUtils.clone((byte[])this.contentMd5);
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public String getContentDisposition() {
        return this.contentDisposition;
    }

    @Override
    public String getContentLanguage() {
        return this.contentLanguage;
    }

    @Override
    public String getCacheControl() {
        return this.cacheControl;
    }

    @Override
    public Long getBlobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    @Override
    public BlobType getBlobType() {
        return this.blobType;
    }

    @Override
    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    @Override
    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    @Override
    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    @Override
    public String getCopyId() {
        return this.copyId;
    }

    @Override
    public CopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    @Override
    public String getCopySource() {
        return this.copySource;
    }

    @Override
    public String getCopyProgress() {
        return this.copyProgress;
    }

    @Override
    public OffsetDateTime getCopyCompletionTime() {
        return this.copyCompletionTime;
    }

    @Override
    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    @Override
    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    @Override
    public Boolean isIncrementalCopy() {
        return this.isIncrementalCopy;
    }

    @Override
    public String getCopyDestinationSnapshot() {
        return this.copyDestinationSnapshot;
    }

    @Override
    public AccessTier getAccessTier() {
        return this.accessTier;
    }

    @Override
    public Boolean isAccessTierInferred() {
        return this.isAccessTierInferred;
    }

    @Override
    public ArchiveStatus getArchiveStatus() {
        return this.archiveStatus;
    }

    @Override
    public String getEncryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    @Override
    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    @Override
    public OffsetDateTime getAccessTierChangeTime() {
        return this.accessTierChangeTime;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public Integer getCommittedBlockCount() {
        return this.committedBlockCount;
    }

    @Override
    public Long getTagCount() {
        return this.tagCount;
    }

    @Override
    public String getVersionId() {
        return this.versionId;
    }

    @Override
    public Boolean isCurrentVersion() {
        return this.isCurrentVersion;
    }

    @Override
    public List<ObjectReplicationPolicy> getObjectReplicationSourcePolicies() {
        return Collections.unmodifiableList(this.objectReplicationSourcePolicies);
    }

    @Override
    public String getObjectReplicationDestinationPolicyId() {
        return this.objectReplicationDestinationPolicyId;
    }

    @Override
    public RehydratePriority getRehydratePriority() {
        return this.rehydratePriority;
    }

    @Override
    public Boolean isSealed() {
        return this.isSealed;
    }

    @Override
    public OffsetDateTime getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    @Override
    public BlobImmutabilityPolicy getImmutabilityPolicy() {
        return this.immutabilityPolicy;
    }

    @Override
    public Boolean hasLegalHold() {
        return this.hasLegalHold;
    }
}

