/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.util.logging.Logger;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.fips.FipsEntropyConfig;
import org.bouncycastle.crypto.util.EntropyUtil;
import org.bouncycastle.util.Arrays;

class ContinuousTestingEntropySource
implements EntropySource {
    private static final Logger LOG = Logger.getLogger(ContinuousTestingEntropySource.class.getName());
    private final EntropySource entropySource;
    private byte[] buf;
    private EntropyUtil.WindowStats windStats;

    public ContinuousTestingEntropySource(EntropySource entropySource) {
        this.entropySource = entropySource;
    }

    @Override
    public boolean isPredictionResistant() {
        return this.entropySource.isPredictionResistant();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEntropy() {
        ContinuousTestingEntropySource continuousTestingEntropySource = this;
        synchronized (continuousTestingEntropySource) {
            byte[] byArray;
            String string;
            if (this.buf == null) {
                this.buf = this.entropySource.getEntropy();
                this.windStats = EntropyUtil.createStats();
                String string2 = EntropyUtil.isProportionate(this.windStats, this.buf);
                if (string2 != null) {
                    throw new IllegalStateException(string2);
                }
            }
            int n = 0;
            int n2 = FipsEntropyConfig.getMaxRetries();
            do {
                ++n;
                byArray = this.entropySource.getEntropy();
                string = EntropyUtil.isNotStuck(this.buf[this.buf.length - 1], byArray);
                if (string != null) {
                    if (n == n2) {
                        throw new IllegalStateException(string);
                    }
                    LOG.warning(string);
                }
                if ((string = EntropyUtil.isProportionate(this.windStats, byArray)) != null) {
                    if (n == n2) {
                        throw new IllegalStateException(string);
                    }
                    LOG.warning(string);
                }
                if (!Arrays.areEqual(byArray, this.buf)) continue;
                string = "Duplicate block detected in EntropySource output";
                if (n == n2) {
                    throw new IllegalStateException(string);
                }
                LOG.warning(string);
            } while (string != null && n <= n2);
            System.arraycopy(byArray, 0, this.buf, 0, this.buf.length);
            return byArray;
        }
    }

    @Override
    public int entropySize() {
        return this.entropySource.entropySize();
    }
}

