/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query.visitor;

import java.util.Map;
import lombok.Generated;
import org.apache.lucene.search.BooleanClause;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;
import org.opensearch.neuralsearch.query.NeuralQueryBuilder;

public class NeuralSearchQueryVisitor
implements QueryBuilderVisitor {
    private final String modelId;
    private final Map<String, Object> neuralFieldMap;

    public void accept(QueryBuilder queryBuilder) {
        NeuralQueryBuilder neuralQueryBuilder;
        if (queryBuilder instanceof NeuralQueryBuilder && (neuralQueryBuilder = (NeuralQueryBuilder)queryBuilder).modelId() == null) {
            if (this.neuralFieldMap != null && neuralQueryBuilder.fieldName() != null && this.neuralFieldMap.get(neuralQueryBuilder.fieldName()) != null) {
                String fieldDefaultModelId = (String)this.neuralFieldMap.get(neuralQueryBuilder.fieldName());
                neuralQueryBuilder.modelId(fieldDefaultModelId);
            } else if (this.modelId != null) {
                neuralQueryBuilder.modelId(this.modelId);
            } else {
                throw new IllegalArgumentException("model id must be provided in neural query or a default model id must be set in search request processor");
            }
        }
    }

    public QueryBuilderVisitor getChildVisitor(BooleanClause.Occur occur) {
        return this;
    }

    @Generated
    public NeuralSearchQueryVisitor(String modelId, Map<String, Object> neuralFieldMap) {
        this.modelId = modelId;
        this.neuralFieldMap = neuralFieldMap;
    }
}

