/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.explain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.indexmanagement.common.model.rest.SearchParams;
import org.opensearch.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import org.opensearch.indexmanagement.indexstatemanagement.ManagedIndexRunner;
import org.opensearch.indexmanagement.indexstatemanagement.model.ManagedIndexConfig;
import org.opensearch.indexmanagement.indexstatemanagement.model.Policy;
import org.opensearch.indexmanagement.indexstatemanagement.model.State;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.explain.ExplainRequest;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.explain.ExplainResponse;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.explain.TransportExplainActionKt;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexAction;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexRequest;
import org.opensearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import org.opensearch.indexmanagement.indexstatemanagement.util.MetadataCheck;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Action;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ValidationResult;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002 !B7\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/TransportExplainAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/ExplainRequest;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/ExplainResponse;", "client", "Lorg/opensearch/client/node/NodeClient;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "indexMetadataProvider", "Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;", "(Lorg/opensearch/client/node/NodeClient;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;)V", "getClient", "()Lorg/opensearch/client/node/NodeClient;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getIndexMetadataProvider", "()Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/core/action/ActionListener;", "Companion", "ExplainHandler", "opensearch-index-management"})
public final class TransportExplainAction
extends HandledTransportAction<ExplainRequest, ExplainResponse> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NodeClient client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final IndexMetadataProvider indexMetadataProvider;
    @NotNull
    public static final String METADATA_MOVING_WARNING = "Managed index's metadata is pending migration.";
    @NotNull
    public static final String METADATA_CORRUPT_WARNING = "Managed index's metadata is corrupt, please use remove policy API to clean it.";
    @NotNull
    private static final Map<MetadataCheck, Map<String, String>> metadataStatusToInfo;

    @Inject
    public TransportExplainAction(@NotNull NodeClient client, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull ClusterService clusterService, @NotNull NamedXContentRegistry xContentRegistry, @NotNull IndexMetadataProvider indexMetadataProvider) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)indexMetadataProvider, (String)"indexMetadataProvider");
        super("cluster:admin/opendistro/ism/managedindex/explain", transportService, actionFilters, ExplainRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.indexMetadataProvider = indexMetadataProvider;
    }

    @NotNull
    public final NodeClient getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final IndexMetadataProvider getIndexMetadataProvider() {
        return this.indexMetadataProvider;
    }

    protected void doExecute(@NotNull Task task, @NotNull ExplainRequest request, @NotNull ActionListener<ExplainResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        new ExplainHandler(this, this.client, listener, request, null, 8, null).start();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)MetadataCheck.PENDING), (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)METADATA_MOVING_WARNING))), TuplesKt.to((Object)((Object)MetadataCheck.CORRUPT), (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)METADATA_CORRUPT_WARNING)))};
        metadataStatusToInfo = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/TransportExplainAction$Companion;", "", "()V", "METADATA_CORRUPT_WARNING", "", "METADATA_MOVING_WARNING", "metadataStatusToInfo", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/util/MetadataCheck;", "getMetadataStatusToInfo", "()Ljava/util/Map;", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<MetadataCheck, Map<String, String>> getMetadataStatusToInfo() {
            return metadataStatusToInfo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJt\u0010)\u001a\u00020*2\u001a\u0010\u001c\u001a\u0016\u0012\b\u0012\u00060\u000ej\u0002`\u0011\u0012\b\u0012\u00060\u000ej\u0002`\u00190 2,\u0010+\u001a(\u0012\b\u0012\u00060\u000ej\u0002`,\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010 j\u0004\u0018\u0001`!0 2\u0018\u0010-\u001a\u0014\u0012\b\u0012\u00060\u000ej\u0002`\u0011\u0012\u0004\u0012\u00020.\u0018\u00010 2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020*2\u0006\u0010/\u001a\u000200H\u0002J\u001c\u00102\u001a\u00020*2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010/\u001a\u000200J\u0014\u00102\u001a\u0004\u0018\u00010\u00162\b\u00103\u001a\u0004\u0018\u000104H\u0002J*\u00105\u001a\u00020*2\u0018\u0010-\u001a\u0014\u0012\b\u0012\u00060\u000ej\u0002`\u0011\u0012\u0004\u0012\u00020.\u0018\u00010 2\u0006\u0010/\u001a\u000200H\u0002J&\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010;\u001a\u00020%H\u0002J!\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u001d2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?H\u0002\u00a2\u0006\u0002\u0010AJ\u0010\u0010B\u001a\u00020*2\u0006\u0010C\u001a\u000207H\u0002J|\u0010D\u001a\u00020*2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u000e\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u001d2\u0014\u0010F\u001a\u0010\u0012\f\u0012\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u001b0\u001d2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120 2\u0006\u0010H\u001a\u00020%2\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0 2\u000e\u0010J\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0\u001dH\u0002J\u0006\u0010K\u001a\u00020*R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\b\u0012\u00060\u000ej\u0002`\u0011\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u00110\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0018\u001a\u0016\u0012\b\u0012\u00060\u000ej\u0002`\u0011\u0012\b\u0012\u00060\u000ej\u0002`\u00190\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0010\u0012\f\u0012\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u001b0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u00110\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u001f\u001a$\u0012\b\u0012\u00060\u000ej\u0002`\u0011\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0 j\u0002`!0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/TransportExplainAction$ExplainHandler;", "", "client", "Lorg/opensearch/client/node/NodeClient;", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/ExplainResponse;", "request", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/ExplainRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/TransportExplainAction;Lorg/opensearch/client/node/NodeClient;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/ExplainRequest;Lorg/opensearch/commons/authuser/User;)V", "appliedPolicies", "", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/Policy;", "enabledState", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/IndexName;", "", "explainAll", "indexMetadatas", "", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "indexNames", "indexNamesToUUIDs", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/IndexUUID;", "indexPolicyIDs", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/PolicyID;", "indices", "", "managedIndices", "managedIndicesMetaDataMap", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/ManagedIndexMetadataMap;", "policiesforValidation", "showPolicy", "totalManagedIndices", "", "validateAction", "validationResults", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ValidationResult;", "buildResponse", "", "metadataMap", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/ManagedIndexMetadataDocUUID;", "clusterStateIndexMetadatas", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "threadContext", "Lorg/opensearch/common/util/concurrent/ThreadContext$StoredContext;", "filterAndSendResponse", "getMetadata", "response", "Lorg/opensearch/action/get/GetResponse;", "getMetadataMap", "getSearchMetadataRequest", "Lorg/opensearch/action/search/SearchRequest;", "params", "Lorg/opensearch/indexmanagement/common/model/rest/SearchParams;", "indexUUIDs", "searchSize", "parseSearchHits", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ManagedIndexConfig;", "hits", "", "Lorg/opensearch/search/SearchHit;", "([Lorg/opensearch/search/SearchHit;)Ljava/util/List;", "searchForMetadata", "searchRequest", "sendResponse", "metadata", "policyIDs", "enabledStatus", "totalIndices", "policies", "validationResult", "start", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nTransportExplainAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportExplainAction.kt\norg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/TransportExplainAction$ExplainHandler\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,458:1\n37#2,2:459\n1855#3,2:461\n1#4:463\n11335#5:464\n11670#5,3:465\n*S KotlinDebug\n*F\n+ 1 TransportExplainAction.kt\norg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/TransportExplainAction$ExplainHandler\n*L\n265#1:459,2\n290#1:461,2\n438#1:464\n438#1:465,3\n*E\n"})
    public final class ExplainHandler {
        @NotNull
        private final NodeClient client;
        @NotNull
        private final ActionListener<ExplainResponse> actionListener;
        @NotNull
        private final ExplainRequest request;
        @Nullable
        private final User user;
        @NotNull
        private final List<String> indices;
        private final boolean explainAll;
        private final boolean showPolicy;
        private final boolean validateAction;
        @NotNull
        private final Map<String, Map<String, String>> managedIndicesMetaDataMap;
        @NotNull
        private final List<String> managedIndices;
        @NotNull
        private final List<String> indexNames;
        @NotNull
        private final Map<String, String> indexNamesToUUIDs;
        @NotNull
        private final Map<String, Boolean> enabledState;
        @NotNull
        private final List<String> indexPolicyIDs;
        @NotNull
        private final List<ManagedIndexMetaData> indexMetadatas;
        @NotNull
        private final List<ValidationResult> validationResults;
        private int totalManagedIndices;
        @NotNull
        private final Map<String, Policy> appliedPolicies;
        @NotNull
        private final Map<String, Policy> policiesforValidation;
        final /* synthetic */ TransportExplainAction this$0;

        public ExplainHandler(@NotNull TransportExplainAction this$0, @NotNull NodeClient client, @NotNull ActionListener<ExplainResponse> actionListener, @Nullable ExplainRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.this$0 = this$0;
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
            this.indices = this.request.getIndices();
            this.explainAll = this.indices.isEmpty();
            this.showPolicy = this.request.getShowPolicy();
            this.validateAction = this.request.getValidateAction();
            this.managedIndicesMetaDataMap = new LinkedHashMap();
            this.managedIndices = new ArrayList();
            this.indexNames = new ArrayList();
            this.indexNamesToUUIDs = new LinkedHashMap();
            this.enabledState = new LinkedHashMap();
            this.indexPolicyIDs = new ArrayList();
            this.indexMetadatas = new ArrayList();
            this.validationResults = new ArrayList();
            this.appliedPolicies = new LinkedHashMap();
            this.policiesforValidation = new LinkedHashMap();
        }

        public /* synthetic */ ExplainHandler(TransportExplainAction transportExplainAction, NodeClient nodeClient, ActionListener actionListener, ExplainRequest explainRequest, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                ThreadContext threadContext = nodeClient.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"client.threadPool().threadContext");
                user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
            }
            this(transportExplainAction, nodeClient, (ActionListener<ExplainResponse>)actionListener, explainRequest, user);
        }

        public final void start() {
            TransportExplainActionKt.access$getLog$p().debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, this.this$0, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ ExplainHandler this$0;
                final /* synthetic */ TransportExplainAction this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Exception decompiling
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 5[CASE]], but top level block is 1[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                     *     at org.benf.cfr.reader.entities.ClassFile.dumpNamedInnerClasses(ClassFile.java:1161)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:71)
                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        private final SearchRequest getSearchMetadataRequest(SearchParams params, List<String> indexUUIDs, int searchSize) {
            FieldSortBuilder sortBuilder = params.getSortBuilder();
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.queryStringQuery((String)params.getQueryString()).defaultField("managed_index.name.keyword").defaultOperator(Operator.AND)).filter((QueryBuilder)QueryBuilders.termsQuery((String)"managed_index.index_uuid", (Collection)indexUUIDs));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().from(params.getFrom()).fetchSource(FetchSourceContext.FETCH_SOURCE).seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true)).sort((SortBuilder)sortBuilder).size(searchSize).query((QueryBuilder)queryBuilder);
            String[] stringArray = new String[]{".opendistro-ism-config"};
            SearchRequest searchRequest = new SearchRequest().indices(stringArray).source(searchSourceBuilder).preference(Preference.PRIMARY_FIRST.type());
            Intrinsics.checkNotNullExpressionValue((Object)searchRequest, (String)"SearchRequest()\n        \u2026nce.PRIMARY_FIRST.type())");
            return searchRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void searchForMetadata(SearchRequest searchRequest) {
            AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext threadContext = (ThreadContext.StoredContext)autoCloseable;
                boolean bl = false;
                this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this, threadContext){
                    final /* synthetic */ ExplainHandler this$0;
                    final /* synthetic */ ThreadContext.StoredContext $threadContext;
                    {
                        this.this$0 = $receiver;
                        this.$threadContext = $threadContext;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onResponse(@NotNull SearchResponse response2) {
                        Map $this$forEach$iv;
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        TotalHits totalHits = response2.getHits().getTotalHits();
                        if (totalHits != null) {
                            ExplainHandler.access$setTotalManagedIndices$p(this.this$0, (int)totalHits.value);
                        }
                        SearchHit[] searchHitArray = response2.getHits().getHits();
                        Intrinsics.checkNotNullExpressionValue((Object)searchHitArray, (String)"response.hits.hits");
                        Iterable iterable = ExplainHandler.access$parseSearchHits(this.this$0, searchHitArray);
                        ExplainHandler explainHandler = this.this$0;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv.iterator();
                        while (iterator.hasNext()) {
                            Policy it;
                            T element$iv = iterator.next();
                            ManagedIndexConfig managedIndex = (ManagedIndexConfig)element$iv;
                            boolean bl = false;
                            ExplainHandler.access$getManagedIndices$p(explainHandler).add(managedIndex.getIndex());
                            ExplainHandler.access$getEnabledState$p(explainHandler).put(managedIndex.getIndex(), managedIndex.getEnabled());
                            Map map = ExplainHandler.access$getManagedIndicesMetaDataMap$p(explainHandler);
                            String string = managedIndex.getIndex();
                            Object object = new Pair[]{TuplesKt.to((Object)"index", (Object)managedIndex.getIndex()), TuplesKt.to((Object)"index_uuid", (Object)managedIndex.getIndexUuid()), TuplesKt.to((Object)"policy_id", (Object)managedIndex.getPolicyID()), TuplesKt.to((Object)"enabled", (Object)String.valueOf(managedIndex.getEnabled()))};
                            object = MapsKt.mapOf((Pair[])object);
                            map.put(string, object);
                            if (ExplainHandler.access$getShowPolicy$p(explainHandler)) {
                                if (managedIndex.getPolicy() != null) {
                                    boolean bl2 = false;
                                    ExplainHandler.access$getAppliedPolicies$p(explainHandler).put(managedIndex.getIndex(), it);
                                }
                            }
                            if (!ExplainHandler.access$getValidateAction$p(explainHandler)) continue;
                            if (managedIndex.getPolicy() == null) continue;
                            boolean bl3 = false;
                            ExplainHandler.access$getPoliciesforValidation$p(explainHandler).put(managedIndex.getIndex(), it);
                        }
                        if (ExplainHandler.access$getExplainAll$p(this.this$0)) {
                            void $this$filterKeys$iv;
                            if (ExplainHandler.access$getManagedIndices$p(this.this$0).size() == 0) {
                                ExplainHandler.access$getIndexNames$p(this.this$0).clear();
                                ExplainHandler.access$sendResponse(this.this$0, ExplainHandler.access$getIndexNames$p(this.this$0), ExplainHandler.access$getIndexMetadatas$p(this.this$0), ExplainHandler.access$getIndexPolicyIDs$p(this.this$0), ExplainHandler.access$getEnabledState$p(this.this$0), ExplainHandler.access$getTotalManagedIndices$p(this.this$0), ExplainHandler.access$getAppliedPolicies$p(this.this$0), ExplainHandler.access$getValidationResults$p(this.this$0));
                                return;
                            }
                            ExplainHandler.access$getIndexNames$p(this.this$0).clear();
                            ExplainHandler.access$getIndexNames$p(this.this$0).addAll(ExplainHandler.access$getManagedIndices$p(this.this$0));
                            $this$forEach$iv = ExplainHandler.access$getIndexNamesToUUIDs$p(this.this$0);
                            explainHandler = this.this$0;
                            boolean $i$f$filterKeys = false;
                            LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                            for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                                String it = (String)entry$iv.getKey();
                                boolean bl = false;
                                if (!ExplainHandler.access$getIndexNames$p(explainHandler).contains(it)) continue;
                                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                            }
                            Map cfr_ignored_0 = (Map)result$iv;
                            List list = ExplainHandler.access$getIndexNames$p(this.this$0);
                            ThreadContext.StoredContext storedContext = this.$threadContext;
                            Intrinsics.checkNotNullExpressionValue((Object)storedContext, (String)"threadContext");
                            this.this$0.getMetadata(list, storedContext);
                            return;
                        }
                        List list = ExplainHandler.access$getIndexNames$p(this.this$0);
                        ThreadContext.StoredContext storedContext = this.$threadContext;
                        Intrinsics.checkNotNullExpressionValue((Object)storedContext, (String)"threadContext");
                        this.this$0.getMetadata(list, storedContext);
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        if (t instanceof IndexNotFoundException) {
                            if (!ExplainHandler.access$getExplainAll$p(this.this$0)) {
                                List list = ExplainHandler.access$getIndexNames$p(this.this$0);
                                ThreadContext.StoredContext storedContext = this.$threadContext;
                                Intrinsics.checkNotNullExpressionValue((Object)storedContext, (String)"threadContext");
                                this.this$0.getMetadata(list, storedContext);
                                return;
                            }
                            ExplainHandler.access$getIndexNames$p(this.this$0).clear();
                            ExplainHandler.access$sendResponse(this.this$0, ExplainHandler.access$getIndexNames$p(this.this$0), ExplainHandler.access$getIndexMetadatas$p(this.this$0), ExplainHandler.access$getIndexPolicyIDs$p(this.this$0), ExplainHandler.access$getEnabledState$p(this.this$0), ExplainHandler.access$getTotalManagedIndices$p(this.this$0), ExplainHandler.access$getAppliedPolicies$p(this.this$0), ExplainHandler.access$getValidationResults$p(this.this$0));
                            return;
                        }
                        ActionListener actionListener = ExplainHandler.access$getActionListener$p(this.this$0);
                        Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                        Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                        actionListener.onFailure((Exception)throwable);
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        public final void getMetadata(@NotNull List<String> indexNames, @NotNull ThreadContext.StoredContext threadContext) {
            Intrinsics.checkNotNullParameter(indexNames, (String)"indexNames");
            Intrinsics.checkNotNullParameter((Object)threadContext, (String)"threadContext");
            if (Intrinsics.areEqual((Object)this.request.getIndexType(), (Object)"_default")) {
                ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
                Collection $this$toTypedArray$iv = indexNames;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                ((ClusterStateRequest)clusterStateRequest.clear().indices(Arrays.copyOf(stringArray, stringArray.length)).metadata(true).local(this.request.getLocal())).clusterManagerNodeTimeout(this.request.getClusterManagerTimeout());
                this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(this, threadContext){
                    final /* synthetic */ ExplainHandler this$0;
                    final /* synthetic */ ThreadContext.StoredContext $threadContext;
                    {
                        this.this$0 = $receiver;
                        this.$threadContext = $threadContext;
                    }

                    public void onResponse(@NotNull ClusterStateResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        Map clusterStateIndexMetadatas = response2.getState().getMetadata().getIndices();
                        ExplainHandler.access$getMetadataMap(this.this$0, clusterStateIndexMetadatas, this.$threadContext);
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        ActionListener actionListener = ExplainHandler.access$getActionListener$p(this.this$0);
                        Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                        Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                        actionListener.onFailure((Exception)throwable);
                    }
                });
            } else {
                this.getMetadataMap(null, threadContext);
            }
        }

        private final void getMetadataMap(Map<String, ? extends IndexMetadata> clusterStateIndexMetadatas, ThreadContext.StoredContext threadContext) {
            MultiGetRequest mgetMetadataReq = new MultiGetRequest();
            Iterable $this$forEach$iv = this.indexNamesToUUIDs.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String uuid = (String)element$iv;
                boolean bl = false;
                mgetMetadataReq.add(new MultiGetRequest.Item(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID(uuid)).routing(uuid));
            }
            this.client.multiGet(mgetMetadataReq, (ActionListener)new ActionListener<MultiGetResponse>(this, clusterStateIndexMetadatas, threadContext){
                final /* synthetic */ ExplainHandler this$0;
                final /* synthetic */ Map<String, IndexMetadata> $clusterStateIndexMetadatas;
                final /* synthetic */ ThreadContext.StoredContext $threadContext;
                {
                    this.this$0 = $receiver;
                    this.$clusterStateIndexMetadatas = $clusterStateIndexMetadatas;
                    this.$threadContext = $threadContext;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onResponse(@NotNull MultiGetResponse response2) {
                    void $this$associateTo$iv$iv;
                    void $this$associate$iv;
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    MultiGetItemResponse[] multiGetItemResponseArray = response2.getResponses();
                    Intrinsics.checkNotNullExpressionValue((Object)multiGetItemResponseArray, (String)"response.responses");
                    Object[] objectArray = multiGetItemResponseArray;
                    ExplainHandler explainHandler = this.this$0;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associate$iv).length), (int)16);
                    void var7_6 = $this$associate$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (void element$iv$iv : $this$associateTo$iv$iv) {
                        Map map = destination$iv$iv;
                        MultiGetItemResponse it = (MultiGetItemResponse)element$iv$iv;
                        boolean bl = false;
                        ManagedIndexMetaData managedIndexMetaData = ExplainHandler.access$getMetadata(explainHandler, it.getResponse());
                        Pair pair = TuplesKt.to((Object)it.getId(), (Object)(managedIndexMetaData != null ? managedIndexMetaData.toMap() : null));
                        map.put(pair.getFirst(), pair.getSecond());
                    }
                    Map metadataMap = destination$iv$iv;
                    ExplainHandler.access$buildResponse(this.this$0, ExplainHandler.access$getIndexNamesToUUIDs$p(this.this$0), metadataMap, this.$clusterStateIndexMetadatas, this.$threadContext);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    ActionListener actionListener = ExplainHandler.access$getActionListener$p(this.this$0);
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    actionListener.onFailure((Exception)throwable);
                }
            });
        }

        private final void buildResponse(Map<String, String> indices, Map<String, ? extends Map<String, String>> metadataMap, Map<String, ? extends IndexMetadata> clusterStateIndexMetadatas, ThreadContext.StoredContext threadContext) {
            for (String indexName : this.indexNames) {
                String string;
                Map<String, String> metadataMapFromManagedIndex;
                Map<String, String> map = metadataMapFromManagedIndex = this.managedIndicesMetaDataMap.get(indexName);
                this.indexPolicyIDs.add(map != null ? map.get("policy_id") : null);
                ManagedIndexMetaData managedIndexMetadata = null;
                if (indices.get(indexName) != null) {
                    String it;
                    boolean bl = false;
                    string = ManagedIndexUtils.managedIndexMetadataID(it);
                } else {
                    string = null;
                }
                String managedIndexMetadataDocUUID = string;
                Map<String, String> configIndexMetadataMap = metadataMap.get(managedIndexMetadataDocUUID);
                if (metadataMapFromManagedIndex != null) {
                    if (configIndexMetadataMap != null) {
                        metadataMapFromManagedIndex = configIndexMetadataMap;
                    }
                    if (!metadataMapFromManagedIndex.isEmpty()) {
                        managedIndexMetadata = ManagedIndexMetaData.Companion.fromMap(metadataMapFromManagedIndex);
                    }
                    if (clusterStateIndexMetadatas != null) {
                        String currentIndexUuid = indices.get(indexName);
                        IndexMetadata indexMetadata2 = clusterStateIndexMetadatas.get(indexName);
                        ManagedIndexMetaData clusterStateMetadata = indexMetadata2 != null ? org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt.getManagedIndexMetadata(indexMetadata2) : null;
                        Logger logger = TransportExplainActionKt.access$getLog$p();
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
                        MetadataCheck metadataCheck = ManagedIndexUtils.checkMetadata(clusterStateMetadata, configIndexMetadataMap, currentIndexUuid, logger);
                        Map<String, String> info = Companion.getMetadataStatusToInfo().get((Object)metadataCheck);
                        if (info != null) {
                            Map<String, String> it;
                            boolean bl = false;
                            ManagedIndexMetaData managedIndexMetaData = clusterStateMetadata;
                            managedIndexMetadata = managedIndexMetaData != null ? ManagedIndexMetaData.copy$default((ManagedIndexMetaData)managedIndexMetaData, null, null, null, null, null, null, null, null, null, null, null, null, null, it, null, (long)0L, (long)0L, null, (int)253951, null) : null;
                        }
                    }
                }
                if (this.validateAction) {
                    ValidationResult validationResult2 = ManagedIndexRunner.INSTANCE.getActionValidation().validate("nothing", indexName);
                    Policy policy2 = this.policiesforValidation.get(indexName);
                    if (policy2 != null && managedIndexMetadata != null) {
                        String actionName;
                        Action action;
                        State state;
                        State state2 = state = policy2.getStateToExecute(managedIndexMetadata);
                        Action action2 = action = state2 != null ? state2.getActionToExecute(managedIndexMetadata, this.this$0.getIndexMetadataProvider()) : null;
                        String string2 = actionName = action2 != null ? action2.getType() : null;
                        if (actionName == null) {
                            actionName = "nothing";
                        }
                        validationResult2 = ManagedIndexRunner.INSTANCE.getActionValidation().validate(actionName, indexName);
                    }
                    this.validationResults.add(validationResult2);
                } else {
                    this.validationResults.add(null);
                }
                this.indexMetadatas.add(managedIndexMetadata);
            }
            this.managedIndicesMetaDataMap.clear();
            if (this.user == null || this.indexNames.isEmpty()) {
                this.sendResponse(this.indexNames, this.indexMetadatas, this.indexPolicyIDs, this.enabledState, this.totalManagedIndices, this.appliedPolicies, this.validationResults);
            } else {
                this.filterAndSendResponse(threadContext);
            }
        }

        private final void filterAndSendResponse(ThreadContext.StoredContext threadContext) {
            threadContext.restore();
            List filteredIndices = new ArrayList();
            List filteredMetadata = new ArrayList();
            List filteredValidationResult = new ArrayList();
            List filteredPolicies = new ArrayList();
            Map enabledStatus = new LinkedHashMap();
            Map filteredAppliedPolicies = new LinkedHashMap();
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (List<String>)filteredIndices, (List<ManagedIndexMetaData>)filteredMetadata, (List<String>)filteredPolicies, (Map<String, Boolean>)enabledStatus, (Map<String, Policy>)filteredAppliedPolicies, (List<ValidationResult>)filteredValidationResult, null){
                int I$0;
                int I$1;
                int label;
                final /* synthetic */ ExplainHandler this$0;
                final /* synthetic */ List<String> $filteredIndices;
                final /* synthetic */ List<ManagedIndexMetaData> $filteredMetadata;
                final /* synthetic */ List<String> $filteredPolicies;
                final /* synthetic */ Map<String, Boolean> $enabledStatus;
                final /* synthetic */ Map<String, Policy> $filteredAppliedPolicies;
                final /* synthetic */ List<ValidationResult> $filteredValidationResult;
                {
                    this.this$0 = $receiver;
                    this.$filteredIndices = $filteredIndices;
                    this.$filteredMetadata = $filteredMetadata;
                    this.$filteredPolicies = $filteredPolicies;
                    this.$enabledStatus = $enabledStatus;
                    this.$filteredAppliedPolicies = $filteredAppliedPolicies;
                    this.$filteredValidationResult = $filteredValidationResult;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            i = 0;
                            var3_4 = ((Collection)ExplainHandler.access$getIndexNames$p(this.this$0)).size();
lbl7:
                            // 2 sources

                            while (i < var3_4) {
                                var5_6 /* !! */  = new String[]{ExplainHandler.access$getIndexNames$p(this.this$0).get(i)};
                                request = (ManagedIndexRequest)new ManagedIndexRequest(new String[0]).indices(var5_6 /* !! */ );
                                this.I$0 = i;
                                this.I$1 = var3_4;
                                this.label = 1;
                                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)ExplainHandler.access$getClient$p(this.this$0), (Function2)new Function2<NodeClient, ActionListener<AcknowledgedResponse>, Unit>(request){
                                    final /* synthetic */ ManagedIndexRequest $request;
                                    {
                                        this.$request = $request;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull NodeClient $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        $this$suspendUntil.execute((ActionType)ManagedIndexAction.Companion.getINSTANCE(), (ActionRequest)this.$request, it);
                                    }
                                }, (Continuation)this);
                                ** if (v0 != var12_2) goto lbl18
lbl17:
                                // 1 sources

                                return var12_2;
lbl18:
                                // 1 sources

                                ** GOTO lbl27
                            }
                            break;
                        }
                        case 1: {
                            var3_4 = this.I$1;
                            i = this.I$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl27:
                                // 2 sources

                                this.$filteredIndices.add((String)ExplainHandler.access$getIndexNames$p(this.this$0).get(i));
                                this.$filteredMetadata.add((ManagedIndexMetaData)ExplainHandler.access$getIndexMetadatas$p(this.this$0).get(i));
                                this.$filteredPolicies.add((String)ExplainHandler.access$getIndexPolicyIDs$p(this.this$0).get(i));
                                var5_6 /* !! */  = ExplainHandler.access$getValidationResults$p(this.this$0).get(i);
                                var6_9 = this.$filteredValidationResult;
                                it = (ValidationResult)var5_6 /* !! */ ;
                                $i$a$-let-TransportExplainAction$ExplainHandler$filterAndSendResponse$1$2 = false;
                                var6_9.add(it);
                                v1 = (Boolean)ExplainHandler.access$getEnabledState$p(this.this$0).get(ExplainHandler.access$getIndexNames$p(this.this$0).get(i));
                                if (v1 != null) {
                                    var6_9 = v1;
                                    var7_10 = this.$enabledStatus;
                                    var8_12 = this.this$0;
                                    it = var6_9.booleanValue();
                                    $i$a$-let-TransportExplainAction$ExplainHandler$filterAndSendResponse$1$3 = false;
                                    var11_17 = Boxing.boxBoolean((boolean)(it != false));
                                    var7_10.put((String)ExplainHandler.access$getIndexNames$p(var8_12).get(i), var11_17);
                                }
                                v2 = (Policy)ExplainHandler.access$getAppliedPolicies$p(this.this$0).get(ExplainHandler.access$getIndexNames$p(this.this$0).get(i));
                                if (v2 != null) {
                                    var6_9 = v2;
                                    var7_10 = this.$filteredAppliedPolicies;
                                    var8_13 = this.this$0;
                                    it = var6_9;
                                    $i$a$-let-TransportExplainAction$ExplainHandler$filterAndSendResponse$1$4 = false;
                                    var7_10.put((String)ExplainHandler.access$getIndexNames$p(var8_13).get(i), (Boolean)it);
                                }
                            }
                            catch (OpenSearchSecurityException var5_7) {
                                var6_9 = this.this$0;
                                ExplainHandler.access$setTotalManagedIndices$p((ExplainHandler)var6_9, ExplainHandler.access$getTotalManagedIndices$p((ExplainHandler)var6_9) - 1);
                            }
                            catch (Exception e) {
                                ExplainHandler.access$getActionListener$p(this.this$0).onFailure(e);
                            }
                            ++i;
                            ** GOTO lbl7
                        }
                    }
                    ExplainHandler.access$sendResponse(this.this$0, this.$filteredIndices, this.$filteredMetadata, this.$filteredPolicies, this.$enabledStatus, ExplainHandler.access$getTotalManagedIndices$p(this.this$0), this.$filteredAppliedPolicies, this.$filteredValidationResult);
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        private final void sendResponse(List<String> indices, List<ManagedIndexMetaData> metadata2, List<String> policyIDs, Map<String, Boolean> enabledStatus, int totalIndices, Map<String, Policy> policies2, List<ValidationResult> validationResult2) {
            this.actionListener.onResponse((Object)new ExplainResponse(indices, policyIDs, metadata2, totalIndices, enabledStatus, policies2, validationResult2));
        }

        private final ManagedIndexMetaData getMetadata(GetResponse response2) {
            if (response2 == null || response2.getSourceAsBytesRef() == null) {
                return null;
            }
            try {
                XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.this$0.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
                Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                String string = response2.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                return ManagedIndexMetaData.Companion.parseWithType(xcp, string, response2.getSeqNo(), response2.getPrimaryTerm());
            }
            catch (Exception e) {
                TransportExplainActionKt.access$getLog$p().error("Failed to parse the ManagedIndexMetadata for " + response2.getId(), (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<ManagedIndexConfig> parseSearchHits(SearchHit[] hits) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            SearchHit[] searchHitArray = hits;
            TransportExplainAction transportExplainAction = this.this$0;
            boolean $i$f$map = false;
            void var5_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void hit;
                void item$iv$iv;
                void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                XContentParser xContentParser = XContentHelper.createParser((NamedXContentRegistry)transportExplainAction.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)hit.getSourceRef(), (MediaType)((MediaType)XContentType.JSON));
                Intrinsics.checkNotNullExpressionValue((Object)xContentParser, (String)"createParser(\n          \u2026pe.JSON\n                )");
                collection.add((ManagedIndexConfig)OpenSearchExtensionsKt.parseWithType$default(xContentParser, null, 0L, 0L, (Function4)new Function4<XContentParser, String, Long, Long, ManagedIndexConfig>((Object)ManagedIndexConfig.Companion){

                    @NotNull
                    public final ManagedIndexConfig invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return ((ManagedIndexConfig.Companion)this.receiver).parse(p0, p1, p2, p3);
                    }
                }, 7, null));
            }
            return (List)destination$iv$iv;
        }

        public static final /* synthetic */ boolean access$getExplainAll$p(ExplainHandler $this) {
            return $this.explainAll;
        }

        public static final /* synthetic */ ExplainRequest access$getRequest$p(ExplainHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ List access$getIndices$p(ExplainHandler $this) {
            return $this.indices;
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(ExplainHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ List access$getIndexNames$p(ExplainHandler $this) {
            return $this.indexNames;
        }

        public static final /* synthetic */ Map access$getIndexNamesToUUIDs$p(ExplainHandler $this) {
            return $this.indexNamesToUUIDs;
        }

        public static final /* synthetic */ SearchRequest access$getSearchMetadataRequest(ExplainHandler $this, SearchParams params, List indexUUIDs, int searchSize) {
            return $this.getSearchMetadataRequest(params, indexUUIDs, searchSize);
        }

        public static final /* synthetic */ void access$searchForMetadata(ExplainHandler $this, SearchRequest searchRequest) {
            $this.searchForMetadata(searchRequest);
        }

        public static final /* synthetic */ void access$getMetadataMap(ExplainHandler $this, Map clusterStateIndexMetadatas, ThreadContext.StoredContext threadContext) {
            $this.getMetadataMap(clusterStateIndexMetadatas, threadContext);
        }

        public static final /* synthetic */ void access$buildResponse(ExplainHandler $this, Map indices, Map metadataMap, Map clusterStateIndexMetadatas, ThreadContext.StoredContext threadContext) {
            $this.buildResponse(indices, metadataMap, clusterStateIndexMetadatas, threadContext);
        }

        public static final /* synthetic */ ManagedIndexMetaData access$getMetadata(ExplainHandler $this, GetResponse response2) {
            return $this.getMetadata(response2);
        }

        public static final /* synthetic */ NodeClient access$getClient$p(ExplainHandler $this) {
            return $this.client;
        }

        public static final /* synthetic */ List access$getIndexMetadatas$p(ExplainHandler $this) {
            return $this.indexMetadatas;
        }

        public static final /* synthetic */ List access$getIndexPolicyIDs$p(ExplainHandler $this) {
            return $this.indexPolicyIDs;
        }

        public static final /* synthetic */ List access$getValidationResults$p(ExplainHandler $this) {
            return $this.validationResults;
        }

        public static final /* synthetic */ Map access$getEnabledState$p(ExplainHandler $this) {
            return $this.enabledState;
        }

        public static final /* synthetic */ Map access$getAppliedPolicies$p(ExplainHandler $this) {
            return $this.appliedPolicies;
        }

        public static final /* synthetic */ void access$setTotalManagedIndices$p(ExplainHandler $this, int n) {
            $this.totalManagedIndices = n;
        }

        public static final /* synthetic */ int access$getTotalManagedIndices$p(ExplainHandler $this) {
            return $this.totalManagedIndices;
        }

        public static final /* synthetic */ void access$sendResponse(ExplainHandler $this, List indices, List metadata2, List policyIDs, Map enabledStatus, int totalIndices, Map policies2, List validationResult2) {
            $this.sendResponse(indices, metadata2, policyIDs, enabledStatus, totalIndices, policies2, validationResult2);
        }

        public static final /* synthetic */ List access$parseSearchHits(ExplainHandler $this, SearchHit[] hits) {
            return $this.parseSearchHits(hits);
        }

        public static final /* synthetic */ List access$getManagedIndices$p(ExplainHandler $this) {
            return $this.managedIndices;
        }

        public static final /* synthetic */ Map access$getPoliciesforValidation$p(ExplainHandler $this) {
            return $this.policiesforValidation;
        }

        public static final /* synthetic */ Map access$getManagedIndicesMetaDataMap$p(ExplainHandler $this) {
            return $this.managedIndicesMetaDataMap;
        }

        public static final /* synthetic */ boolean access$getShowPolicy$p(ExplainHandler $this) {
            return $this.showPolicy;
        }

        public static final /* synthetic */ boolean access$getValidateAction$p(ExplainHandler $this) {
            return $this.validateAction;
        }
    }
}

