/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsResponse;
import software.amazon.awssdk.services.ec2.model.IpamPoolAllocation;

public class GetIpamPoolAllocationsIterable
implements SdkIterable<GetIpamPoolAllocationsResponse> {
    private final Ec2Client client;
    private final GetIpamPoolAllocationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetIpamPoolAllocationsIterable(Ec2Client client, GetIpamPoolAllocationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetIpamPoolAllocationsResponseFetcher();
    }

    public Iterator<GetIpamPoolAllocationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpamPoolAllocation> ipamPoolAllocations() {
        Function<GetIpamPoolAllocationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamPoolAllocations() != null) {
                return response.ipamPoolAllocations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetIpamPoolAllocationsResponseFetcher
    implements SyncPageFetcher<GetIpamPoolAllocationsResponse> {
        private GetIpamPoolAllocationsResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamPoolAllocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetIpamPoolAllocationsResponse nextPage(GetIpamPoolAllocationsResponse previousPage) {
            if (previousPage == null) {
                return GetIpamPoolAllocationsIterable.this.client.getIpamPoolAllocations(GetIpamPoolAllocationsIterable.this.firstRequest);
            }
            return GetIpamPoolAllocationsIterable.this.client.getIpamPoolAllocations((GetIpamPoolAllocationsRequest)((Object)GetIpamPoolAllocationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

