/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsResponse;
import software.amazon.awssdk.services.ec2.model.InstanceCreditSpecification;

public class DescribeInstanceCreditSpecificationsIterable
implements SdkIterable<DescribeInstanceCreditSpecificationsResponse> {
    private final Ec2Client client;
    private final DescribeInstanceCreditSpecificationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstanceCreditSpecificationsIterable(Ec2Client client, DescribeInstanceCreditSpecificationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstanceCreditSpecificationsResponseFetcher();
    }

    public Iterator<DescribeInstanceCreditSpecificationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceCreditSpecification> instanceCreditSpecifications() {
        Function<DescribeInstanceCreditSpecificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceCreditSpecifications() != null) {
                return response.instanceCreditSpecifications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstanceCreditSpecificationsResponseFetcher
    implements SyncPageFetcher<DescribeInstanceCreditSpecificationsResponse> {
        private DescribeInstanceCreditSpecificationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceCreditSpecificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstanceCreditSpecificationsResponse nextPage(DescribeInstanceCreditSpecificationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceCreditSpecificationsIterable.this.client.describeInstanceCreditSpecifications(DescribeInstanceCreditSpecificationsIterable.this.firstRequest);
            }
            return DescribeInstanceCreditSpecificationsIterable.this.client.describeInstanceCreditSpecifications((DescribeInstanceCreditSpecificationsRequest)((Object)DescribeInstanceCreditSpecificationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

