/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.model.Config;

public class SuggestConfigParamRequest
extends ActionRequest {
    private final AnalysisType context;
    private final Config config;
    private final String param;
    private final TimeValue requestTimeout;

    public SuggestConfigParamRequest(StreamInput in) throws IOException {
        super(in);
        this.context = (AnalysisType)in.readEnum(AnalysisType.class);
        if (this.getContext().isAD()) {
            this.config = new AnomalyDetector(in);
        } else if (this.getContext().isForecast()) {
            this.config = new Forecaster(in);
        } else {
            throw new UnsupportedOperationException("This method is not supported");
        }
        this.param = in.readString();
        this.requestTimeout = in.readTimeValue();
    }

    public SuggestConfigParamRequest(AnalysisType context, Config config, String param, TimeValue requestTimeout) {
        this.context = context;
        this.config = config;
        this.param = param;
        this.requestTimeout = requestTimeout;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum((Enum)this.getContext());
        this.config.writeTo(out);
        out.writeString(this.param);
        out.writeTimeValue(this.requestTimeout);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getParam() {
        return this.param;
    }

    public TimeValue getRequestTimeout() {
        return this.requestTimeout;
    }

    public AnalysisType getContext() {
        return this.context;
    }
}

