/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.suggest.term;

import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import org.opensearch.LegacyESVersion;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.text.Text;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.suggest.SortBy;
import org.opensearch.search.suggest.Suggest;

public class TermSuggestion
extends Suggest.Suggestion<Entry> {
    @Deprecated
    public static final int TYPE = 1;
    public static final Comparator<Suggest.Suggestion.Entry.Option> SCORE = new Score();
    public static final Comparator<Suggest.Suggestion.Entry.Option> FREQUENCY = new Frequency();
    private SortBy sort;

    public TermSuggestion(String name, int size, SortBy sort) {
        super(name, size);
        this.sort = sort;
    }

    public TermSuggestion(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            this.sort = SortBy.readFromStream(in);
        }
    }

    @Override
    public int getWriteableType() {
        return 1;
    }

    public void setSort(SortBy sort) {
        this.sort = sort;
    }

    public SortBy getSort() {
        return this.sort;
    }

    @Override
    protected Comparator<Suggest.Suggestion.Entry.Option> sortComparator() {
        switch (this.sort) {
            case SCORE: {
                return SCORE;
            }
            case FREQUENCY: {
                return FREQUENCY;
            }
        }
        throw new OpenSearchException("Could not resolve comparator for sort key: [" + this.sort + "]", new Object[0]);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            this.sort.writeTo(out);
        }
    }

    @Override
    public String getWriteableName() {
        return "term";
    }

    public static TermSuggestion fromXContent(XContentParser parser, String name) throws IOException {
        TermSuggestion suggestion = new TermSuggestion(name, -1, SortBy.SCORE);
        TermSuggestion.parseEntries(parser, suggestion, Entry::fromXContent);
        return suggestion;
    }

    @Override
    protected Entry newEntry(StreamInput in) throws IOException {
        return new Entry(in);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && Objects.equals((Object)this.sort, (Object)((TermSuggestion)other).sort);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.sort});
    }

    public static class Entry
    extends Suggest.Suggestion.Entry<Option> {
        private static final ObjectParser<Entry, Void> PARSER = new ObjectParser("TermSuggestionEntryParser", true, Entry::new);

        public Entry(Text text, int offset, int length) {
            super(text, offset, length);
        }

        private Entry() {
        }

        public Entry(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        protected Option newOption(StreamInput in) throws IOException {
            return new Option(in);
        }

        public static Entry fromXContent(XContentParser parser) {
            return (Entry)PARSER.apply(parser, null);
        }

        static {
            Entry.declareCommonFields(PARSER);
            PARSER.declareObjectArray((e, o) -> e.addOptions(o), (p, c) -> Option.fromXContent(p), new ParseField("options", new String[0]));
        }

        public static class Option
        extends Suggest.Suggestion.Entry.Option {
            public static final ParseField FREQ = new ParseField("freq", new String[0]);
            private int freq;
            private static final ConstructingObjectParser<Option, Void> PARSER = new ConstructingObjectParser("TermSuggestionOptionParser", true, args -> {
                Text text = new Text((String)args[0]);
                int freq = (Integer)args[1];
                float score = ((Float)args[2]).floatValue();
                return new Option(text, freq, score);
            });

            public Option(Text text, int freq, float score) {
                super(text, score);
                this.freq = freq;
            }

            public Option(StreamInput in) throws IOException {
                super(in);
                this.freq = in.readVInt();
            }

            @Override
            protected void mergeInto(Suggest.Suggestion.Entry.Option otherOption) {
                super.mergeInto(otherOption);
                this.freq += ((Option)otherOption).freq;
            }

            public void setFreq(int freq) {
                this.freq = freq;
            }

            public int getFreq() {
                return this.freq;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                out.writeVInt(this.freq);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder = super.toXContent(builder, params);
                builder.field(FREQ.getPreferredName(), this.freq);
                return builder;
            }

            public static Option fromXContent(XContentParser parser) {
                return (Option)PARSER.apply(parser, null);
            }

            static {
                PARSER.declareString(ConstructingObjectParser.constructorArg(), Suggest.Suggestion.Entry.Option.TEXT);
                PARSER.declareInt(ConstructingObjectParser.constructorArg(), FREQ);
                PARSER.declareFloat(ConstructingObjectParser.constructorArg(), Suggest.Suggestion.Entry.Option.SCORE);
            }
        }
    }

    public static class Frequency
    implements Comparator<Suggest.Suggestion.Entry.Option> {
        @Override
        public int compare(Suggest.Suggestion.Entry.Option first, Suggest.Suggestion.Entry.Option second) {
            int cmp = ((Entry.Option)second).getFreq() - ((Entry.Option)first).getFreq();
            if (cmp != 0) {
                return cmp;
            }
            cmp = Float.compare(second.getScore(), first.getScore());
            if (cmp != 0) {
                return cmp;
            }
            return first.getText().compareTo(second.getText());
        }
    }

    public static class Score
    implements Comparator<Suggest.Suggestion.Entry.Option> {
        @Override
        public int compare(Suggest.Suggestion.Entry.Option first, Suggest.Suggestion.Entry.Option second) {
            int cmp = Float.compare(second.getScore(), first.getScore());
            if (cmp != 0) {
                return cmp;
            }
            return FREQUENCY.compare(first, second);
        }
    }
}

