/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.validate.query;

import java.io.IOException;
import java.util.Arrays;
import org.opensearch.Version;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.broadcast.BroadcastRequest;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;

public class ValidateQueryRequest
extends BroadcastRequest<ValidateQueryRequest>
implements ToXContentObject {
    private QueryBuilder query = new MatchAllQueryBuilder();
    private boolean explain;
    private boolean rewrite;
    private boolean allShards;
    long nowInMillis;

    public ValidateQueryRequest() {
        this(Strings.EMPTY_ARRAY);
    }

    public ValidateQueryRequest(StreamInput in) throws IOException {
        super(in);
        int typesSize;
        this.query = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        if (in.getVersion().before(Version.V_2_0_0) && (typesSize = in.readVInt()) > 0) {
            for (int i = 0; i < typesSize; ++i) {
                in.readString();
            }
        }
        this.explain = in.readBoolean();
        this.rewrite = in.readBoolean();
        this.allShards = in.readBoolean();
    }

    public ValidateQueryRequest(String ... indices) {
        super(indices);
        this.indicesOptions(IndicesOptions.fromOptions(false, false, true, false));
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.query == null) {
            validationException = ValidateActions.addValidationError("query cannot be null", validationException);
        }
        return validationException;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public ValidateQueryRequest query(QueryBuilder query) {
        this.query = query;
        return this;
    }

    public void explain(boolean explain) {
        this.explain = explain;
    }

    public boolean explain() {
        return this.explain;
    }

    public void rewrite(boolean rewrite) {
        this.rewrite = rewrite;
    }

    public boolean rewrite() {
        return this.rewrite;
    }

    public void allShards(boolean allShards) {
        this.allShards = allShards;
    }

    public boolean allShards() {
        return this.allShards;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.query);
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeVInt(0);
        }
        out.writeBoolean(this.explain);
        out.writeBoolean(this.rewrite);
        out.writeBoolean(this.allShards);
    }

    public String toString() {
        return "[" + Arrays.toString(this.indices) + "] query[" + this.query + "], explain:" + this.explain + ", rewrite:" + this.rewrite + ", all_shards:" + this.allShards;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("query");
        this.query.toXContent(builder, params);
        return builder.endObject();
    }
}

