/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.text;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.AbstractModifyMultipleFilesAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;

public class FixCrLfAction
extends AbstractModifyMultipleFilesAction {
    private String[] suffixes;
    private boolean recursive;

    public String[] getSuffixes() {
        return this.replaceWithTextOverride("suffixes", FixCrLfAction.replaceVariables(this.suffixes), String[].class);
    }

    public void setSuffixes(String[] suffixes) {
        this.suffixes = suffixes;
    }

    public boolean isRecursive() {
        return this.replaceWithTextOverride("recursive", this.recursive);
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Override
    public boolean modifyFile(File file, Context context) throws IOException, UserCanceledException {
        return this.fixFiles(file, this.createFilenameFilter(), true, context);
    }

    @Override
    protected boolean fileMustExist() {
        return true;
    }

    private FilenameFilter createFilenameFilter() {
        String[] usedSuffixes = this.getSuffixes();
        return (dir, name) -> {
            if (usedSuffixes == null || usedSuffixes.length == 0 || new File(dir, name).isDirectory()) {
                return true;
            }
            for (String usedSuffix : usedSuffixes) {
                if (!name.endsWith(usedSuffix)) continue;
                return true;
            }
            return false;
        };
    }

    private boolean fixFiles(File usedFile, FilenameFilter fileNameFilter, boolean fixDirectoryContent, Context context) throws UserCanceledException {
        if (usedFile.isDirectory()) {
            File[] files;
            boolean success = true;
            if (fixDirectoryContent && (files = usedFile.listFiles(fileNameFilter)) != null) {
                for (File child : files) {
                    if (this.fixFiles(child, fileNameFilter, this.isRecursive(), context)) continue;
                    success = false;
                }
            }
            return success;
        }
        if (context instanceof InstallerContext) {
            BackupFileForRollbackAction backupAction = new BackupFileForRollbackAction(usedFile, false);
            backupAction.install((InstallerContext)context);
            this.addRollbackAction(backupAction);
        }
        return this.fixSingleFile(usedFile);
    }

    private boolean fixSingleFile(File usedFile) {
        try {
            long modified = usedFile.lastModified();
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(usedFile)));){
                String line;
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
            }
            try (PrintWriter pw = new PrintWriter(new FileOutputStream(usedFile));){
                for (String line : lines) {
                    pw.println(line);
                }
            }
            usedFile.setLastModified(modified);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

