/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.XPropertySet;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XRow;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;
import java.util.ArrayList;

public class TypeInspector {
    private String[] sDataTypeNames;
    private int[] nDataTypeInfos;
    private int[] nPrecisionInfos;
    private int[] nNullableInfos;
    private boolean[] bisAutoIncrementableInfos;
    private int[] nMinScaleInfos;
    private int[] nMaxScaleInfos;
    private final int[] nNumericFallBackList = new int[]{4, 6, 7, 8, 2, 3};
    static final int INVALID = 999999;

    public TypeInspector(XResultSet _xResultSet) {
        try {
            ArrayList<String> aTypeNameVector = new ArrayList<String>();
            ArrayList<Integer> aTypeVector = new ArrayList<Integer>();
            ArrayList<Integer> aNullableVector = new ArrayList<Integer>();
            ArrayList<Boolean> aAutoIncrementVector = new ArrayList<Boolean>();
            ArrayList<Integer> aPrecisionVector = new ArrayList<Integer>();
            ArrayList<Integer> aMinScaleVector = new ArrayList<Integer>();
            ArrayList<Integer> aMaxScaleVector = new ArrayList<Integer>();
            XRow xRow = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)_xResultSet);
            while (_xResultSet.next()) {
                aTypeNameVector.add(xRow.getString(1));
                aTypeVector.add(Integer.valueOf(xRow.getShort(2)));
                aPrecisionVector.add(xRow.getInt(3));
                aNullableVector.add(Integer.valueOf(xRow.getShort(7)));
                aAutoIncrementVector.add(xRow.getBoolean(12));
                aMinScaleVector.add(Integer.valueOf(xRow.getShort(14)));
                aMaxScaleVector.add(Integer.valueOf(xRow.getShort(15)));
            }
            this.sDataTypeNames = new String[aTypeNameVector.size()];
            aTypeNameVector.toArray(this.sDataTypeNames);
            this.nDataTypeInfos = JavaTools.IntegerTointList(aTypeVector);
            this.nNullableInfos = JavaTools.IntegerTointList(aNullableVector);
            this.bisAutoIncrementableInfos = JavaTools.BooleanTobooleanList(aAutoIncrementVector);
            this.nPrecisionInfos = JavaTools.IntegerTointList(aPrecisionVector);
            this.nMinScaleInfos = JavaTools.IntegerTointList(aMinScaleVector);
            this.nMaxScaleInfos = JavaTools.IntegerTointList(aMaxScaleVector);
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
    }

    public int getScale(XPropertySet _xColPropertySet) {
        try {
            int i = this.getDataTypeIndex(_xColPropertySet, false);
            int nScale = AnyConverter.toInt((Object)_xColPropertySet.getPropertyValue("Scale"));
            if (i == -1) {
                return nScale;
            }
            if (nScale > this.nMaxScaleInfos[i]) {
                return this.nMaxScaleInfos[i];
            }
            if (nScale < this.nMinScaleInfos[i]) {
                return this.nMinScaleInfos[i];
            }
            return nScale;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return 0;
        }
    }

    public int getNullability(XPropertySet _xColPropertySet, int _nNullable) {
        int i = this.getDataTypeIndex(_xColPropertySet, false);
        if (i == -1) {
            return 0;
        }
        if (_nNullable == 1) {
            return this.nNullableInfos[i];
        }
        return _nNullable;
    }

    public int isNullable(XPropertySet _xColPropertySet) {
        int i = this.getDataTypeIndex(_xColPropertySet, false);
        if (i > -1) {
            return this.nNullableInfos[i];
        }
        return 0;
    }

    private int getDataTypeIndex(XPropertySet _xColPropertySet, boolean _bCheckNumericAttributes) {
        try {
            int nPrecision = -1;
            int nScale = -1;
            int nDataType = AnyConverter.toInt((Object)_xColPropertySet.getPropertyValue("Type"));
            String sTypeName = AnyConverter.toString((Object)_xColPropertySet.getPropertyValue("TypeName"));
            if (_bCheckNumericAttributes) {
                nPrecision = AnyConverter.toInt((Object)_xColPropertySet.getPropertyValue("Precision"));
                nScale = AnyConverter.toInt((Object)_xColPropertySet.getPropertyValue("Scale"));
            }
            boolean bleaveloop = false;
            int startindex = 0;
            while (!bleaveloop) {
                int i = JavaTools.FieldInIntTable(this.nDataTypeInfos, nDataType, startindex);
                startindex = i + 1;
                bleaveloop = i < 0;
                if (bleaveloop || !sTypeName.equals(this.sDataTypeNames[i])) continue;
                if (_bCheckNumericAttributes) {
                    if (nPrecision > this.nPrecisionInfos[i] || nScale < this.nMinScaleInfos[i] || nScale > this.nMinScaleInfos[i]) continue;
                    return i;
                }
                return i;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return -1;
    }

    private boolean supportsDataType(int _curDataType) {
        return JavaTools.FieldInIntTable(this.nDataTypeInfos, _curDataType) > -1;
    }

    private int getLastConversionFallbackDataType() {
        if (this.supportsDataType(12)) {
            return 12;
        }
        return -1;
    }

    public String getDefaultTypeName(int _curDataType, Integer precision) {
        String ret = PropertyNames.EMPTY_STRING;
        for (int i = 0; i < this.nDataTypeInfos.length; ++i) {
            if (this.nDataTypeInfos[i] != _curDataType) continue;
            if (precision == null || this.nPrecisionInfos[i] >= precision) {
                ret = this.sDataTypeNames[i];
                break;
            }
            if (ret.length() != 0) continue;
            ret = this.sDataTypeNames[i];
        }
        return ret;
    }

    public int getDataType(String _sTypeName) {
        int i = JavaTools.FieldInList(this.sDataTypeNames, _sTypeName);
        if (i > -1) {
            return this.nDataTypeInfos[i];
        }
        return this.getLastConversionFallbackDataType();
    }

    public int convertDataType(int _curDataType) {
        int retDataType = _curDataType;
        if (!this.supportsDataType(_curDataType)) {
            switch (_curDataType) {
                case -7: {
                    retDataType = this.convertDataType(16);
                    break;
                }
                case 16: {
                    retDataType = this.convertDataType(-7);
                    break;
                }
                case -6: {
                    retDataType = this.convertDataType(5);
                    break;
                }
                case 5: {
                    retDataType = this.convertDataType(4);
                    break;
                }
                case 4: {
                    retDataType = this.convertDataType(6);
                    break;
                }
                case 6: {
                    retDataType = this.convertDataType(7);
                    break;
                }
                case 91: 
                case 92: {
                    retDataType = this.convertDataType(93);
                    break;
                }
                case -5: 
                case 7: 
                case 93: {
                    retDataType = this.convertDataType(8);
                    break;
                }
                case 8: {
                    retDataType = this.convertDataType(2);
                    break;
                }
                case 2: {
                    retDataType = this.convertDataType(3);
                    break;
                }
                case 3: {
                    if (this.supportsDataType(8)) {
                        retDataType = this.convertDataType(8);
                        break;
                    }
                    if (this.supportsDataType(2)) {
                        retDataType = 2;
                        break;
                    }
                    retDataType = this.getLastConversionFallbackDataType();
                    break;
                }
                case 12: {
                    retDataType = this.getLastConversionFallbackDataType();
                    break;
                }
                default: {
                    retDataType = this.getLastConversionFallbackDataType();
                }
            }
        }
        return retDataType;
    }

    public int getAutoIncrementIndex(XPropertySet _xColPropertySet) {
        try {
            boolean bleaveloop = false;
            int startindex = 0;
            int curDataType = (Integer)_xColPropertySet.getPropertyValue("Type");
            while (!bleaveloop) {
                int i = JavaTools.FieldInIntTable(this.nDataTypeInfos, curDataType, startindex);
                startindex = i + 1;
                bleaveloop = i == -1;
                if (bleaveloop || !this.bisAutoIncrementableInfos[i]) continue;
                return this.nDataTypeInfos[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return 999999;
    }

    public boolean isAutoIncrementable(XPropertySet _xColPropertySet) {
        return this.getAutoIncrementIndex(_xColPropertySet) != 999999;
    }

    public boolean isAutoIncrementationSupported() {
        for (int n = 0; n < this.nNumericFallBackList.length; ++n) {
            int nDataType = this.nNumericFallBackList[n];
            boolean bleaveloop = false;
            int startindex = 0;
            while (!bleaveloop) {
                int i = JavaTools.FieldInIntTable(this.nDataTypeInfos, nDataType, startindex);
                boolean bl = bleaveloop = i < 0;
                if (!bleaveloop) {
                    if (this.bisAutoIncrementableInfos[i]) {
                        return true;
                    }
                    startindex = i + 1;
                }
                startindex = i + 1;
            }
        }
        return false;
    }
}

