/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OverpassDownloadReader;
import org.openstreetmap.josm.tools.Logging;

public class MultiFetchOverpassObjectReader
extends MultiFetchServerObjectReader {
    private static final List<OsmPrimitiveType> wantedOrder = Arrays.asList(OsmPrimitiveType.RELATION, OsmPrimitiveType.WAY, OsmPrimitiveType.NODE);

    private static String getPackageString(OsmPrimitiveType type, Set<Long> idPackage) {
        return idPackage.stream().map(String::valueOf).collect(Collectors.joining(",", type.getAPIName() + (idPackage.size() == 1 ? "(" : "(id:"), ")"));
    }

    public static String genOverpassQuery(Collection<? extends PrimitiveId> ids, boolean includeObjects, boolean recurseUp, boolean recurseDownRelations) {
        LinkedHashMap<OsmPrimitiveType, Set<Long>> primitivesMap = new LinkedHashMap<OsmPrimitiveType, Set<Long>>();
        Arrays.asList(OsmPrimitiveType.RELATION, OsmPrimitiveType.WAY, OsmPrimitiveType.NODE).forEach(type -> {
            Set cfr_ignored_0 = primitivesMap.put((OsmPrimitiveType)((Object)((Object)type)), new TreeSet());
        });
        for (PrimitiveId primitiveId : ids) {
            ((Set)primitivesMap.get((Object)primitiveId.getType())).add(primitiveId.getUniqueId());
        }
        return MultiFetchOverpassObjectReader.genOverpassQuery(primitivesMap, includeObjects, recurseUp, recurseDownRelations);
    }

    protected static String genOverpassQuery(Map<OsmPrimitiveType, Set<Long>> primitivesMap, boolean includeObjects, boolean recurseUp, boolean recurseDownRelations) {
        if (!(includeObjects || recurseUp || recurseDownRelations)) {
            throw new IllegalArgumentException("At least one options must be true");
        }
        StringBuilder sb = new StringBuilder(128);
        StringBuilder setsToInclude = new StringBuilder();
        StringBuilder up = new StringBuilder();
        String down = null;
        for (OsmPrimitiveType type : wantedOrder) {
            Set<Long> set = primitivesMap.get((Object)type);
            if (set.isEmpty()) continue;
            sb.append(MultiFetchOverpassObjectReader.getPackageString(type, set));
            if (type == OsmPrimitiveType.NODE) {
                sb.append("->.n;");
                if (includeObjects) {
                    setsToInclude.append(".n;");
                }
                if (!recurseUp) continue;
                up.append(".n;way(bn)->.wn;.n;rel(bn)->.rn;");
                setsToInclude.append(".wn;node(w);.rn;");
                continue;
            }
            if (type == OsmPrimitiveType.WAY) {
                sb.append("->.w;");
                if (includeObjects) {
                    setsToInclude.append(".w;>;");
                }
                if (!recurseUp) continue;
                up.append(".w;rel(bw)->.pw;");
                setsToInclude.append(".pw;");
                continue;
            }
            sb.append("->.r;");
            if (includeObjects) {
                setsToInclude.append(".r;");
            }
            if (recurseUp) {
                up.append(".r;rel(br)->.pr;");
                setsToInclude.append(".pr;");
            }
            if (!recurseDownRelations) continue;
            down = ".r;rel(r)->.rm;";
            setsToInclude.append(".r;>;.rm;");
        }
        if (up.length() > 0) {
            sb.append((CharSequence)up);
        }
        if (down != null) {
            sb.append(down);
        }
        sb.append('(').append((CharSequence)setsToInclude).append(");out meta;");
        String query = sb.toString();
        Logging.debug("{0} {1}", "Generated Overpass query:", query);
        return query;
    }

    @Override
    protected String getBaseUrl() {
        return OverpassDownloadReader.OVERPASS_SERVER.get();
    }
}

