/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.event.ActionEvent;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.util.Collections;
import java.util.function.Supplier;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.imagery.street_level.IImageEntry;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;
import org.openstreetmap.josm.gui.layer.geoimage.RemoteEntry;
import org.openstreetmap.josm.gui.layer.markerlayer.ButtonMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ImageMarker
extends ButtonMarker {
    public URL imageUrl;

    public ImageMarker(LatLon ll, URL imageUrl, MarkerLayer parentLayer, double time, double offset) {
        super(ll, "photo", parentLayer, time, offset);
        this.imageUrl = imageUrl;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.parentLayer.setCurrentMarker(this);
        ImageViewerDialog.getInstance().displayImages(Collections.singletonList(this.getRemoteEntry()));
    }

    RemoteEntry getRemoteEntry() {
        try {
            MarkerRemoteEntry remoteEntry = new MarkerRemoteEntry(this.imageUrl.toURI(), this.getFirstImage(), this.getPreviousImage(), this.getNextImage(), this.getLastImage());
            remoteEntry.extractExif();
            if (Double.isFinite(this.time)) {
                remoteEntry.setGpsTime(Instant.ofEpochMilli((long)(this.time * 1000.0)));
            }
            if (this.isLatLonKnown()) {
                remoteEntry.setPos(this);
            }
            if (!Utils.isBlank(this.getText())) {
                remoteEntry.setDisplayName(this.getText());
            }
            return remoteEntry;
        }
        catch (URISyntaxException e) {
            Logging.trace(e);
            new Notification(I18n.tr("Malformed URI: {0}", this.imageUrl.toExternalForm())).setIcon(2).show();
        }
        catch (UncheckedIOException e) {
            Logging.trace(e);
            new Notification(I18n.tr("IO Exception: {0}\n{1}", this.imageUrl.toExternalForm(), e.getCause().getMessage())).setIcon(2).show();
        }
        return null;
    }

    private Supplier<RemoteEntry> getFirstImage() {
        for (Marker marker : this.parentLayer.data) {
            if (!(marker instanceof ImageMarker)) continue;
            if (marker == this) break;
            ImageMarker imageMarker = (ImageMarker)marker;
            return imageMarker::getRemoteEntry;
        }
        return () -> null;
    }

    private Supplier<RemoteEntry> getPreviousImage() {
        int index = this.parentLayer.data.indexOf(this);
        for (int i = index - 1; i >= 0; --i) {
            Marker marker = this.parentLayer.data.get(i);
            if (!(marker instanceof ImageMarker)) continue;
            ImageMarker imageMarker = (ImageMarker)marker;
            return imageMarker::getRemoteEntry;
        }
        return () -> null;
    }

    private Supplier<RemoteEntry> getNextImage() {
        int index = this.parentLayer.data.indexOf(this);
        for (int i = index + 1; i < this.parentLayer.data.size(); ++i) {
            Marker marker = this.parentLayer.data.get(i);
            if (!(marker instanceof ImageMarker)) continue;
            ImageMarker imageMarker = (ImageMarker)marker;
            return imageMarker::getRemoteEntry;
        }
        return () -> null;
    }

    private Supplier<RemoteEntry> getLastImage() {
        int index = Math.max(0, this.parentLayer.data.indexOf(this));
        for (int i = this.parentLayer.data.size() - 1; i >= index; --i) {
            Marker marker = this.parentLayer.data.get(i);
            if (!(marker instanceof ImageMarker)) continue;
            if (marker == this) break;
            ImageMarker imageMarker = (ImageMarker)marker;
            return imageMarker::getRemoteEntry;
        }
        return () -> null;
    }

    @Override
    public WayPoint convertToWayPoint() {
        WayPoint wpt = super.convertToWayPoint();
        GpxLink link = new GpxLink(this.imageUrl.toString());
        link.type = "image";
        wpt.put("meta.links", Collections.singleton(link));
        return wpt;
    }

    private class MarkerRemoteEntry
    extends RemoteEntry {
        MarkerRemoteEntry(URI uri, Supplier<RemoteEntry> firstImage, Supplier<RemoteEntry> previousImage, Supplier<RemoteEntry> nextImage, Supplier<RemoteEntry> lastImage) {
            super(uri, firstImage, previousImage, nextImage, lastImage);
        }

        @Override
        public void selectImage(ImageViewerDialog imageViewerDialog, IImageEntry<?> entry) {
            ImageMarker.this.parentLayer.setCurrentMarker(ImageMarker.this);
            super.selectImage(imageViewerDialog, entry);
        }
    }
}

