/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.PolarCoor;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.validation.tests.CrossingWays;
import org.openstreetmap.josm.data.validation.tests.SelfIntersectingWay;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public final class AlignInCircleAction
extends JosmAction {
    public AlignInCircleAction() {
        super(I18n.tr("Align Nodes in Circle", new Object[0]), "aligncircle", I18n.tr("Move the selected nodes into a circle.", new Object[0]), Shortcut.registerShortcut("tools:aligncircle", I18n.tr("Tools: {0}", I18n.tr("Align Nodes in Circle", new Object[0])), 79, 5003), true);
        this.setHelpId(HelpUtil.ht("/Action/AlignInCircle"));
    }

    public static void addMoveCommandIfNeeded(Node n, PolarCoor coor, List<Command> cmds) {
        EastNorth en = coor.toEastNorth();
        double deltaEast = en.east() - n.getEastNorth().east();
        double deltaNorth = en.north() - n.getEastNorth().north();
        if (Math.abs(deltaEast) > 5.0E-6 || Math.abs(deltaNorth) > 5.0E-6) {
            cmds.add(new MoveCommand((OsmPrimitive)n, deltaEast, deltaNorth));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            Command cmd = AlignInCircleAction.buildCommand(this.getLayerManager().getEditDataSet());
            if (cmd != null) {
                UndoRedoHandler.getInstance().add(cmd);
            } else {
                new Notification(I18n.tr("Nothing changed", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            }
        }
        catch (InvalidSelection except) {
            Logging.debug(except);
            new Notification(except.getMessage()).setIcon(1).setDuration(Notification.TIME_SHORT).show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Command buildCommand(DataSet ds) throws InvalidSelection {
        List<Node> nodes;
        Collection sel = ds.getSelected();
        LinkedList<Node> selectedNodes = new LinkedList<Node>();
        HashSet<Node> fixNodes = new HashSet<Node>();
        LinkedList<Way> ways = new LinkedList<Way>();
        EastNorth center = null;
        double radius = 0.0;
        for (OsmPrimitive osm : sel) {
            if (osm instanceof Node) {
                selectedNodes.add((Node)osm);
                continue;
            }
            if (!(osm instanceof Way)) continue;
            ways.add((Way)osm);
        }
        ArrayList<Node> onWay = new ArrayList<Node>();
        if (!ways.isEmpty()) {
            ArrayList<Node> potentialCenter = new ArrayList<Node>();
            for (Node n : selectedNodes) {
                if (ways.stream().anyMatch(w -> w.containsNode(n))) {
                    onWay.add(n);
                    continue;
                }
                potentialCenter.add(n);
            }
            if (potentialCenter.size() == 1) {
                center = ((Node)potentialCenter.get(0)).getEastNorth();
                if (onWay.size() == 1) {
                    radius = center.distance(((Node)onWay.get(0)).getEastNorth());
                }
            } else if (potentialCenter.size() > 1) {
                throw new InvalidSelection(I18n.tr("Please select only one node as center.", new Object[0]));
            }
        }
        if (ways.isEmpty()) {
            nodes = AlignInCircleAction.sortByAngle(selectedNodes);
            fixNodes.addAll(nodes);
        } else if (ways.size() == 1 && !((Way)ways.get(0)).isClosed()) {
            Way w2 = (Way)ways.get(0);
            fixNodes.add(w2.firstNode());
            fixNodes.add(w2.lastNode());
            fixNodes.addAll(onWay);
            Way closedWay = new Way(w2);
            try {
                closedWay.addNode(w2.firstNode());
                nodes = AlignInCircleAction.collectNodesAnticlockwise(Collections.singletonList(closedWay));
            }
            finally {
                closedWay.setNodes((List<Node>)null);
            }
        } else if (Multipolygon.joinWays(ways).size() == 1) {
            if (onWay.size() == 2) {
                EastNorth en0 = ((Node)onWay.get(0)).getEastNorth();
                EastNorth en1 = ((Node)onWay.get(1)).getEastNorth();
                radius = en0.distance(en1) / 2.0;
                if (center == null) {
                    center = en0.getCenter(en1);
                }
            }
            fixNodes.addAll(onWay);
            nodes = AlignInCircleAction.collectNodesAnticlockwise(ways);
        } else {
            if (!ways.isEmpty() && selectedNodes.isEmpty()) {
                LinkedList<Command> rcmds = new LinkedList<Command>();
                for (Way w3 : ways) {
                    Command c;
                    if (w3.isDeleted() || !w3.isArea()) continue;
                    List<Node> wnodes = w3.getNodes();
                    wnodes.remove(wnodes.size() - 1);
                    if (AlignInCircleAction.validateGeometry(wnodes)) {
                        center = Geometry.getCenter(wnodes);
                    }
                    if (center == null) continue;
                    boolean skipThisWay = false;
                    radius = 0.0;
                    for (Node n : wnodes) {
                        if (!n.isLatLonKnown()) {
                            skipThisWay = true;
                            break;
                        }
                        radius += center.distance(n.getEastNorth());
                    }
                    if (skipThisWay || (c = AlignInCircleAction.moveNodesCommand(wnodes, Collections.emptySet(), center, radius /= (double)wnodes.size())) == null) continue;
                    rcmds.add(c);
                }
                if (rcmds.isEmpty()) {
                    throw new InvalidSelection();
                }
                return new SequenceCommand(I18n.tr("Align each Way in Circle", new Object[0]), rcmds);
            }
            throw new InvalidSelection();
        }
        fixNodes.addAll(AlignInCircleAction.collectNodesWithExternReferrers(ways));
        if (nodes.stream().anyMatch(Node::isOutsideDownloadArea)) {
            throw new InvalidSelection(I18n.tr("One or more nodes involved in this action is outside of the downloaded area.", new Object[0]));
        }
        if (center == null) {
            if (nodes.size() < 4) {
                throw new InvalidSelection(I18n.tr("Not enough nodes to calculate center.", new Object[0]));
            }
            if (AlignInCircleAction.validateGeometry(nodes)) {
                center = Geometry.getCenter(nodes);
            }
            if (center == null) {
                throw new InvalidSelection(I18n.tr("Cannot determine center of circle for this geometry.", new Object[0]));
            }
        }
        if (radius == 0.0) {
            for (Node n : nodes) {
                radius += center.distance(n.getEastNorth());
            }
            radius /= (double)nodes.size();
        }
        return AlignInCircleAction.moveNodesCommand(nodes, fixNodes, center, radius);
    }

    public static Command moveNodesCommand(List<Node> nodes, Set<Node> fixNodes, EastNorth center, double radius) {
        int startPosition;
        LinkedList<Command> cmds = new LinkedList<Command>();
        int nodeCount = nodes.size();
        for (startPosition = 0; startPosition < nodeCount && !fixNodes.contains(nodes.get(startPosition % nodeCount)); ++startPosition) {
        }
        int i = startPosition;
        while (i < startPosition + nodeCount) {
            int j;
            for (j = i + 1; j < startPosition + nodeCount && !fixNodes.contains(nodes.get(j % nodeCount)); ++j) {
            }
            Node first = nodes.get(i % nodeCount);
            PolarCoor pcFirst = new PolarCoor(radius, PolarCoor.computeAngle(first.getEastNorth(), center), center);
            AlignInCircleAction.addMoveCommandIfNeeded(first, pcFirst, cmds);
            if (j > i + 1) {
                double delta;
                if (j == i + nodeCount) {
                    delta = Math.PI * 2 / (double)nodeCount;
                } else {
                    PolarCoor pcLast = new PolarCoor(nodes.get(j % nodeCount).getEastNorth(), center);
                    delta = pcLast.angle - pcFirst.angle;
                    if (delta < 0.0) {
                        delta += Math.PI * 2;
                    }
                    delta /= (double)(j - i);
                }
                for (int k = i + 1; k < j; ++k) {
                    PolarCoor p = new PolarCoor(radius, pcFirst.angle + (double)(k - i) * delta, center);
                    AlignInCircleAction.addMoveCommandIfNeeded(nodes.get(k % nodeCount), p, cmds);
                }
            }
            i = j;
        }
        if (cmds.isEmpty()) {
            return null;
        }
        return new SequenceCommand(I18n.tr("Align Nodes in Circle", new Object[0]), cmds);
    }

    private static List<Node> sortByAngle(List<Node> nodes) {
        EastNorth sum = new EastNorth(0.0, 0.0);
        for (Node n : nodes) {
            EastNorth en = n.getEastNorth();
            sum = sum.add(en.east(), en.north());
        }
        EastNorth simpleCenter = new EastNorth(sum.east() / (double)nodes.size(), sum.north() / (double)nodes.size());
        TreeMap<Double, List> orderedMap = new TreeMap<Double, List>();
        for (Node n : nodes) {
            double angle = new PolarCoor((EastNorth)n.getEastNorth(), (EastNorth)simpleCenter).angle;
            orderedMap.computeIfAbsent(angle, k -> new ArrayList()).add(n);
        }
        return orderedMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static boolean validateGeometry(List<Node> nodes) {
        Way test = new Way();
        test.setNodes(nodes);
        if (!test.isClosed()) {
            test.addNode(test.firstNode());
        }
        try {
            if (CrossingWays.isSelfCrossing(test)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = !SelfIntersectingWay.isSelfIntersecting(test);
            return bl;
        }
        finally {
            test.setNodes((List<Node>)null);
        }
    }

    private static List<Node> collectNodesWithExternReferrers(List<Way> ways) {
        return ways.stream().flatMap(w -> w.getNodes().stream()).filter(n -> n.getReferrers().size() > 1).collect(Collectors.toList());
    }

    private static List<Node> collectNodesAnticlockwise(List<Way> ways) throws InvalidSelection {
        Collection<Multipolygon.JoinedWay> rings = Multipolygon.joinWays(ways);
        if (rings.size() != 1) {
            throw new InvalidSelection();
        }
        ArrayList<Node> nodes = new ArrayList<Node>(rings.iterator().next().getNodes());
        if (nodes.get(0) != nodes.get(nodes.size() - 1)) {
            throw new InvalidSelection();
        }
        if (Geometry.isClockwise(nodes)) {
            Collections.reverse(nodes);
        }
        nodes.remove(nodes.size() - 1);
        return nodes;
    }

    @Override
    protected void updateEnabledState() {
        DataSet ds = this.getLayerManager().getEditDataSet();
        this.setEnabled(ds != null && !ds.selectionEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }

    public static class InvalidSelection
    extends Exception {
        InvalidSelection() {
            super(I18n.tr("Selection could not be used to align in circle.", new Object[0]));
        }

        InvalidSelection(String msg) {
            super(msg);
        }
    }
}

