/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.M3;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.api.JmolModulationSet;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.MeasurementPending;
import org.jmol.render.LabelsRenderer;
import org.jmol.shape.Measures;
import org.jmol.util.Point3fi;
import org.jmol.util.Vibration;

public class MeasuresRenderer
extends LabelsRenderer {
    private boolean doJustify;
    private boolean modulating;
    private short mad0;
    private Map<Integer, Point3fi> mpts;
    private Measurement m;
    private Point3fi[] p;
    private int count;
    private A4 aaT;
    private M3 matrixT;

    @Override
    protected void initRenderer() {
        this.mpts = new Hashtable<Integer, Point3fi>();
        this.p = new Point3fi[4];
    }

    @Override
    protected boolean render() {
        if (!this.g3d.checkTranslucent(false)) {
            return false;
        }
        if (this.atomPt == null) {
            this.atomPt = new Point3fi();
        }
        Measures measures = (Measures)this.shape;
        if (measures.ms != this.ms) {
            System.out.println("!measure wrong modelset!");
            measures.clear();
            return false;
        }
        this.doJustify = this.vwr.getBoolean(603979870);
        this.modulating = this.ms.bsModulated != null;
        this.imageFontScaling = this.vwr.imageFontScaling;
        this.mad0 = measures.mad;
        this.font3d = this.vwr.gdata.getFont3DScaled(measures.font3d, this.imageFontScaling);
        this.m = measures.mPending;
        if (!this.isExport && this.m != null && (this.count = this.m.count) != 0) {
            this.renderPendingMeasurement();
        }
        if (!this.vwr.getBoolean(603979926)) {
            return false;
        }
        boolean showMeasurementLabels = this.vwr.getBoolean(603979878);
        measures.setVisibilityInfo();
        int i = measures.measurementCount;
        while (--i >= 0) {
            this.m = (Measurement)measures.measurements.get(i);
            if (!this.m.isVisible || !this.m.isValid || (this.count = this.m.count) == 1 && this.m.traceX == Integer.MIN_VALUE) continue;
            this.getPoints();
            this.colix = this.m.colix;
            if (this.colix == 0) {
                this.colix = measures.colix;
            }
            if (this.colix == 0) {
                this.colix = this.vwr.cm.colixBackgroundContrast;
            }
            this.labelColix = this.m.labelColix;
            if (this.labelColix == 0) {
                this.labelColix = this.vwr.cm.colixBackgroundContrast;
            } else if (this.labelColix == -1) {
                this.labelColix = this.colix;
            }
            this.g3d.setC(this.colix);
            this.colixA = this.colixB = this.colix;
            this.mode = this.g3d.isAntialiased() ? 4 : 0;
            this.renderMeasurement(showMeasurementLabels);
        }
        return false;
    }

    private void getPoints() {
        int j = this.count;
        while (--j >= 0) {
            Point3fi pt;
            int i = this.m.getAtomIndex(j + 1);
            Point3fi point3fi = pt = i >= 0 && this.modulating ? this.getModAtom(i) : this.m.getAtom(j + 1);
            if (pt.sD < 0) {
                this.tm.transformPtScr(pt, this.pt0i);
                pt.sX = this.pt0i.x;
                pt.sY = this.pt0i.y;
                pt.sZ = this.pt0i.z;
            }
            this.p[j] = pt;
        }
        if (this.modulating) {
            this.m.refresh(this.p);
        }
    }

    private Point3fi getModAtom(int i) {
        JmolModulationSet v;
        Integer ii = i;
        Point3fi pt = this.mpts.get(ii);
        if (pt != null) {
            ii = null;
        }
        if ((v = this.ms.getModulation(i)) == null) {
            pt = this.ms.at[i];
        } else {
            if (pt == null) {
                pt = new Point3fi();
            }
            pt.setT(this.ms.at[i]);
            if (this.vwr.tm.vibrationOn) {
                this.vwr.tm.getVibrationPoint((Vibration)((Object)v), pt, Float.NaN);
            }
            pt.sD = (short)-1;
        }
        if (ii != null) {
            this.mpts.put(ii, pt);
        }
        return pt;
    }

    private void renderMeasurement(boolean renderLabel) {
        String s;
        String string = s = renderLabel ? this.m.getString() : null;
        if (s != null) {
            if (s.length() == 0) {
                s = null;
            } else if (this.m.text != null) {
                this.m.text.setText(s);
                this.m.text.colix = this.labelColix;
                this.m.text.setFontScale(this.imageFontScaling);
            }
        }
        if (this.m.mad == 0) {
            this.dotsOrDashes = false;
            this.mad = this.mad0;
        } else {
            this.mad = (short)this.m.mad;
            this.dotsOrDashes = true;
            this.dashDots = this.mad < 0 ? null : ndots;
        }
        switch (this.count) {
            case 1: {
                this.drawLine(this.p[0].sX, this.p[0].sY, this.p[0].sZ, this.m.traceX, this.m.traceY, this.p[0].sZ, this.mad);
                break;
            }
            case 2: {
                this.renderDistance(s, this.p[0], this.p[1]);
                break;
            }
            case 3: {
                this.renderAngle(s, this.p[0], this.p[1], this.p[2]);
                break;
            }
            case 4: {
                this.renderTorsion(s, this.p[0], this.p[1], this.p[2], this.p[3]);
            }
        }
        this.p[3] = null;
        this.p[2] = null;
        this.p[1] = null;
        this.p[0] = null;
    }

    void renderDistance(String s, Point3fi a, Point3fi b) {
        int zLabel;
        this.tickInfo = this.m.tickInfo;
        if (this.tickInfo != null) {
            this.drawLine(a.sX, a.sY, a.sZ, b.sX, b.sY, b.sZ, this.mad);
            this.tickA = a;
            this.tickB = b;
            if (this.tickAs == null) {
                this.tickAs = new P3();
                this.tickBs = new P3();
            }
            this.tickAs.set(a.sX, a.sY, a.sZ);
            this.tickBs.set(b.sX, b.sY, b.sZ);
            this.drawTicks(this.mad, s != null);
            return;
        }
        int zA = a.sZ - a.sD - 10;
        int zB = b.sZ - b.sD - 10;
        int radius = this.drawLine(a.sX, a.sY, zA, b.sX, b.sY, zB, this.mad);
        if (s == null) {
            return;
        }
        if (this.mad > 0) {
            radius <<= 1;
        }
        int n = zLabel = this.m.inFront ? Math.min(zA, zB) - 10 : (zA + zB) / 2;
        if (zLabel < 1) {
            zLabel = 1;
        }
        int x = (a.sX + b.sX) / 2;
        int y = (a.sY + b.sY) / 2;
        if (this.m.text == null) {
            this.g3d.setC(this.labelColix);
            this.drawString(x, y, zLabel, radius, this.doJustify && (x - a.sX) * (y - a.sY) > 0, false, true, this.doJustify ? 0 : Integer.MAX_VALUE, s);
        } else {
            this.atomPt.ave(a, b);
            this.atomPt.sX = (a.sX + b.sX) / 2;
            this.atomPt.sY = (a.sY + b.sY) / 2;
            this.renderLabelOrMeasure(this.m.text, s);
        }
    }

    private void renderAngle(String s, Point3fi a, Point3fi b, Point3fi c) {
        int zOffset = b.sD + 10;
        int zA = a.sZ - a.sD - 10;
        int zB = b.sZ - zOffset;
        int zC = c.sZ - c.sD - 10;
        int radius = this.drawLine(a.sX, a.sY, zA, b.sX, b.sY, zB, this.mad);
        radius += this.drawLine(b.sX, b.sY, zB, c.sX, c.sY, zC, this.mad);
        if (s == null) {
            return;
        }
        radius = (radius + 1) / 2;
        if (this.m.value > 175.0f) {
            if (this.m.text == null) {
                int offset = (int)Math.floor(5.0f * this.imageFontScaling);
                this.g3d.setC(this.labelColix);
                this.drawString(b.sX + offset, b.sY - offset, zB, radius, false, false, false, this.doJustify ? 0 : Integer.MAX_VALUE, s);
            } else {
                this.atomPt.setT(b);
                this.renderLabelOrMeasure(this.m.text, s);
            }
            return;
        }
        if (this.m.isTainted()) {
            float radians = Measure.computeAngle(this.p[0], this.p[1], this.p[2], this.vectorT2, this.vectorT3, false);
            this.vectorT.cross(this.vectorT2, this.vectorT3);
            this.m.renderAxis = A4.new4(this.vectorT.x, this.vectorT.y, this.vectorT.z, radians);
            this.vectorT2.normalize();
            this.vectorT2.scale(0.5f);
            this.m.renderArc = P3.newP(this.vectorT2);
        }
        if (this.aaT == null) {
            this.aaT = new A4();
            this.matrixT = new M3();
        }
        int dotCount = (int)Math.floor((double)this.m.renderAxis.angle / (Math.PI * 2) * 64.0);
        float stepAngle = this.m.renderAxis.angle / (float)dotCount;
        this.aaT.setAA(this.m.renderAxis);
        int iMid = dotCount / 2;
        int i = dotCount;
        while (--i >= 0) {
            int zLabel;
            this.aaT.angle = (float)i * stepAngle;
            this.pointT.setT(this.m.renderArc);
            this.matrixT.setAA(this.aaT).rotate(this.pointT);
            this.pointT.add(b);
            P3i p3i = this.tm.transformPt(this.pointT);
            int zArc = p3i.z - zOffset;
            if (zArc < 0) {
                zArc = 0;
            }
            this.g3d.drawPixel(p3i.x, p3i.y, zArc);
            if (i != iMid) continue;
            this.pointT.setT(this.m.renderArc);
            this.pointT.scale(1.1f);
            this.matrixT.rotate(this.pointT);
            this.pointT.add(b);
            this.tm.transformPt(this.pointT);
            int n = zLabel = this.m.inFront ? Math.min(Math.min(zA, zB), zC) : p3i.z - zOffset;
            if (zLabel < 1) {
                zLabel = 1;
            }
            if (this.m.text == null) {
                this.g3d.setC(this.labelColix);
                this.drawString(p3i.x, p3i.y, zLabel, radius, p3i.x < b.sX, false, false, this.doJustify ? b.sY : Integer.MAX_VALUE, s);
                continue;
            }
            this.atomPt.setT(this.pointT);
            this.renderLabelOrMeasure(this.m.text, s);
        }
    }

    private void renderTorsion(String s, Point3fi a, Point3fi b, Point3fi c, Point3fi d) {
        int zLabel;
        int zA = a.sZ - a.sD - 10;
        int zB = b.sZ - b.sD - 10;
        int zC = c.sZ - c.sD - 10;
        int zD = d.sZ - d.sD - 10;
        int radius = this.drawLine(a.sX, a.sY, zA, b.sX, b.sY, zB, this.mad);
        radius += this.drawLine(b.sX, b.sY, zB, c.sX, c.sY, zC, this.mad);
        radius += this.drawLine(c.sX, c.sY, zC, d.sX, d.sY, zD, this.mad);
        if (s == null) {
            return;
        }
        int n = zLabel = this.m.inFront ? Math.min(Math.min(Math.min(zA, zB), zC), zD) : (zA + zB + zC + zD) / 4;
        if (zLabel < 1) {
            zLabel = 1;
        }
        radius /= 3;
        if (this.m.text == null) {
            this.g3d.setC(this.labelColix);
            this.drawString((a.sX + b.sX + c.sX + d.sX) / 4, (a.sY + b.sY + c.sY + d.sY) / 4, zLabel, radius, false, false, false, this.doJustify ? 0 : Integer.MAX_VALUE, s);
        } else {
            this.atomPt.add2(a, b);
            this.atomPt.add(c);
            this.atomPt.add(d);
            this.atomPt.scale(0.25f);
            this.renderLabelOrMeasure(this.m.text, s);
        }
    }

    private void renderPendingMeasurement() {
        boolean renderLabel;
        try {
            this.getPoints();
        }
        catch (Exception e) {
            ((Measures)this.shape).mPending = null;
            return;
        }
        boolean bl = renderLabel = this.m.traceX == Integer.MIN_VALUE;
        short s = renderLabel ? this.vwr.cm.colixRubberband : (this.count == 2 ? (short)20 : 23);
        this.labelColix = s;
        this.g3d.setC(s);
        if (((MeasurementPending)this.m).haveTarget) {
            this.renderMeasurement(renderLabel);
            return;
        }
        Point3fi atomLast = this.p[this.count - 1];
        if (this.count > 1) {
            this.renderMeasurement(false);
        }
        int lastZ = atomLast.sZ - atomLast.sD - 10;
        int x = this.vwr.getCursorX();
        int y = this.vwr.getCursorY();
        if (this.g3d.isAntialiased()) {
            x <<= 1;
            y <<= 1;
        }
        this.drawLine(atomLast.sX, atomLast.sY, lastZ, x, y, lastZ, this.mad);
    }

    @Override
    protected int drawLine(int x1, int y1, int z1, int x2, int y2, int z2, int mad) {
        int diameter = (int)(mad >= 20 && this.exportType != 1 ? this.vwr.tm.scaleToScreen((z1 + z2) / 2, mad) : (float)mad);
        if (this.dotsOrDashes && (this.dashDots == null || this.dashDots == ndots)) {
            this.width = diameter;
        }
        return this.drawLine2(this.g3d, x1, y1, z1, x2, y2, z2, diameter);
    }
}

