/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javajs.util.Lst;
import javajs.util.PT;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jspecview.api.JSVPanel;
import jspecview.api.ScriptInterface;
import jspecview.application.DisplaySchemesProcessor;
import jspecview.application.MainFrame;
import jspecview.common.ColorParameters;
import jspecview.common.JSVFileManager;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.Parameters;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.java.AwtFileHelper;
import jspecview.java.AwtMainPanel;
import jspecview.java.AwtPanel;
import jspecview.source.JDXSource;
import org.jmol.api.JSVInterface;
import org.jmol.api.JmolSyncInterface;
import org.jmol.util.Logger;

public class JSpecView
implements JSVInterface,
ScriptInterface {
    private MainFrame mainFrame;
    JSViewer vwr = new JSViewer(this, false, false);
    public String defaultDisplaySchemeName;
    private DisplaySchemesProcessor dsp;
    public JmolSyncInterface jmol;
    private JSVPanel prevPanel;
    private static String propertiesFileName = "jspecview.properties";

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public JSpecView(boolean bl, JSVInterface jSVInterface) {
        JSVFileManager.setDocumentBase(this.vwr, null);
        this.vwr.mainPanel = new AwtMainPanel(new BorderLayout());
        if (bl) {
            this.mainFrame = new MainFrame(this, null, jSVInterface == null ? this : jSVInterface);
        } else {
            this.initHeadless();
        }
    }

    private void initHeadless() {
        this.dsp = this.getDisplaySchemesProcessor(this);
        this.setApplicationProperties(true);
        JSVFileManager.setDocumentBase(this.vwr, null);
    }

    public static void main(String[] stringArray) {
        boolean bl;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.info("JSpecView Application " + JSVersion.VERSION);
        boolean bl2 = bl = GraphicsEnvironment.isHeadless();
        int n = stringArray.length;
        if (n > 0 && stringArray[n - 1].equalsIgnoreCase("-exit")) {
            bl2 = true;
            --n;
        }
        if (n > 0 && stringArray[n - 1].equalsIgnoreCase("-nodisplay")) {
            bl2 = true;
            bl = true;
            --n;
        }
        if (bl2) {
            System.out.println("JSpecview running headless");
        }
        if (bl) {
            System.out.println("JSpecview has no display");
        }
        JSpecView jSpecView = new JSpecView(!bl, null);
        if (n >= 2) {
            if (n == 2 && stringArray[0].equalsIgnoreCase("-script")) {
                String string = stringArray[1];
                System.out.println("JSpecView is running script " + string);
                jSpecView.vwr.runScriptNow(stringArray[1]);
            } else {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    System.out.println("JSpecView is attempting to open " + stringArray[n2]);
                    jSpecView.vwr.openFile(stringArray[n2], false);
                    ++n2;
                }
            }
        }
        if (bl || bl2) {
            JSpecView.exitNow();
        }
        jSpecView.mainFrame.setVisible(true);
    }

    @Override
    public void runScript(String string) {
        this.vwr.runScriptNow(string);
    }

    @Override
    public void setProperties(Properties properties) {
        try {
            FileInputStream fileInputStream = new FileInputStream(propertiesFileName);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void saveProperties(Properties properties) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(propertiesFileName);
            properties.store(fileOutputStream, "JSpecView Application Properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void exitJSpecView(boolean bl, Object object) {
        if (!bl) {
            JSpecView.exitNow();
        }
        if (bl && JOptionPane.showConfirmDialog((Component)object, "Exit JSpecView?", "Exit", 0, 3) != 0) {
            return;
        }
        JSpecView.exitNow();
    }

    private static void exitNow() {
        System.out.println("JSpecView exit");
        System.exit(0);
    }

    @Override
    public void siOpenDataOrFile(Object object, String string, Lst<Spectrum> lst, String string2, int n, int n2, boolean bl, String string3, String string4) {
        boolean bl2 = this.vwr.currentSource == null;
        switch (string == null && string2 == null ? -3 : this.vwr.openDataOrFile(object, string, lst, string2, n, n2, bl, string4)) {
            case 0: {
                if (string3 == null && bl2 && this.vwr.currentSource.isCompoundSource && this.vwr.pd().getSpectrum().isGC()) {
                    string3 = "VIEW ALL;PEAK GC/MS ID=#1";
                }
                if (string3 == null) break;
                this.runScript(string3);
                break;
            }
            case -3: {
                if (this.mainFrame == null) break;
                this.mainFrame.awaken(false);
                this.mainFrame.awaken(true);
                JOptionPane.showMessageDialog(this.mainFrame, "There was an error reading " + (string != null ? string : string2));
            }
        }
        this.siValidateAndRepaint(false);
    }

    @Override
    public void siSetCurrentSource(JDXSource jDXSource) {
        this.vwr.currentSource = jDXSource;
        if (jDXSource != null && this.mainFrame != null) {
            this.mainFrame.appMenu.setCloseMenuItem(JSVFileManager.getTagName(jDXSource.getFilePath()));
        }
        boolean bl = jDXSource != null && jDXSource.getErrorLog().length() > 0;
        this.setError(bl, bl && jDXSource.getErrorLog().indexOf("Warning") >= 0);
    }

    private void setError(boolean bl, boolean bl2) {
        if (this.mainFrame != null) {
            this.mainFrame.setError(bl, bl2);
        }
    }

    @Override
    public void siSetPropertiesFromPreferences(JSVPanel jSVPanel, boolean bl) {
        ColorParameters colorParameters = this.dsp.getDisplaySchemes().get(this.defaultDisplaySchemeName);
        jSVPanel.getPanelData().addListener(this.mainFrame);
        this.vwr.parameters.setFor(jSVPanel, colorParameters == null ? this.dsp.getDefaultScheme() : colorParameters, bl);
        this.vwr.checkAutoIntegrate();
        jSVPanel.doRepaint(true);
    }

    @Override
    public void siProcessCommand(String string) {
        this.runScriptNow(string);
    }

    @Override
    public void siSetSelectedPanel(JSVPanel jSVPanel) {
        if (this.mainFrame != null) {
            this.mainFrame.setSelectedPanel(jSVPanel);
        } else {
            this.vwr.mainPanel.setSelectedPanel(this.vwr, jSVPanel, this.vwr.panelNodes);
            this.vwr.selectedPanel = jSVPanel;
            this.vwr.spectraTree.setSelectedPanel(this, jSVPanel);
            if (jSVPanel != null) {
                jSVPanel.setEnabled(true);
                jSVPanel.setFocusable(true);
            }
        }
    }

    @Override
    public void siSendPanelChange() {
        if (this.vwr.selectedPanel == this.prevPanel) {
            return;
        }
        this.prevPanel = this.vwr.selectedPanel;
        this.vwr.sendPanelChange();
    }

    @Override
    public void siSyncLoad(String string) {
        this.vwr.closeSource(null);
        this.siOpenDataOrFile(null, null, null, string, -1, -1, false, null, null);
        if (this.vwr.currentSource == null) {
            return;
        }
        if (((PanelNode)this.vwr.panelNodes.get(0)).getSpectrum().isAutoOverlayFromJmolClick()) {
            this.vwr.execView("*", false);
        }
    }

    @Override
    public void siValidateAndRepaint(boolean bl) {
        if (this.mainFrame != null) {
            this.mainFrame.validateAndRepaint(bl);
        }
    }

    @Override
    public void siExecHidden(boolean bl) {
        if (this.mainFrame != null) {
            this.mainFrame.execHidden(bl);
        }
    }

    @Override
    public String siLoaded(String string) {
        PanelData panelData = this.vwr.pd();
        return !panelData.getSpectrum().is1D() && panelData.getDisplay1D() ? "Click on the spectrum and use UP or DOWN keys to see subspectra." : null;
    }

    @Override
    public void siExecScriptComplete(String string, boolean bl) {
        this.vwr.requestRepaint();
        if (string != null) {
            this.writeStatus(string);
            if (string.length() == 0) {
                string = null;
            }
        }
    }

    @Override
    public void siExecSetCallback(ScriptToken scriptToken, String string) {
        if (this.mainFrame != null) {
            this.mainFrame.setCallback(scriptToken, string);
        }
    }

    @Override
    public void siUpdateBoolean(ScriptToken scriptToken, boolean bl) {
        if (this.mainFrame != null) {
            this.mainFrame.updateToolbar(scriptToken, bl);
        }
    }

    @Override
    public void siCheckCallbacks(String string) {
    }

    @Override
    public void siNodeSet(PanelNode panelNode) {
        this.siSetMenuEnables(panelNode, false);
        this.writeStatus("");
    }

    @Override
    public void siSourceClosed(JDXSource jDXSource) {
        this.setError(false, false);
        if (this.mainFrame != null) {
            this.mainFrame.sourceClosed(jDXSource);
        }
    }

    @Override
    public void siSetLoaded(String string, String string2) {
        if (this.mainFrame != null) {
            this.mainFrame.setLoading(string, string2);
        }
    }

    @Override
    public void siUpdateRecentMenus(String string) {
        if (this.mainFrame != null) {
            this.mainFrame.updateRecentMenus(string);
        }
    }

    @Override
    public void siSetMenuEnables(PanelNode panelNode, boolean bl) {
        if (this.mainFrame != null) {
            this.mainFrame.setMenuEnables(panelNode, bl);
        }
    }

    @Override
    public JSVPanel siGetNewJSVPanel(Spectrum spectrum) {
        return spectrum == null ? null : AwtPanel.getPanelOne(this.vwr, spectrum);
    }

    @Override
    public JSVPanel siGetNewJSVPanel2(Lst<Spectrum> lst) {
        return AwtPanel.getPanelMany(this.vwr, lst);
    }

    @Override
    public void siExecTest(String string) {
        System.out.println(PT.toJSON(null, this.vwr.getPropertyAsJavaObject(string)));
    }

    @Override
    public void siNewWindow(boolean bl, boolean bl2) {
    }

    @Override
    public synchronized void syncToJmol(String string) {
        Logger.info("JSV>Jmol " + string);
        if (this.jmol != null) {
            this.jmol.syncScript(string);
            return;
        }
        if (this.mainFrame != null) {
            this.mainFrame.syncToJmol(string);
        }
    }

    @Override
    public void repaint() {
        if (this.mainFrame != null) {
            this.mainFrame.repaint();
        }
    }

    @Override
    public void setCursor(int n) {
        if (this.mainFrame != null) {
            this.mainFrame.setCursor(n);
        }
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean runScriptNow(String string) {
        return this.vwr.runScriptNow(string);
    }

    @Override
    public void writeStatus(String string) {
        if (this.mainFrame != null) {
            this.mainFrame.writeStatus(string);
        }
    }

    public DisplaySchemesProcessor getDisplaySchemesProcessor(JSVInterface jSVInterface) {
        Properties properties = this.vwr.properties = new Properties();
        properties.setProperty("recentFilePaths", "");
        properties.setProperty("confirmBeforeExit", "true");
        properties.setProperty("automaticallyOverlay", "false");
        properties.setProperty("automaticallyShowLegend", "false");
        properties.setProperty("useDirectoryLastOpenedFile", "true");
        properties.setProperty("useDirectoryLastExportedFile", "false");
        properties.setProperty("directoryLastOpenedFile", "");
        properties.setProperty("directoryLastExportedFile", "");
        properties.setProperty("showSidePanel", "true");
        properties.setProperty("showToolBar", "true");
        properties.setProperty("showStatusBar", "true");
        properties.setProperty("defaultDisplaySchemeName", "Default");
        properties.setProperty("showGrid", "false");
        properties.setProperty("showCoordinates", "false");
        properties.setProperty("showXScale", "true");
        properties.setProperty("showYScale", "true");
        properties.setProperty("svgForInkscape", "false");
        properties.setProperty("automaticTAConversion", "false");
        properties.setProperty("AtoTSeparateWindow", "false");
        properties.setProperty("automaticallyIntegrate", "false");
        properties.setProperty("integralMinY", "0.1");
        properties.setProperty("integralFactor", "50");
        properties.setProperty("integralOffset", "30");
        properties.setProperty("integralPlotColor", "#ff0000");
        jSVInterface.setProperties(properties);
        this.dsp = new DisplaySchemesProcessor();
        return this.dsp;
    }

    public void setApplicationProperties(boolean bl) {
        Properties properties = this.vwr.properties;
        this.vwr.interfaceOverlaid = Boolean.parseBoolean(properties.getProperty("automaticallyOverlay"));
        this.vwr.autoShowLegend = Boolean.parseBoolean(properties.getProperty("automaticallyShowLegend"));
        AwtFileHelper awtFileHelper = (AwtFileHelper)this.vwr.fileHelper;
        awtFileHelper.useDirLastOpened = Boolean.parseBoolean(properties.getProperty("useDirectoryLastOpenedFile"));
        awtFileHelper.useDirLastExported = Boolean.parseBoolean(properties.getProperty("useDirectoryLastExportedFile"));
        awtFileHelper.dirLastOpened = properties.getProperty("directoryLastOpenedFile");
        awtFileHelper.dirLastExported = properties.getProperty("directoryLastExportedFile");
        this.defaultDisplaySchemeName = properties.getProperty("defaultDisplaySchemeName");
        if (bl) {
            this.vwr.parameters.setBoolean(ScriptToken.GRIDON, Parameters.isTrue(properties.getProperty("showGrid")));
            this.vwr.parameters.setBoolean(ScriptToken.COORDINATESON, Parameters.isTrue(properties.getProperty("showCoordinates")));
            this.vwr.parameters.setBoolean(ScriptToken.XSCALEON, Parameters.isTrue(properties.getProperty("showXScale")));
            this.vwr.parameters.setBoolean(ScriptToken.YSCALEON, Parameters.isTrue(properties.getProperty("showYScale")));
        }
        this.vwr.setIRmode(properties.getProperty("automaticTAConversion"));
        try {
            this.vwr.autoIntegrate = Boolean.parseBoolean(properties.getProperty("automaticallyIntegrate"));
            this.vwr.parameters.integralMinY = JSpecView.parseDoubleSafely(properties.getProperty("integralMinY"), this.vwr.parameters.integralMinY);
            this.vwr.parameters.integralRange = JSpecView.parseDoubleSafely(properties.getProperty("integralRange"), this.vwr.parameters.integralRange);
            this.vwr.parameters.integralOffset = JSpecView.parseDoubleSafely(properties.getProperty("integralOffset"), this.vwr.parameters.integralOffset);
            this.vwr.parameters.set(null, ScriptToken.INTEGRALPLOTCOLOR, properties.getProperty("integralPlotColor"));
        }
        catch (Exception exception) {
            System.err.println("Bad PropertyValue ");
            exception.printStackTrace();
        }
    }

    private static double parseDoubleSafely(String string, double d) {
        return string == null ? d : Double.parseDouble(string);
    }
}

