
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was HoelConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/Hoel" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include("${CMAKE_CURRENT_LIST_DIR}/HoelTargets.cmake")

set(WITH_SQLITE3    ON)
set(WITH_MARIADB    ON)
set(WITH_PGSQL      ON)

set(CMAKE_CURRENT_LIST_DIR ${_original_cmake_module_path})

if(TARGET Yder::Yder-static)
    set(ORCANIA_INCLUDE_DIRS $<TARGET_PROPERTY:Yder::Yder-static,INTERFACE_INCLUDE_DIRECTORIES>)
    set(ORCANIA_LIBRARIES Yder::Yder-static)
endif()

if(TARGET Yder::Yder)
    set(ORCANIA_INCLUDE_DIRS $<TARGET_PROPERTY:Yder::Yder,INTERFACE_INCLUDE_DIRECTORIES>)
    set(ORCANIA_LIBRARIES Yder::Yder)
endif()

include(CMakeFindDependencyMacro)

set(_original_cmake_module_path ${CMAKE_MODULE_PATH})
list(APPEND CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR}")

find_dependency(Orcania)
find_dependency(Jansson)

if (WITH_SQLITE3)
    find_dependency(SQLite3)
    if(SQLite3_FOUND AND NOT TARGET SQLite::SQLite3)
        add_library(SQLite::SQLite3 UNKNOWN IMPORTED)
        set_target_properties(SQLite::SQLite3 PROPERTIES
            INTERFACE_LINK_LIBRARIES "${SQLite3_LIBRARIES}"
            INTERFACE_INCLUDE_DIRECTORIES "${SQLite3_INCLUDE_DIRS}")
    endif()
endif()

if (WITH_MARIADB)
    find_dependency(MYSQL)
endif()

if (WITH_PGSQL)
    find_dependency(LibPQ)
endif()

set(CMAKE_MODULE_PATH ${_original_cmake_module_path})

set(HOEL_VERSION_STRING "1.4.29")
set(Hoel_FOUND TRUE)
