// Generated by gmmproc 2.76.0 -- DO NOT MODIFY!
#ifndef _GTKMM_SECTIONMODEL_H
#define _GTKMM_SECTIONMODEL_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2023 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/interface.h>
#include <utility> // std::pair


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
typedef struct _GtkSectionModelInterface GtkSectionModelInterface;
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkSectionModel = struct _GtkSectionModel;
using GtkSectionModelClass = struct _GtkSectionModelClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API SectionModel_Class; } // namespace Gtk
#endif // DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{
 /** Interface that adds support for section to list models.
 *
 * This support is then used by widgets using list models to be able to group their
 * items into sections.
 *
 * Many GTK list models support sections inherently, or they pass through the sections
 * of a model they are wrapping.
 *
 * A %Gtk::SectionModel groups successive items into so-called sections. List widgets
 * like Gtk::ListView then allow displaying section headers for these sections.
 *
 * When the section groupings of a model changes, the model will emit
 * signal_sections_changed() by calling the sections_changed() function.
 * All sections in the given range now need to be queried again.  
 * Gio::ListModel::signal_items_changed() has the same effect, all sections in
 * that range are invalidated, too.
 *
 * @see Gio::ListModel, Gtk::ListView
 * @ingroup ListView
 * @newin{4,12}
 */

class GTKMM_API SectionModel : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = SectionModel;
  using CppClassType = SectionModel_Class;
  using BaseObjectType = GtkSectionModel;
  using BaseClassType = GtkSectionModelInterface;

  // noncopyable
  SectionModel(const SectionModel&) = delete;
  SectionModel& operator=(const SectionModel&) = delete;

private:
  friend class SectionModel_Class;
  static CppClassType sectionmodel_class_;

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  SectionModel();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of
   * the Class init() function to ensure that it is properly
   * initialized.
   *
   * @param interface_class The Class object for the derived type.
   */
  explicit SectionModel(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface.
  explicit SectionModel(GtkSectionModel* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  SectionModel(SectionModel&& src) noexcept;
  SectionModel& operator=(SectionModel&& src) noexcept;

  ~SectionModel() noexcept override;

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSectionModel*       gobj()       { return reinterpret_cast<GtkSectionModel*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSectionModel* gobj() const { return reinterpret_cast<GtkSectionModel*>(gobject_); }

private:


public:
  /** Query the section that covers the given position.
   *
   * The number of items in the section can be computed by @a out_end - @a out_start.
   *
   * If the position is larger than the number of items, a single
   * range from n_items to G_MAXUINT will be returned.
   *
   * @newin{4,12}
   *
   * @param position The position of the item to query.
   * @return {out_start, out_end} The position of the first item in the section,
   *         and the position of the first item not part of the section anymore.
   */
  std::pair<guint, guint> get_section(guint position) const;
  

  void sections_changed(guint position, guint n_items);

  // no_default_handler because the wrapped C signal has no default handler.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%sections_changed(guint position, guint n_items)</tt>
   *
   * Flags: Run Last
   *
   * Emitted when the start-of-section state of some of the items in @a model changes.
   * 
   * Note that this signal does not specify the new section state of the
   * items, they need to be queried manually. It is also not necessary for
   * a model to change the section state of any of the items in the section
   * model, though it would be rather useless to emit such a signal.
   * 
   * The Gio::ListModel::signal_items_changed() implies the effect of the
   * signal_sections_changed() signal for all the items
   * it covers.
   * 
   * @newin{4,12}
   * 
   * @param position The first item that may have changed.
   * @param n_items Number of items with changes.
   */

  Glib::SignalProxy<void(guint, guint)> signal_sections_changed();


protected:
 

  /** Return the section that covers the given position.
   * If the position is outside the number of items, returns a single range from
   * n_items to G_MAXUINT.
   */
    virtual void get_section_vfunc(guint position, guint& out_start, guint& out_end);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::SectionModel
   */
  GTKMM_API
  Glib::RefPtr<Gtk::SectionModel> wrap(GtkSectionModel* object, bool take_copy = false);

} // namespace Glib


#endif /* _GTKMM_SECTIONMODEL_H */

