/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util.logging.internal;

import java.io.File;
import java.io.PrintStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.logging.LogHandlers;
import org.freeplane.core.util.logging.internal.LogFileHandler;
import org.freeplane.core.util.logging.internal.LoggingOutputStream;
import org.freeplane.core.util.logging.internal.StdFormatter;

public class LogInitializer {
    private static boolean loggerCreated = false;
    private static final int MAX_LOG_SIZE = 0x100000;

    public static void createLogger() {
        if (loggerCreated) {
            return;
        }
        loggerCreated = true;
        LogInitializer.replaceOutputStream();
        LogInitializer.replaceConsoleHandler();
        LogInitializer.addFileHandler();
    }

    private static void replaceOutputStream() {
        LoggingOutputStream los = new LoggingOutputStream(StdFormatter.STDOUT, System.out, 0x100000);
        System.setOut(new PrintStream(los, true));
        los = new LoggingOutputStream(StdFormatter.STDERR, System.err, 0x100000);
        System.setErr(new PrintStream(los, true));
    }

    private static void addFileHandler() {
        try {
            String logDirectoryPath = LogUtils.getLogDirectory();
            File logDirectory = new File(logDirectoryPath);
            logDirectory.mkdirs();
            if (logDirectory.isDirectory()) {
                String pathPattern = logDirectoryPath + File.separatorChar + "log";
                LogFileHandler fileHandler = new LogFileHandler(pathPattern, 1400000, 5, false);
                fileHandler.setFormatter(new StdFormatter());
                LogHandlers.addHandler(fileHandler);
                if (System.getProperty("java.util.logging.config.file", null) == null) {
                    fileHandler.setLevel(Level.INFO);
                }
            }
        }
        catch (Exception e) {
            LogUtils.warn("Error creating logging File Handler", e);
        }
    }

    private static void replaceConsoleHandler() {
        Handler[] handlers = LogInitializer.getRootLogger().getHandlers();
        boolean consoleHandlerRemoved = false;
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            if (!(handler instanceof ConsoleHandler)) continue;
            LogInitializer.getRootLogger().removeHandler(handler);
            consoleHandlerRemoved = true;
        }
        if (consoleHandlerRemoved) {
            final StreamHandler stdErrConsoleHandler = new StreamHandler(System.err, new StdFormatter()){
                {
                    this.setLevel(Level.SEVERE);
                }

                @Override
                public void publish(LogRecord record) {
                    super.publish(record);
                    this.flush();
                }
            };
            StreamHandler stdOutConsoleHandler = new StreamHandler(System.out, new StdFormatter()){
                {
                    super(arg0, arg1);
                    this.setLevel(Level.ALL);
                }

                @Override
                public boolean isLoggable(LogRecord record) {
                    if (stdErrConsoleHandler.isLoggable(record)) {
                        return false;
                    }
                    return super.isLoggable(record);
                }

                @Override
                public void publish(LogRecord record) {
                    super.publish(record);
                    this.flush();
                }
            };
            LogInitializer.getRootLogger().addHandler(stdErrConsoleHandler);
            LogInitializer.getRootLogger().addHandler(stdOutConsoleHandler);
        }
    }

    private static Logger getRootLogger() {
        return Logger.getAnonymousLogger().getParent();
    }
}

