/**
 * SECTION:dummy-persona
 * @short_description: A persona subclass representing a single contact.
 * 
 * <para>This mocks up a ‘thin’ persona which implements none of the available property interfaces provided by libfolks, and is designed as a base class to be subclassed by personas which will implement one or more of these interfaces. For example, <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> is one such subclass which implements all available interfaces.</para><para>There are two sides to this class’ interface: the normal methods required by <link linkend="FolksPersona"><type>FolksPersona</type></link>, such as <link linkend="folks-persona-linkable-property-to-links"><function>folks_persona_linkable_property_to_links()</function></link>, and the backend methods which should be called by test driver code to simulate changes in the backing store providing this persona, such as <link linkend="folks-dummy-persona-update-writeable-properties"><function>folks_dummy_persona_update_writeable_properties()</function></link>. The <code>update_</code>, <code>register_</code> and <code>unregister_</code> prefixes are commonly used for backend methods.</para><para>All property changes for contact details of subclasses of <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link> have a configurable delay before taking effect, which can be controlled by <link linkend="FolksDummyPersona--property-change-delay"><type>"property-change-delay"</type></link>.</para><para>The API in FolksDummy is unstable and may change wildly. It is designed mostly for use by libfolks unit tests.</para>
 *
 * Since: 0.9.7
 */
/**
 * FOLKS_DUMMY_TYPE_PERSONA:
 * 
 * The type for <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link>.
 */
/**
 * folks_dummy_persona_update_writeable_properties:
 * @self: the <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link> instance
 * @writeable_properties_length1: length of the @writeable_properties array
 * @writeable_properties: &nbsp;
 * 
 * Update the persona’s set of writeable properties.
 * 
 * <para>Update the <link linkend="FolksPersona--writeable-properties"><type>"writeable-properties"</type></link> property to contain the union of <link linkend="FolksPersonaStore--always-writeable-properties"><type>"always-writeable-properties"</type></link> from the persona’s store, and the given <code>writeable_properties</code>.</para><para>This should be used to simulate a change in the backing store for the persona which affects the writeability of one or more of its properties.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_update_linkable_properties:
 * @self: the <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link> instance
 * @linkable_properties: (in) (array length=linkable_properties_length1): &nbsp;.  <para>new set of linkable property names, in lower case, hyphenated form </para>
 * @linkable_properties_length1: length of the @linkable_properties array
 * 
 * Update the persona’s set of linkable properties.
 * 
 * <para>Update the <link linkend="FolksPersona--linkable-properties"><type>"linkable-properties"</type></link> property to contain the given <code>linkable_properties</code>.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_new:
 * @store: (in): &nbsp;.  <para>the store which will contain the persona </para>
 * @contact_id: (in): &nbsp;.  <para>a unique free-form string identifier for the persona </para>
 * @is_user: (in): &nbsp;.  <para><code>true</code> if the persona represents the user, <code>false</code> otherwise </para>
 * @linkable_properties: (in) (array length=linkable_properties_length1): &nbsp;.  <para>an array of names of the properties which should be used for linking this persona to others </para>
 * @linkable_properties_length1: length of the @linkable_properties array
 * 
 * Create a new persona.
 * 
 * <para>Create a new persona for the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> <code>store</code>, with the given construct-only properties.</para><para>The persona’s <link linkend="FolksPersona--writeable-properties"><type>"writeable-properties"</type></link> are initialised to the given <code>store</code>’s <link linkend="FolksPersonaStore--always-writeable-properties"><type>"always-writeable-properties"</type></link>. They may be updated afterwards using <link linkend="folks-dummy-persona-update-writeable-properties"><function>folks_dummy_persona_update_writeable_properties()</function></link>.</para>
 *
 * Since: 0.9.7
 */
/**
 * FolksDummyPersona:
 * 
 * A persona subclass representing a single contact.
 * 
 * <para>This mocks up a ‘thin’ persona which implements none of the available property interfaces provided by libfolks, and is designed as a base class to be subclassed by personas which will implement one or more of these interfaces. For example, <link linkend="FolksDummyFullPersona"><type>FolksDummyFullPersona</type></link> is one such subclass which implements all available interfaces.</para><para>There are two sides to this class’ interface: the normal methods required by <link linkend="FolksPersona"><type>FolksPersona</type></link>, such as <link linkend="folks-persona-linkable-property-to-links"><function>folks_persona_linkable_property_to_links()</function></link>, and the backend methods which should be called by test driver code to simulate changes in the backing store providing this persona, such as <link linkend="folks-dummy-persona-update-writeable-properties"><function>folks_dummy_persona_update_writeable_properties()</function></link>. The <code>update_</code>, <code>register_</code> and <code>unregister_</code> prefixes are commonly used for backend methods.</para><para>All property changes for contact details of subclasses of <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link> have a configurable delay before taking effect, which can be controlled by <link linkend="FolksDummyPersona--property-change-delay"><type>"property-change-delay"</type></link>.</para><para>The API in FolksDummy is unstable and may change wildly. It is designed mostly for use by libfolks unit tests.</para>
 *
 * Since: 0.9.7
 */
/**
 * FolksDummyPersonaClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-DUMMY-TYPE-PERSONA:CAPS"><literal>FOLKS_DUMMY_TYPE_PERSONA</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
